
MENU_05_ABC_ENVELOPE
	;; ---------------------------------[DO: SET CS F1-F8 BTN LED'S = OFF ]----------------------------------------
	;; ------------------------------------------------------------------------------------------------------------
	call	LED_F1_on	;; ENV SHAPE1
	call	LED_F2_on	;; ENV SHAPE2
	call	LED_F3_on	;; ENV SHAPE3
	call	LED_F4_on	;; ENV SHAPE4
	call	LED_F5_on	;; ENV SHAPE5
	call	LED_F6_on	;; ENV SHAPE6
	call	LED_F7_on	;; ENV SHAPE7
	call	LED_F8_on	;; ENV SHAPE8
	
	;; ---------------------------------[DO: Clear LCD                   ]-----------------------------------------
	;; ------------------------------------------------------------------------------------------------------------
	call    MIOS_LCD_Clear
	
	;; ---------------------------------[DO: WRITE MENU5 LCD TXT         ]-----------------------------------------
	;; ------------------------------------------------------------------------------------------------------------
	
MENU_05_ABC_ENVELOPE_JUMP_IN_POINT_FOR_LCD_REFRESH
	;; ----------------[DO WRITE ENVELOPE TIME (COARSE) VALUE ON LCD     ]-----------------------------------------
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_COASE
	call    MIOS_LCD_PrintString
	;; SET LCD POS ROW1 ENV. TIME COASE
	movlw   LCD_ROW1 + 0x0d
	call    MIOS_LCD_CursorSet
	movf    VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE, W
	call    MIOS_LCD_PrintBCD3
	

    ;; ---------------[DO WRITE ENVELOPE TIME (FINE) VALUE ON LCD        ]----------------------------------------
    TABLE_ADDR TEXT_AY_MENU_ENVELOPE_FINE
    call    MIOS_LCD_PrintString
    ;; SET LCD POS FOR ENV. PERIOD TIME FINE 
	movlw   LCD_ROW2 + 0x0d
    call    MIOS_LCD_CursorSet
	;; WRITE ENV PERIOD TIME FINE ON LCD
    movf    VAR_AY_CHIP_REG11_ENV_PERIOD_FINE, W
    call    MIOS_LCD_PrintBCD3

	;; ---------------[DO WRITE ENVELOPE SHAPE ON LCD                   ]-----------------------------------------
    TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE
    call    MIOS_LCD_PrintString

	;; FUNCTION:
	;; 1) TRANSLATE ENV SHAPE 1-8 (ENV SHAPES) to 0-15 (AY CHIP REG) 
	;; 2) Write Value to VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE (but do not write the VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;;    Value to AY Chip)
	;; 3) Set ENV CS LED
	call ENVELOPE_TRANSLATOR_CALL


	;; WRITE ENV 1|2|3|4|5|6|7|8 Text to LCD
	call WRITE_ENV_NAME_TO_LCD_CALL


	;; -------------[CHECK: ENV ON or OFF @ TONE A,B and C ?           ]------------------------------------------
    TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE
    call    MIOS_LCD_PrintString
	

    ;; ---[CHECK: ENVELOPE TONE A = ON OR OFF?    ]-------------
    btfsc VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
       	;; BIT 4 = SET
		;; ENV TONE A = ON
       	rgoto ENVELOPE_ON_TONE_A

		;; BIT 4 = CLEAR
		;; ENV TONE A = OFF
		;; ---[STATE: ENVELOPE TONE A = OFF      ]-------------
		TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_NOT_SET_A
		call    MIOS_LCD_PrintString
		rgoto 	CHK_ENVELOPE_TONE_B
		
ENVELOPE_ON_TONE_A
		;; ---[STATE: ENVELOPE TONE A = ON       ]-------------
		TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_SET_A
		call    MIOS_LCD_PrintString
    		

CHK_ENVELOPE_TONE_B
    ;; ---[CHECK: ENVELOPE TONE B = ON OR OFF?    ]-------------
	;; ---[CHECK: ENV (BIT4) SET or CLR ?         ]-------------
    btfsc VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
       	;; BIT 4 = SET
		;; ENV TONE B = ON
		rgoto ENVELOPE_ON_TONE_B
			
		;; BIT 4 = CLEAR
		;; ENV TONE B = OFF
		;; ---[STATE: ENVELOPE TONE B = OFF      ]-------------
		TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_NOT_SET_B
		call    MIOS_LCD_PrintString
		rgoto 	CHK_ENVELOPE_TONE_C

		
ENVELOPE_ON_TONE_B
	;; ---[STATE: ENVELOPE TONE B = ON       ]-------------
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_SET_B
    call    MIOS_LCD_PrintString


CHK_ENVELOPE_TONE_C
    ;; ---[CHECK: ENVELOPE TONE C = ON OR OFF?    ]-------------
	;; ---[CHECK: ENV (BIT4) SET or CLR ?         ]-------------
    btfsc VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
        ;; BIT 4 = SET
		;; ENV TONE C = ON      
		rgoto ENVELOPE_ON_TONE_C
	
		;; BIT 4 = CLEAR
		;; ENV TONE C = OFF
		;; ---[STATE: ENVELOPE TONE C = OFF      ]-------------	
		TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_NOT_SET_C
		call    MIOS_LCD_PrintString
		;; GO AND CHK SELECTED ITEM
		rgoto 	MENU5_CHK_SELECTED_ITEM_POS
		
ENVELOPE_ON_TONE_C
	;; ---[STATE: ENVELOPE TONE C = ON       ]-------------
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_MODE_SET_C
    call    MIOS_LCD_PrintString

	
;; ------------------------------------------------------------------------------------
;; -------[CHCK: CRS POS                     ]-----------------------------------------
;; ------------------------------------------------------------------------------------
MENU5_CHK_SELECTED_ITEM_POS 
	;; ---[CHK: CSR POS = 1 ?                ]-----------------------------------------
	;; ---[CHK: CSR POS @ ENV COASE PERIOD ? ]-----------------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ENVELOPE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS1								
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 					
			
		;; NO
		rgoto MENU5_CHK_CSR_POS2

		;; YES
		;; CSR POS = 1 
		;; CSR POS IS @ ENV COASE PERIOD
		;; WRITE ">"  @ CSR POS1 
		movlw 	CSR_POS_MENU5_ITEM1
		call    MIOS_LCD_CursorSet
		movlw   '~'
    	call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU5_ITEM1
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
		

MENU5_CHK_CSR_POS2
	;; ---[CHK: CSR POS = 2 ?                ]-----------------------------------------
	;; ---[CHK: CSR POS @ ENV FINE PERIOD ?  ]-----------------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ENVELOPE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS2				
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 	
			
		;; NO
		rgoto MENU5_CHK_CSR_POS3

		;; YES
		;; WRITE ">" @ CSR POS 2
		movlw 	CSR_POS_MENU5_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
    	call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU5_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR		
	
MENU5_CHK_CSR_POS3
	;; ---[CHK: CSR POS = 3 ?                ]-----------------------------------------
	;; ---[CHK: CSR POS @ ENV SHAPE ?        ]-----------------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ENVELOPE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS3				
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 	
			
		;; NO
		rgoto MENU5_CHK_CSR_POS4

		;; YES
		;; SELECTET ITEM (CSR POS) IS @ ENV SHAPE
		;; WRITE ">" ON EDIT POS3
		movlw 	CSR_POS_MENU5_ITEM3
		call    MIOS_LCD_CursorSet
		movlw   '~'
    	call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU5_ITEM3
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR	

MENU5_CHK_CSR_POS4
	;; NOTICE:
	;; ITEM4 not selectable anymore => ITEM4 is managed by BTN/CS
	;; ---------------------------------------------------------------------------------------
	;; ALL DONE EXIT HERE
	return



;; -----------------------------------------------------------------------------------------
;; -----------------------------------------------------------------------------------------



;; -----------------------------------------------------------------------------------------
;; -----------------[            ENVELOPE SUB ROUTINES              ]-----------------------
;; -----------------------------------------------------------------------------------------

;; -------------------------[ENVELOPE_TRANSLATOR_CALL]--------------------------------------
ENVELOPE_TRANSLATOR_CALL
;; FUNCTION:
;; SET AND TRANSLATE AY (YM) CHIP ENVELOPE SHAPE VALUES
;; SET ENV LED 1-8 @ CS 
;; USED BY MAIN MENU5 and ENV MIDI Controller 
;;
;; IN:
;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR
;;
;; OUT:
;; VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
;;
;; USES:
;; LED_Envelope_Shape_xxx calls

	;; ENVELOPE SHAPES TRANSLATION:
	;; VALUE IN => VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR DO TRANSLATE THE ENV SHAPE:
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 1 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 0-3 	=> \__		[LED 1]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 2 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 4-7 	=> /|_		[LED 2]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 3 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 8		=> |\|\		[LED 3]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 4 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 10		=> \/\/\	[LED 4]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 5 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 11		=> \|		[LED 5]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 6 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 12		=> /|/|		[LED 6]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 7 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 13		=> /		[LED 7]
	;; VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR: 8 => VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE: 14		=> /\/\		[LED 8]

	;; JUMP TO ENV SHAPE
	movf VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR, W
	JUMPTABLE_2BYTES 9 ;; [0-8 => ENV SHAPE 1-8]
		rgoto   MENU5_ABC_ENVELOPE_ENV_0_3_LED1		;; if CC < 1 set ENV 1
		rgoto   MENU5_ABC_ENVELOPE_ENV_0_3_LED1		;; ENV 1 [ENV LED 1]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_4_7_LED2		;; ENV 2 [ENV LED 2]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_8_LED3		;; ENV 3 [ENV LED 3]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_10_LED4		;; ENV 4 [ENV LED 4]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_11_LED5		;; ENV 5 [ENV LED 5]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_12_LED6		;; ENV 6 [ENV LED 6]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_13_LED7		;; ENV 7 [ENV LED 7]
		rgoto 	MENU5_ABC_ENVELOPE_ENV_14_LED8		;; ENV 8 [ENV LED 8]
		
	
	
MENU5_ABC_ENVELOPE_ENV_0_3_LED1
	;; SET ENV SHAPE 
	movlw 0x03
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; SET CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_1_on
			return

MENU5_ABC_ENVELOPE_ENV_4_7_LED2
	;; SET ENV SHAPE
	movlw 0x07
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_2_on
			return

MENU5_ABC_ENVELOPE_ENV_8_LED3
	;; SET ENV SHAPE
	movlw 0x08
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_3_on
			return


MENU5_ABC_ENVELOPE_ENV_10_LED4
	;; SET ENV SHAPE
	movlw 0x0A
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_4_on
			return

MENU5_ABC_ENVELOPE_ENV_11_LED5
	;; SET ENV SHAPE
	movlw 0x0B
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_5_on
			return


MENU5_ABC_ENVELOPE_ENV_12_LED6
    ;; SET ENV SHAPE
	movlw 0x0C
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_6_on
			return

MENU5_ABC_ENVELOPE_ENV_13_LED7
	;; SET ENV SHAPE
	movlw 0x0D
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_7_on
		 	return

MENU5_ABC_ENVELOPE_ENV_14_LED8
	;; SET ENV SHAPE
	movlw 0x0E
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE
	;; CS LED
	call LED_Envelope_Shape_all_off
	call LED_Envelope_Shape_8_on
			return

;; -------------------------[END: ENVELOPE_TRANSLATOR_CALL]------------------------------------------


;; --------------------------------------------------------------------------------------------------
;; --------------[ENV CS SUB ROUTINE: WRITE ENV 1-8 Text to LCD]-------------------------------------
;; --------------------------------------------------------------------------------------------------
WRITE_ENV_NAME_TO_LCD_CALL

;; WRITE THE ENV SHAPE NAME [1-8] TO LCD
	movf VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR, W
	JUMPTABLE_2BYTES 9 ;; [0-8 => ENV SHAPE 1-8]
		rgoto   WRITE_ENV_01_TO_LCD	;; ERROR - OUT OF RANGE
		rgoto   WRITE_ENV_01_TO_LCD	;; 1 [LED 1]
		rgoto 	WRITE_ENV_02_TO_LCD	;; 2 [LED 2]
		rgoto 	WRITE_ENV_03_TO_LCD	;; 3 [LED 3]
		rgoto 	WRITE_ENV_04_TO_LCD	;; 4 [LED 4]
		rgoto 	WRITE_ENV_05_TO_LCD	;; 5 [LED 5]
		rgoto 	WRITE_ENV_06_TO_LCD	;; 6 [LED 6]
		rgoto 	WRITE_ENV_07_TO_LCD	;; 7 [LED 7]
		rgoto 	WRITE_ENV_08_TO_LCD	;; 8 [LED 8]
		
	
	
WRITE_ENV_01_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_0_3
	call    MIOS_LCD_PrintString
		return

WRITE_ENV_02_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_4_7
	call    MIOS_LCD_PrintString
		return

WRITE_ENV_03_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_8
	call    MIOS_LCD_PrintString
		return

WRITE_ENV_04_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_10
	call    MIOS_LCD_PrintString
		return

WRITE_ENV_05_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_11
	call    MIOS_LCD_PrintString
		return


WRITE_ENV_06_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_12
    	call    MIOS_LCD_PrintString
    		return

WRITE_ENV_07_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_13
        call    MIOS_LCD_PrintString
	 	return

WRITE_ENV_08_TO_LCD
	TABLE_ADDR TEXT_AY_MENU_ENVELOPE_SHAPE_14
        call    MIOS_LCD_PrintString
  		return
;; --------------[END: ENV CS SUB ROUTINE: WRITE ENV 1-8 Text to LCD]---------------------------------
