;; ----------------------------------------------------------------------------------------
;; FUNCTION:
;; LOAD A MIDIBOX AY (YM) PATCH FROM EEPROM or BANKSTICK into PIC RAM
;; ----------------------------------------------------------------------------------------

PATCH_LOAD_ROUTINE
	;; -------------------------------------------------------------------------------------
	;; ----[DO: REFRESH  BNKD_VAR_PATCH_STATE_FLAGS	               ]----------------
	;; -------------------------------------------------------------------------------------
	;; 
	;; BANKSTICK AVAILABLE?
	;; CHECK AND WRITE BS AVAILABLE FLAG BIT
	;; @ patch_state_set_flags.inc
	call 	WRITE_FLAG_BANKSTICK_AVAILABLE
	;;
	;; BANKSTICK FORMATTED?
	;; CHECK IF BANKSTICK FINGERPRINT WAS WRITTEN 
	;; AT THE CURRENT BS PATCH & WRITE STATE FLAG
	;; @ patch_state_set_flags.inc
	call	WRITE_FLAG_CURRENT_PATCH_FINGERPRINT
	;;
	;; NOTE:
	;; INTERNAL PATCH (PIC EEPROM) IS ALWAYS AVAILABLE
	;; IF INTERNAL PATCH HAS NEVER BEEN WRITTEN OR HAS NO FINGERPRINT
	;; A DEFAULT PATCH WILL BE WRITTEN AT THE START UP
	;; SEE: WRITE_PIC_EEPROM_PATCH_0_INI @ midibox_ay_ini.inc and main.asm > USER_Init
	;; THERFORE THERE IS ALWAYS A INTERNAL PATCH 0 WITH A FINGERPRINT
	
	;; CURRENT PATCH = PIC EEPROM or BANKSTICK PATCH?
	;; WRITE BANKSTICK OR PIC EEPROM PATCH FLAG
	;; CHECK IF PATCH NUMBER = EEPROM (INTERNAL) or BANKSTICK Patch
	;; @ patch_state_set_flags.inc
	call 	WRITE_FLAG_SELECTED_PATCH_IS_EEPROM_OR_BANKSTICK
	;;
	;; ----[END: REFRESH  BNKD_VAR_PATCH_STATE_FLAGS	    ]---------------------------
	;; -------------------------------------------------------------------------------------
	
	
		;; ----------[STATE: YES, MENU1 = PATCH MENU (checked @ button_jumptable.inc) ]------
		;; ----------[CHECK: LOAD PATCH REQUEST FROM EEPROM or BANKSTICK?]---------------------------
		;; CHECK STATUS VIA VAR_PATCH_MENU_STATE_FLAGS
		;; BIT2 = CLR @ BNKD_VAR_PATCH_STATE_FLAGS -> LOAD THE PIC EEPROM PATCH
		;; BIT2 = SET @ BNKD_VAR_PATCH_STATE_FLAGS -> LOAD A BANKSTICK PATCH
		;; MEMO: LAST FLAG UPDATE @ main_menu_01_patch.inc
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_IF_SET_BS_PATCH_IS_SELECTED
				;; LOAD EEPROM PATCH (PIC INTERNAL PATCH)
				;; BIT2 = CLEAR = 0
				;; USER WANT TO LOAD A PATCH TO PIC RAM from EEPROM (INTERNAL PATCH)
				;; TO PIC RAM FROM PIC EEPROM
				;; --[STATE: SELECTED PATCH    = PIC EEPROM PATCH 0]------------------------
				;; --[NEXT : CHECK FINGERPRINT @ PIC EEPROM PATCH 0]------------------------
				;; GO ON WITH PIC EEPROM PATCH LOAD
				goto CHECK_PATCH_FINGERPRINT_PIC_EEPROM
		
		;; GO ON WIH BS PATCH LOAD
		;; ----------[STATE: YES, MENU = MAIN MENU1 = PATCH MENU ]------
		;; ----------[STATE: SELECTED PATCH = BANKSTICK PATCH    ]------
		;; ----------[CHECK: BS AVAILABLE?                       ]------
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_BANKSTICK_FOUND
					;; ---[STAE: BANKSTICK NOT AVAILABLE]--------------------------
					;; ---[DO: EXIT HERE                ]--------------------------
					;; BIT0 = 0 = NO BANKSTICK FOUND
					;; A BANKSTICK PATCH WAS SELECTED
					;; BY THE USER, BUT THERE WAS NO BANKSTICK FOUND
					;; SO EXIT HERE
					return
					
		;; BIT0 @ BNKD_VAR_PATCH_STATE_FLAGS = 1
		;; ---[STATE: BANKSTICK IS AVAILABLE            ]---------------------------
		;; ---[STATE: SELECTED PATCH = BANKSTICK PATCH  ]---------------------------
		;; ---[CHECK: BS FINGERPRINT FLAG OK(FORMATTED)?]---------------------------
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
				;; BIT1 = CLEAR = BANKSTICK IS *NOT* FORMATTED
				;; ---------------[STATE: BANKSTICK NOT FORMATTED]------------------
				;; SO THERE IS NO PATCH DATA TO LOAD
				;; EXIT HERE 
				return
		
		;; BIT1 @ BNKD_VAR_PATCH_STATE_FLAGS = SET 
		;; BANKSTICK IS FORMATTED :-)
		;; -------------[STATE: USER WAND TO LOAD A PATCH         ]------------------------
		;; -------------[STATE: SELECTED PATCH = BANKSTICK PATCH  ]------------------------
		;; -------------[STATE: BANKSTICK IS AVAILABLE            ]------------------------
		;; -------------[STATE: BANKSTICK IS FORMATTED            ]------------------------
		;; -------------[DO GO ON WITH: LOAD_PATCH_TO_PIC_RAM     ]------------------------
		goto 	LOAD_PATCH_TO_PIC_RAM
		;; --------------------------------------------------------------------------------


CHECK_PATCH_FINGERPRINT_PIC_EEPROM
	;; EEPROM INTERNAL PATCH FINGERRINT OK?
	;; BIT1 = 1 = PATCH FINGERPRINT OK
	;; BIT1 = 0 = PATCH FINGERPRINT NOT FOUND
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfss 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
		;; BIT1 = CLEAR = PIC EEPROM NO FINGERPRINT FOUND
		;; SO THERE IS NO PATCH DATA TO LOAD
		;; EXIT HERE 
		return
		
		;; FINGERPRINT FOUND OK
		;; -------------[STATE: USER WAND TO LOAD A PATCH             ]---------------------
		;; -------------[STATE: SELECTED PATCH = PATCH 0 (PIC EEPROM) ]---------------------
		;; -------------[STATE: PATCH 0 IS FORMATTED  (FINGERPRINT OK)]---------------------
		;; -------------[DO GO ON WITH: LOAD_PATCH_TO_PIC_RAM         ]---------------------
		;; ---------------------------------------------------------------------------------

LOAD_PATCH_TO_PIC_RAM
	;; LOAD PATCH NAME
	call 	SUB_ROUTINE_LOAD_PATCH_NAME
	;; LOAD PATCH DATA
	call	SUB_ROUTINE_LOAD_PATCH_WORKING_REGISTER
	;; LOAD PATCH FX DATA
	call	SUB_ROUTINE_DO_LOAD_PATCH_FX

;; ----------------------------------------------------------------------------------------
;; -------------[STATE: PATCH HAS BEEN LOADED TO PIC RAM             ]---------------------
;; ----------------------------------------------------------------------------------------

PATCH_LOAD_OK
	;; A NEW PATCH HAS BEEN LOADED SO RESET BIT5 + 6 @ BNKD_VAR_PATCH_STATE_FLAGS
	bcf		BNKD_VAR_PATCH_STATE_FLAGS, BIT5_PATCH_NAME_WAS_EDITED_BY_USER
	bcf		BNKD_VAR_PATCH_STATE_FLAGS, BIT6_PATCH_NAME_EDITING_MODE
	
	;; CLR CS LED's
	;; FOR A BETTER USER FEELING 
	;; LED's = OFF = WE DO LOAD THE PATCH NOW
	call	LED_F1_off
	call	LED_F2_off
	call	LED_F8_off

	;; AFTER LOADING THE PATCH: 
	;; CURRENT Patch = BROWSE PATCH
	movff	BNKD_VAR_BROWSE_PATCH_NR, BNKD_VAR_CURRENT_PATCH_NR
		

	;; PATCH HAS BEEN LOADED SO...
	call	SET_FLAG_PATCH_HAS_BEEN_WRITTEN_OR_LOADED

	;; ---[DO CHECK:  BIT7_MIDI_PROGRAMM_CHANGE_RECEIVED @ BNKD_VAR_PATCH_STATE_FLAGS = SET? ]---------------
	;; ---[IF BIT 7 = SET BRANCH HERE                                                        ]---------------
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP7
	GOTO_IFSET VAR_TMP7, BIT7_MIDI_PROGRAMM_CHANGE_RECEIVED,  ACCESS, PATCH_LOAD_FINISH_PROGRAMM_CHANGE_REQUEST

	;; ---[GO ON HERE, IF A PATCH LOAD WAS EXECUTED BY THE USER @ MBAY CS                    ]---------------
	;; WRITE ASC. NAME @ LCD ROW1
	;; subfunction @ main_menu_01_patch_subroutines.inc
	call 	SUB_ROUTINE_WRITE_PATCH_NAME_ON_LCD
		
	;; INFO ON LCD:
	;; LOADING PATCH DATA OK
	TABLE_ADDR LCD_CLEAR_ROW4
	call    MIOS_LCD_PrintString
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_LOAD_OK
	call    MIOS_LCD_PrintString
		
	;; CLEAR THE =>!<= @ ROW1
	;; PERHAPS THERE WAS A: =>!<= [PATCH NAME] ON LCD ROW1 
	;; LETS CLEAR THE "!"
	;; BECAUSER NOW THE LOADED PATCH HAS BECOME THE *CURRENT PATCH*
	;; SO NOW THE CURRENT PATCH = BROWSE PATCH
	movlw   LCD_ROW1 + 6
    call    MIOS_LCD_CursorSet
	movlw   ' '
    call    MIOS_LCD_PrintChar
	
	;; CLR LCD ROW3
	TABLE_ADDR LCD_CLEAR_ROW3
	call MIOS_LCD_PrintString

	;; ##############################################################################################
	;; DO A LITTLE DELAY THAT THE USER CAN READ 
	;; THE "LOAD: OK" ON LCD ROW 4
	clrf	VAR_TMP_PATCH_DATA_CLIPBOARD
PATCH_LOAD_DO_DELAY_FOR_LCD
	movlw   250
    call	MIOS_Delay
    incf	VAR_TMP_PATCH_DATA_CLIPBOARD, F
    movlw	0x03	;; DO THE "HOW LONG" TIME JUSTAGE HERE 
    cpfsgt	VAR_TMP_PATCH_DATA_CLIPBOARD
		;; DO DELAY CYCLE
		goto	PATCH_LOAD_DO_DELAY_FOR_LCD
		
		;; RENEW / WRITE MENU1 on LCD
		goto MENU_01_PATCH
	;; --------------[STATE: CS PATCH LOAD IS FINISHED ]---------------------------------------------
	;; ##############################################################################################



	;; ---[GO ON HERE, IF A PATCH LOAD WAS REQUESTED BY A MIDI PROGRAM CHANGE EVENT  ]---------------
PATCH_LOAD_FINISH_PROGRAMM_CHANGE_REQUEST
	;; DO CLR STATE FLAG: 
	;; CLR: Patch Change Request Flag (BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS)
	;; BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS = 0 = CLR MIDI PROGRAM CHANGE EVENT 
	;; NOW THE MIDI PROGRAM CHANGE EVENT HAS BEEN CLEARD
	;; BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS = 0 = NO PROGRAM CHANGE EVENT 
 	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP7
 	bcf		VAR_TMP7, BIT7_MIDI_PROGRAMM_CHANGE_RECEIVED
 	movff	VAR_TMP7, BNKD_VAR_PATCH_STATE_FLAGS
 	
 	;; SET MAIN MENU = 1 (PATCH MENU)
 	movlw 	CONST_MAIN_MENU_01
	movwf	VAR_CURRENT_MAIN_MENU
	;; SET CSR POS @ MAIN MENU 0 = 1 (REMEMBER PATCH MENU @ MAIN MENU0 (MENU OVERVIEW))
	movff	VAR_CURRENT_MAIN_MENU, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_CHOICE_MENU

	;; RENEW / WRITE MENU1 on LCD
	goto MENU_01_PATCH

;; ----------------------------------------------------------------------------------------
;; -------------[               END OF PATCH LOADING ROUTINE         ]---------------------
;; ----------------------------------------------------------------------------------------


