
	;; FUNCTION:
	;; BUTTON AUTO REAPEAT
	;; CSR BLINKING
	;; --------------------------------------------------------------------------
	;; CHECK 
	;; @ [+] BTN
	;; @ [-] BTN


CHECK_BTN_AUTO_REPEAT
	;; JUMPED IN HERE FROM USER_Tick @ main.asm
	;; -----------------[START: CHECK KEY STATE]---------------------------------
	;; BTN HANDLING
	;; IF A BTN
	;; IS = PRESSED   (BTN STATE  = 0)
	;; IS = DEPRESSED (BTN STATE  = 1)
	movlw 	CONST_PRESSED_BTN_STATE_VALUE0	
	cpfseq 	VAR_CURRENT_DIN_BTN_STATE
		
			;; -[BTN STATE = DEPRESSED]                                        ]--
			;; -[DO RESET BTN AUTO REPEAT COUNTER AND FLAGS                    ]--
			goto	DO_RESET_ALL_BTN_AUTO_REPEAT_COUNTER_AND_FLAGS
		
			;; BTN = PRESSED
			;; SO GO ON WITH BTN AUTO REPEAT ROUTINE

	;; --------------------------------------------------------------------------
	;; ------------------[GENERAL BTN AUTO REPEAT HANDLING]----------------------
	;; --------------------------------------------------------------------------
    
	;; VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER 	--> = 0 AFTER STARTUP (midibox_ay_ini.inc)
	;; CONST_BTN_AUTO_REPEAT_RATE			--> app_defines.h 
	
	;; ------[CHECK: VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER                      ]--
	;; ------[VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER = CONST_BTN_AUTO_REPEAT_RATE]--
    movlw 	CONST_BTN_AUTO_REPEAT_RATE				
    cpfseq 	VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER		
		
		;; CONST_BTN_AUTO_REPEAT_RATE < > VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER
		;; DO INC VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER 
		rgoto DO_INC_GENERAL_BTN_RATE_COUNTER_AND_EXIT
		
		;; CONST_BTN_AUTO_REPEAT_RATE = VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER
		;; GO ON WITH BTN AUTO REPEAT
		rgoto DO_GO_ON_BTN_AUTO_REPEAT

DO_INC_GENERAL_BTN_RATE_COUNTER_AND_EXIT
			;; INC COUNTER
			incf VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER, F
			;; EXIT HERE
			return

DO_GO_ON_BTN_AUTO_REPEAT
	;; GO ON WITH BTN AUTO REPEAT ROUTINE
	;; BUT FIRST DO RESET THE "GENERAL KEY RATE TIME" COUNTER TO 0
	clrf VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER
	

	;; -------[CHECK IF THE [+] BTN HAD BEEN PRESSED]----------------------
	;; -------[DO WE HAVE A [+] BTN AUTO REPEAT?    ]----------------------
	movlw 	CONST_BTN_VALUE_INC	
	cpfseq 	VAR_CURRENT_DIN_BTN_VALUE

		;; NO,
		;; CONST_BTN_VALUE_INC <> VAR_CURRENT_DIN_BTN_VALUE
		;; SO THERE IS NO [+] BTN PRESSING
		;; ---[GO AND CHECK THE [-] BTN             ]---------------------
		rgoto DO_CHECK_MINUS_BTN

	;; -------[STATE: YES THE [+] BTN IS PRESSED                  ]-------
	;; -------[DO: CHECK THE "FIRST KEY STRIKE DELAY" BIT         ]-------
	;; 
	;; THE "BTN IS PRESSED THE FIRST TIME RIGHT NOW" DELAY BIT
	;; --------------------------------------------------------------------
	;; NOTE: BEFORE A "AUTO REPEAT BTN EVENT" WILL BE PERFORMED 
	;; THE "BTN IS PRESSED THE FIRST TIME RIGHT NOW" DELAY BIT
	;; MUST HAVE BEEN SET - SO, WE HAVE TO CHECK IF THE BTN 
	;; WAS PRESSED "THE FIRST TIME RIGHT NOW".
	
	;; ------[CHECK: IS THE "BTN PERMANENT PRESSSED BIT" ALREADY SET?        ]------------------
	;; ------[DO: CHECK IS BIT0 OF VAR_BTN_SPECIAL_FLAGS = SET?              ]------------------
	btfss 	VAR_BTN_SPECIAL_FLAGS, CONST_BIT0_BTN_PERMANENT_PRESSED

		
		;; NO,
		;; CONST_BIT0_BTN_PERMANENT_PRESSED = CLR
		;; THE "ONE LOOP DELAY BIT" HAD NOT ALREADY BEEN SET 
		;; SO PERFORM A "FIRST BTN STRIKE DELAY" CYCLE
		;; --[STATE: DO A "FIRST BTN STRIKE DELAY" CYCLE]--------------------------------------
		rgoto PLUS_BTN_FIRST_STRIKE_DELAY_CYCLE
		
		;; YES,
		;; CONST_BIT0_BTN_PERMANENT_PRESSED = SET
		;; --[STATE: DO *NO* "FIRST BTN STRIKE DELAY" CYCLE ]------------------------------------
		;; --[DO: GO ON WITH THE AUTO REPEAT CYCLE   [+] BTN]------------------------------------
		rgoto PLUS_BTN_AUTO_REPEAT_DELAY_CYCLE
		
		


	;; ------[DO START A "FIRST KEY STRIKE DELAY" CYCLE @ [+] BTN                  ]----------		
PLUS_BTN_FIRST_STRIKE_DELAY_CYCLE
	;; ---------------------------------------------------------------------------------------
	;; MEMO: WHEN A KEY IS PRESSED THE *FIRST TIME*
	;; THERE MUST BE A SHORT DELAY FOR BETTER
	;; AUTO REPEAT BTN HANDLING
	;; ---------------------------------------------------------------------------------------

	;; ------[DO: CHECK "FIRST STRIKE COUNTER" VALUE                            ]-------------
	;; ------[CHECK: FIRST STRIKE COUNTER = CONST_FIRST_BTN_STRIKE_CYCLE_TIME ? ]-------------
	movlw  CONST_FIRST_BTN_STRIKE_CYCLE_TIME	
	cpfseq VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER	

		;; NO,
		;; "FIRST STRIKE COUNTER" < CONST_FIRST_BTN_STRIKE_CYCLE_TIME
		;; --[STATE: GO AND DO INC THE "FIRST STRIKE COUNTER" +1                ]--------------
		rgoto PLUS_BTN_DO_INC_VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER

		;; YES,
		;; VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER == CONST_FIRST_BTN_STRIKE_CYCLE_TIME
		;; --[DO: *RESET* VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER                    ]--------------
		;; --[DO: *CLEAR* THE "FIRST KEY STRIKE DELAY" BIT                      ]--------------
		;; --[DO: EXIT "FIRST KEY STRIKE DELAY CYCLE"                           ]--------------
		rgoto PLUS_BTN_DO_FINISH_FIRST_KEY_STRIKE_DELAY
	
PLUS_BTN_DO_INC_VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER
	    ;; INC VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER +1
	    incf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER, F
		;; EXIT HERE
		return

PLUS_BTN_DO_FINISH_FIRST_KEY_STRIKE_DELAY
	;; ---[STATE: "CONST_BIT0_BTN_PERMANENT_PRESSED" CYCLE IS PERFORMD                   ]---------------
	;; ---[DO: RESET THE "FIRST KEY STRIKE DELAY" COUTER                       ]---------------
	clrf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER

	;; ---[DO: SET THE "CONST_BIT0_BTN_PERMANENT_PRESSED" BIT                  ]---------------
	;; MEMO: IF WE DO SO THE NEXT USER TICK CYCLE 
	;; WILL *NOT* BE HERE
	bsf VAR_BTN_SPECIAL_FLAGS, CONST_BIT0_BTN_PERMANENT_PRESSED
	;; EXIT HERE
	return

;; ---------------------[END OF "FIRST BTN STRIKE DELAY" CYCLE AREA | [+] BTN]-----------------
;; --------------------------------------------------------------------------------------------
;; --------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------
;; -------[START OF THE [+] BTN "AUTO REPEAT DELAY CYCLE"]-------------------------------------
;; --------------------------------------------------------------------------------------------

PLUS_BTN_AUTO_REPEAT_DELAY_CYCLE
	;; ---[STATE: THE [+] BTN HAD BEEN PRESSED                    ]----------------------------
	;; ---[STATE: THE THE BTN PERMANENT PRESSED BIT HAD BEEN SET  ]----------------------------
	;; ---[DO CHECK IF WE CAN GO ON                               ]----------------------------
	movlw 	CONST_KEY_AUTO_REPEAT_TIME
	cpfseq 	VAR_BTN_AUTO_REPEAT_COUNTER

		;; NO,
		;; CONST_KEY_AUTO_REPEAT_TIME < VAR_BTN_AUTO_REPEAT_COUNTER
		rgoto PLUS_BTN_DO_INC_KEY_AUTO_REPEAT_CUNTER

		;; CONST_CONST_KEY_AUTO_REPEAT_TIME == VAR_BTN_AUTO_REPEAT_COUNTER
		rgoto DO_PLUS_BTN_DO_AUTO_REPEAT

PLUS_BTN_DO_INC_KEY_AUTO_REPEAT_CUNTER
		;; --[DO: INC VAR_BTN_AUTO_REPEAT_COUNTER +1             ]-----------------------------
		incf VAR_BTN_AUTO_REPEAT_COUNTER, F
		;; EXIT HERE
	 	return

;; -------------------------[DO AUTO REPEAT [+] KEY]-------------------------------------------
;; --------------------------------------------------------------------------------------------
DO_PLUS_BTN_DO_AUTO_REPEAT
	    ;; ---[DO RESET THE VAR_BTN_AUTO_REPEAT_COUNTER        ]-----------------------------
	    clrf  VAR_BTN_AUTO_REPEAT_COUNTER
	    ;; ---[DO [+] BTN AUTO REPEAT EVENT @ CURRENT MENU     ]-----------------------------		  
		goto PLUS_BTN_DO_CHECK_MENU
;; --------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------
;; -------------------------[END OF AUTO REPEAT [+] KEY AREA]----------------------------------
;; --------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------
;; -------------------------[START OF AUTO REPEAT [-] KEY AREA]--------------------------------
;; --------------------------------------------------------------------------------------------

;; -------------------------[DO CHECK THE [-] KEY]---------------------------------------------
DO_CHECK_MINUS_BTN	
	;; CHECK:
	;; IS THE CURRENT BTN = [-] BTN
	movlw 	CONST_BTN_VALUE_DEC
	cpfseq 	VAR_CURRENT_DIN_BTN_VALUE

			;; NO,
			;; CONST_BTN_VALUE_DEC < > VAR_CURRENT_DIN_BTN_VALUE
			;; THE [-] BTN IS THE LAST BTN TO CHECK SO
			;; QUIT THE AUTO BTN REPEAT ROUTINE
			rgoto DO_RESET_ALL_BTN_AUTO_REPEAT_COUNTER_AND_FLAGS

		;; YES,
		;; CONST_BTN_VALUE_DEC = VAR_CURRENT_DIN_BTN_VALUE
		;; [-] BTN IS PRESSED, SO GO ON
;; -----------------[CHECK: "FIRST KEY STRIKE DELAY" BIT]----------------------------------------

	;; CHECK THE "BTN PERMANENT PRESSSED BIT"
	;; --------------------------------------
	;; MEMO: 
	;; BEVOR A "AUTO REPEAT BTN" EVENT WILL TAKE PLACE
	;; THE IS A NEED FOR A LITTLE DELAY TIME FOR
	;; A BETTER USER BTN HANDLING. THE "BTN PERMANENT PRESSSED BIT" @ VAR_BTN_SPECIAL_FLAGS
	;; WILL DO THIS JOB. 
	;; FIRST OF ALL THE "BTN PERMANENT PRESSSED BIT" = CLR
	;; IF THE [-] BTN IS PRESSED A LONGER POERIOD OF TIME THE "BTN PERMANENT PRESSSED BIT"
	;; WILL BE = SET
	
	;; NOW WE WILL CHECK IF THE "BTN PERMANENT PRESSSED BIT" ALREADY HAD BEEN SET
	btfss 	VAR_BTN_SPECIAL_FLAGS, CONST_BIT0_BTN_PERMANENT_PRESSED

		; THE BIT0 @ VAR_BTN_SPECIAL_FLAGS  = CLR
		rgoto MINUS_BTN_FIRST_KEY_STRIKE_DELAY_CYCLE		

		; THE BIT0 @ VAR_BTN_SPECIAL_FLAGS  = SET
		rgoto MINUS_KEY_AUTO_REPEAT_DELAY_CYCLE

;; --------------------------------------------------------------------------------------
;; -----------------------[START OF "FIRST BTN STRIKE DELAY" CYCLE | [-] BTN]------------
;; --------------------------------------------------------------------------------------

MINUS_BTN_FIRST_KEY_STRIKE_DELAY_CYCLE
	;; NOW CHECK THE "BTN PERMANENT PRESSSED BIT" CUNTER CYCLE
	movlw  CONST_FIRST_BTN_STRIKE_CYCLE_TIME
	cpfseq VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER

		;; NO,
		;; COUNTER < TIME
		;; SO INC COUNTER +1
		rgoto MINUS_BTN_DO_INC_VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER

		;; YES
		;; VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER = CONST_FIRST_BTN_STRIKE_CYCLE_TIME
		;; EXIT "FIRST KEY STRIKE DELAY CYCLE" AND
		;; DO *RESET* VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER
		;; DO *SET* THE "BTN PERMANENT PRESSSED" BIT 
		rgoto MINUS_KEY_DO_FINISH_FIRST_KEY_STRIKE_DELAY_CYCLE
	

MINUS_BTN_DO_INC_VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER
	    ;; INC "FIRST KEY STRIKE DELAY" COUNTER +1
	    incf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER, F
		;; EXIT HERE
		return

MINUS_KEY_DO_FINISH_FIRST_KEY_STRIKE_DELAY_CYCLE
		;; FIRST SET "FIRST KEY STRIKE DELAY CYCLE" COUNTER TO ZERO
		clrf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER

		;; ---[DO: SET THE "CONST_BIT0_BTN_PERMANENT_PRESSED" BIT                  ]---------------
		;; MEMO: IF WE DO SO THE NEXT USER TICK CYCLE 
		;; WILL *NOT* EXIT HERE
		bsf VAR_BTN_SPECIAL_FLAGS, CONST_BIT0_BTN_PERMANENT_PRESSED			
		;; EXIT HERE
		return
	
;; -----------------------[END OF "FIRST KEY STRIKE DELAY" CYCLE AREA | [-] KEY]---------
;; --------------------------------------------------------------------------------------
		
;; --------------------------------------------------------------------------------------
;; ----------------------[START OF THE [-] KEY "AUTO REPEAT DELAY CYCLE"]----------------
;; --------------------------------------------------------------------------------------
MINUS_KEY_AUTO_REPEAT_DELAY_CYCLE
	;; NOW WE RUN THE MINUS KEY "ONE STEP AUTO REPEAT" CYCLE 
	;; CONST_CONST_KEY_AUTO_REPEAT_TIME= VAR_BTN_AUTO_REPEAT_COUNTER ?
	movlw  CONST_KEY_AUTO_REPEAT_TIME
	cpfseq VAR_BTN_AUTO_REPEAT_COUNTER

		;; NO,
		;; CONST_CONST_KEY_AUTO_REPEAT_TIME< > VAR_BTN_AUTO_REPEAT_COUNTER
		rgoto MINUS_BTN_INC_AUTO_REPEAT_CYCLE_COUNTER

		;; YES,
		;; CONST_CONST_KEY_AUTO_REPEAT_TIME= VAR_BTN_AUTO_REPEAT_COUNTER
		rgoto MINUS_KEY_FINISH_AUTO_REPEAT_DELAY_CYCLE


MINUS_BTN_INC_AUTO_REPEAT_CYCLE_COUNTER
	 		;; INC VAR_BTN_AUTO_REPEAT_COUNTER +1
			incf VAR_BTN_AUTO_REPEAT_COUNTER, F
	 		;; EXIT HERE
			return

MINUS_KEY_FINISH_AUTO_REPEAT_DELAY_CYCLE
	;; NOW THE [-] BTN PRESSING TAKE PLACE
	
	;; BUT DO NOT FORGET TO
	;; RESET THE COUNTERS
	clrf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER
	clrf VAR_BTN_AUTO_REPEAT_COUNTER
		
	;; [-] KEY WAS PRESSED SO NOW
	;; JUMP TO [-] SUBMENU FUNCTION JUMP TABLE
	goto 	MINUS_BTN_DO_CHECK_MENU

;; -------------------------[END OF AUTO REPEAT [-] KEY AREA]------------------
;; ----------------------------------------------------------------------------


;; ----------------------------------------------------------------------------



;; ---------------------------------------[EXIT]-------------------------------
DO_RESET_ALL_BTN_AUTO_REPEAT_COUNTER_AND_FLAGS

		;; RESET AUTO BTN TIME BANDITS TO 0
		clrf VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER
		clrf VAR_FIRST_BTN_STRIKE_CYCLE_COUNTER
		clrf VAR_BTN_AUTO_REPEAT_COUNTER

	   	;; ACHTUNG: 
	   	;; SOLLTEN SPAETER WEITER TASTEN
	   	;; MIT IN DIESE ROUTINE EINGEFÜGT WERDEN,
	   	;; SO MUSS IMMER NACH DEM LETZTEN LOSLASSEN DES BETREFFENDEN TASTERS
	   	;; DAS "ONE EXTRA LOOP DELAY BIT" GELÖSCHT WERDEN,
	   	;; WIE ES HIER AN DIESER STELLE DER FALL IST.
	   	;; 
	   	;; ERLAEUTERUNG:
	  	;; DAS "ONE LOOP DELAY BIT" MUSS IMMER AUTOMATISCH
	  	;; GESETZT WERDEN, WENN KEINE GESUCHTE TASTE IN DIESEM FALL 
	  	;; DIE [+] oder [-] TASTE GEDRUECKT WERDEN.
	  	;; HIER NUN WIRD, WENN KEINER DER BEIDEN GESUCHTEN
	  	;; TASTEN GEDRUECKT WIRD DANN DAS "ONE LOOP DELAY BIT" GESETZT
	  	;; WELCHES ERST DURCH DEN ERSTEN [+] oder[-] TASTENDRUCK
	  	;; WIEDER GELOESCHT WIRD.
	  	;; DAS DELAY BIT VERHINDER, DASS
	  	;; BEIM ERSTEN TASTENDRUCK DIE ZUR TASTE ZUGEHÖRIGE ROUTINE 
	  	;; 2x AUSGELÖSST WIRD UND SORGT ZUSÄTZLICH 
	 	;; DURCH EINEN TIME BANDIT FÜR EINE KLEINE 
	 	;; "EXTRA PAUSE".
	 	;; 
		;; CLR THE "ONE EXTRA LOOP DELAY BIT"
		bcf VAR_BTN_SPECIAL_FLAGS, CONST_BIT0_BTN_PERMANENT_PRESSED

		;; EXIT HERE
		return	

