;; FUNCTION:
;; CS BUTTON HANDLING
;; A BTN HAS BEEN PRESSED
;; JUMP AND DO A BTN ROUTINE IF THERE IS ANY


BTN_VALUE_TO_ROUTINE_SWITCH_BOARD
	;; BTN HANDLING 
	;; CHECK: BUTTON PRESSED ? 		
	;; EXIT IF A BTN WAS JUSST DEPRESSED
	movlw  CONST_PRESSED_BTN_STATE_VALUE0		
	cpfseq VAR_CURRENT_DIN_BTN_STATE			
			;; BUTTON WAS DEPRESSED
			;; EXIT HERE
			return

	;; ------------[STATE: A BUTTON WAS PRESSED                 ]--------------------	
	;; ------------------------------------------------------------------------------
	
	;; ------------------------------------------------------------------------------
	;; ----[CHECK: PATCHNAME EDITING MODE = SET (ON)            ]--------------------
	movff 	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT6_PATCH_NAME_EDITING_MODE
			;; ----[STATE: PATCHNAME EDITING MODE = SET (ON)    ]--------------------
			;; ====> patch_name_edit.inc
			goto PATCH_NAME_EDITING
	
	;; ----[STATE: PATCHNAME EDITING MODE = CLR (OFF)          ]---------------------
	;; ----[GO ON WITH BTN PROCESSING                          ]---------------------
	;; ------------------------------------------------------------------------------

	;; ------------------------------------------------------------------------------
	;; DO CHECK:
	;; CURRENT MENU ?
	;; ------------------------------------------------------------------------------
	movf VAR_CURRENT_MAIN_MENU, W
	JUMPTABLE_4BYTES 9	;; [MENU 0 - 8]
		goto	CHECK_BTN_VALUE_MENU0
		goto	CHECK_BTN_VALUE_MENU1
		goto	CHECK_BTN_VALUE_MENU2
		goto	CHECK_BTN_VALUE_MENU3
		goto	CHECK_BTN_VALUE_MENU4
		goto	CHECK_BTN_VALUE_MENU5
		goto	CHECK_BTN_VALUE_MENU6
		goto	CHECK_BTN_VALUE_MENU7
		goto	CHECK_BTN_VALUE_MENU8

	;; -----------------------------------------------------------------------------------------------------------
	;; ------------------------------[BTN VALUE INTERPRETATION @ MENU [0-8]                   ]-------------------


;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 0                       ]-------------------
CHECK_BTN_VALUE_MENU0
	;; MENU0 -> Menu Overview (SELECT MENU 1-8)
	;; -----------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> NO FUNC. @ MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> SELECT MAIN MENU1-8
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURSOR POS -1 (permanent)
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURSOR POS +1 (permanent)
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> SELECT MENU1
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> SELECT MENU2
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> SELECT MENU3
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> SELECT MENU4
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> SELECT MENU5
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> SELECT MENU6
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> SELECT MENU7
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> SELECT MENU8
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	
	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; ESC @ MENU0 = DO NOTHING
			return
	
	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 0 -> DO SELECT MENU [1-8]
			goto	BTN_SUB_ROUTINE_SELECT_MENU_0


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 0
			goto	SUB_ROUTINE_BTN_ITEM_UP_MENU0

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 0
			goto	SUB_ROUTINE_BTN_ITEM_DOWN_MENU0

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD JUMP ITEM POS LEFT @ MENU 0
			goto	BTN_LEFT_MENU0

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD JUMP ITEM POS RIGHT @ MENU 0
			goto	BTN_RIGHT_MENU0

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURSOR POS -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; DEC VALUE BTN -> REDERECT TO -> LCD ITEM POS +1 (!)  @ MENU 0
			goto	SUB_ROUTINE_BTN_ITEM_DOWN_MENU0
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURSOR POS +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; INC VALUE BTN -> REDERECT TO -> LCD ITEM POS -1 (!)  @ MENU 0
			goto	SUB_ROUTINE_BTN_ITEM_UP_MENU0

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> GO TO MENU1
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU1
			goto	SWITCH_TO_MENU_1

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> GO TO MENU2
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU2
			goto	SWITCH_TO_MENU_2


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> GO TO MENU3
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU3
			goto	SWITCH_TO_MENU_3


	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> GO TO MENU4
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU4
			goto	SWITCH_TO_MENU_4


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> GO TO MENU5
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU5
			goto	SWITCH_TO_MENU_5


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> GO TO MENU6
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU6
			goto	SWITCH_TO_MENU_6


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> GO TO MENU7
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU7
			goto	SWITCH_TO_MENU_7

	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> GO TO MENU8
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; GO TO MENU8
			goto	SWITCH_TO_MENU_8


	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP

;; ----------------------------------[             END MENU 0            ]----------------------------------------
;; ---------------------------------------------------------------------------------------------------------------

;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 1  ]----------------------------------------
;; ---------------------------------------------------------------------------------------------------------------
CHECK_BTN_VALUE_MENU1
	;; MENU1 -> Patch Menu (SELECT PATCH, STORE/LOAD PATCH, FORMAT BS)
	;; -----------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> PATCH NAME POS -1 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> PATCH NAME POS +1 
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1 (permanent)
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1 (permanent)
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> LOAD SELECTED PATCH
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> SAVE SELECTED PATCH
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> FORMAT BS
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)

	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 1 -> EXIT TO MENU 0
			goto	SWITCH_TO_MENU_0

	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL @ MENU 1
			;; TOGGLE PATCH NAME EDITING MODE
			goto 	BTN_SUB_ROUTINE_SELECT_MENU_1


	;; ITEM UP 	-> VAR_CURRENT_DIN_BTN_VALUE = 2		-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 1
			;; SUB_ROUTINE_BTN_ITEM_UP_MENU1 @ sub_routine_button_up.inc
			goto	SUB_ROUTINE_BTN_ITEM_UP_MENU1

	;; ITEM DWN	-> VAR_CURRENT_DIN_BTN_VALUE = 3		-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 1
			;; SUB_ROUTINE_BTN_ITEM_DOWN_MENU1 @ sub_routine_button_down.inc
			goto	SUB_ROUTINE_BTN_ITEM_DOWN_MENU1

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; REDIRECT TO [-] => VALUE = VALUE -1
			;; MINUS_BTN_MENU1 @ sub_routine_button_minus_menu_1.inc
			goto	MINUS_BTN_MENU1

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; REDIRECT TO [+] => VALUE = VALUE +1
			;; PLUS_BTN_MENU1 @ sub_routine_button_plus.inc
			goto	PLUS_BTN_MENU1

	;; VALUE DWN	-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; VALUE DWN => VALUE = VALUE -1
			;; MINUS_BTN_MENU1 @ sub_routine_button_minus_menu_1.inc
			goto	MINUS_BTN_MENU1
	
	;; VALUE UP		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; VALUE UP => VALUE = VALUE +1
			;; PLUS_BTN_MENU1 @ sub_routine_button_plus.inc
			goto	PLUS_BTN_MENU1

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> FUNCTION: LOAD PATCH
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; DO LOAD PATCH 
			goto	PATCH_LOAD_ROUTINE

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; DO SAVE PATCH 
			goto	PATCH_WRITE_ROUTINE


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; NOTHING YET
			return

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; NOTHING YET
			return


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; NOTHING YET
			return


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; NOTHING YET
			return


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; NOTHING YET
			return


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> DO FORMAT BS
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; DO FORMAT BS 
			goto FORMAT_BANKSTICK_ROUTINE


	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP


;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 2  ]----------------------------------------
CHECK_BTN_VALUE_MENU2
	;; MENU2 -> (DE) Tune ABC Menu
	;; ------------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1 (permanent)
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1 (permanent)
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	

	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 2 -> EXIT TO MENU 0
			goto	SWITCH_TO_MENU_0

	
	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 2 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 2
			goto	SUB_ROUTINE_BTN_ITEM_UP_MENU2

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 2
			goto	SUB_ROUTINE_BTN_ITEM_DOWN_MENU2

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT
			goto	BTN_LEFT_MENU2

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			goto	BTN_RIGHT_MENU2

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			goto	MINUS_BTN_MENU2
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			goto 	PLUS_BTN_MENU2

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP


;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 3  ]----------------------------------------
CHECK_BTN_VALUE_MENU3
	;; MENU3 -> Mixer Menu (Tone ABC On/Off, ADD Noise @ ABC on/off, Fx TAB ABC on/off)
	;; --------------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> -
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> -
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> - 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> -
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1 (permanent)
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1 (permanent)
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	
	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 3 -> EXIT
			goto	SWITCH_TO_MENU_0

	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 3 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 3
			;; JUST ITEM 3 @ MENU 3
			return

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 3
			;; JUST ITEM 3 @ MENU 3
			return

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT
			;; REDERECT -> MINUS BTN
			goto	MINUS_BTN_MENU3

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			;; REDERECT -> PLUS BTN
			goto	PLUS_BTN_MENU3

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			;; THERE IS JUST ITEM 3 (NOISE FREQ)
			goto	MINUS_BTN_MENU3
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			;; THERE IS JUST ITEM 3 (NOISE FREQ)
			goto	PLUS_BTN_MENU3

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP


;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 4  ]----------------------------------------
CHECK_BTN_VALUE_MENU4
	;; MENU4 -> Volume Control
	;; -----------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> - 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> -
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)

	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 4 -> EXIT
			goto	SWITCH_TO_MENU_0


	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 4 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 4
			goto	BTN_ITEM_UP_MENU4

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 4
			goto 	BTN_ITEM_DOWN_MENU4

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT
			;; REDIRECT to VALUE -1
			goto MINUS_BTN_MENU4

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			;; REDIRECT TO >> +1 VALUE
			goto	PLUS_BTN_MENU4

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			goto MINUS_BTN_MENU4
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			goto	PLUS_BTN_MENU4

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> Toggle ENV ON OFF @ TONE A
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE A ON/OFF
			goto	BTN_ENV_A_BEEN_PRESSED

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> Toggle VELOCITY ON OFF @ TONE A
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE VELOCITY @ TONE A
			goto 	F2_MENU3


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> Toggle ENV ON OFF @ TONE B
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE B ON/OFF
			goto	BTN_ENV_B_BEEN_PRESSED

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> Toggle VELOCITY ON OFF @ TONE B
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE VELOCITY @ TONE B
			goto 	F4_MENU3


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> Toggle ENV ON OFF @ TONE C
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE C ON/OFF
			goto	BTN_ENV_C_BEEN_PRESSED


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> Toggle VELOCITY ON OFF @ TONE C
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE VELOCITY @ TONE C
			goto 	F6_MENU3


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; -
			return


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; -
			return


	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP
	
;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 5  ]----------------------------------------
CHECK_BTN_VALUE_MENU5
	;; MENU5 -> Envelope Control
	;; -----------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> - 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> -
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> ENV1
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> ENV2
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> ENV3
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> ENV4
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> ENV5
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> ENV6
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> ENV7
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> ENV8
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	
	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 5 -> EXIT
			goto	SWITCH_TO_MENU_0

	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 5 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 5
			goto	BTN_ITEM_UP_MENU5

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 5
			goto 	BTN_ITEM_DOWN_MENU5

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT
			;; REDERECT TO VALUE -1
			goto MINUS_BTN_MENU5

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			;; REDIRECT TO VALUE +1
			goto	PLUS_BTN_MENU5

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			;; VALUE -1
			goto MINUS_BTN_MENU5
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			;; VALUE +1
			goto	PLUS_BTN_MENU5

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 1
			goto F1_MENU5

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 2
			goto F2_MENU5


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 3
			goto F3_MENU5

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 4
			goto F4_MENU5


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 5
			goto F5_MENU5


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 6
			goto F6_MENU5


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 7
			goto F7_MENU5


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET ENV 8
			goto F8_MENU5

	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP

;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 6  ]----------------------------------------
CHECK_BTN_VALUE_MENU6
	;; MENU6 -> SELECT Midi Channel for Tone ABC
	;; --------------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> - 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> -
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)

	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 6 -> EXIT
			goto	SWITCH_TO_MENU_0

	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 6 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 6
			goto	BTN_ITEM_UP_MENU6

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 6
			goto 	BTN_ITEM_DOWN_MENU6

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT >> redirect to VALUE -1
			goto MINUS_BTN_MENU6

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			;; REDIRECT TO +1
			goto PLUS_BTN_MENU6

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			goto MINUS_BTN_MENU6
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			goto PLUS_BTN_MENU6

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return

	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP



;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 7  ]----------------------------------------
CHECK_BTN_VALUE_MENU7
	;; MENU7 -> Velocity Menu
	;; --------------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> 
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> - 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> -
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	
	;; ESC ?
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 7 -> EXIT
			goto	SWITCH_TO_MENU_0


	;; SEL ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 7 -> NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 6
			goto	BTN_ITEM_UP_MENU7

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 7
			goto 	BTN_ITEM_DOWN_MENU7

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT >> REDIRECT TO -1 VALUE
			goto	MINUS_BTN_MENU7

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT >> REDIRECT TO +1 VALUE
			goto PLUS_BTN_MENU7

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			goto	MINUS_BTN_MENU7
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			goto PLUS_BTN_MENU7

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> F1 - TOGGLE VELOCITY @ TONE A
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE VELOCITY @ TONE A
			goto 	F1_MENU7

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> F2 - TOGGLE VELOCITY @ TONE B
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; VELOCITY @ TONE B
			goto 	F2_MENU7


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> F3 - TOGGLE VELOCITY @ TONE C
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; VELOCITY @ TONE C
			goto 	F3_MENU7

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TO DO
			return


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> F5 - CLR VELOCITY @ NOISE FRQ.
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; CLR VELOCITY @ NOISE FRQ.
			goto	MINUS_BTN_MENU7_VELOCITY_TO_NOISE_OFF


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> F6 - SET VELOCITY @ NOISE FRQ. @A
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET VELOCITY @ NOISE FRQ. @A
			goto	PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_A


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> F7 - SET VELOCITY @ NOISE FRQ. @B
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET VELOCITY @ NOISE FRQ. @B
			goto 	PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_B


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> F8 - SET VELOCITY @ NOISE FRQ. @C
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SET VELOCITY @ NOISE FRQ. @C
			goto	PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_C 

	;; CHECK CS ABC BUTTONS 
	goto CHECK_CS_ABC_BTN_GROUP
	
;; ---------------------------------------------------------------------------------------------------------------
;; ----------------------------------[BTN VALUE INTERPRETATION @ MENU 8  ]----------------------------------------
CHECK_BTN_VALUE_MENU8
	;; MENU8 -> Fx TAB Menu
	;; --------------------------------------------------------------------------------------------------------------
	;; ESC			-> VAR_CURRENT_DIN_BTN_VALUE = 0	-> GO BACK TO MENU0
	;; SEL			-> VAR_CURRENT_DIN_BTN_VALUE = 1	-> -
	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> ITEM POS -1
	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> ITEM POS +1
	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> REDIRECT -> CURRENT ITEM VALUE -1 
	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> REDIRECT -> CURRENT ITEM VALUE +1
	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> CURRENT ITEM VALUE -1 (permanent)
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> CURRENT ITEM VALUE +1 (permanent)
	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc 
	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> [SHORTCUT FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> -
	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> -
	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> -
	
	;; ESC BTN
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; = CONST_BTN_ESC
			;; ESC @ MENU 0 -> EXIT
			goto	SWITCH_TO_MENU_0


	;; SEL BTN
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; SEL
			;; SELECT BTN @ MENU 8 -> DO NOTHING
			return


	;; ITEM UP		-> VAR_CURRENT_DIN_BTN_VALUE = 2	-> CURSOR POS +1
	movlw  CONST_BTN_ITEM_UP
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM UP @ MENU 8
			goto	BTN_ITEM_UP_MENU8

	;; ITEM DWN		-> VAR_CURRENT_DIN_BTN_VALUE = 3	-> CURSOR POS -1
	movlw  CONST_BTN_ITEM_DWN
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; LCD ITEM DWN @ MENU 8
			goto 	BTN_ITEM_DOWN_MENU8

	;; LEFT			-> VAR_CURRENT_DIN_BTN_VALUE = 4	-> CURSOR POS = LFT
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BUTTON LEFT
			;; REDIRECT >> VALUE -1 
			goto MINUS_BTN_MENU8

	;; RIGHT		-> VAR_CURRENT_DIN_BTN_VALUE = 5	-> CURSOR POS = RGT
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN RIGHT
			;; REDIRCT >> VALUE +1
			goto	PLUS_BTN_MENU8

	;; VALUE -		-> VAR_CURRENT_DIN_BTN_VALUE = 6	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; MINUS BTN
			goto MINUS_BTN_MENU8
	
	;; VALUE +		-> VAR_CURRENT_DIN_BTN_VALUE = 7	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; PLUS BTN
			goto	PLUS_BTN_MENU8

	;; F1			-> VAR_CURRENT_DIN_BTN_VALUE = 8	-> -
	movlw  CONST_BTN_F1
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F1

	;; F2			-> VAR_CURRENT_DIN_BTN_VALUE = 9	-> -
	movlw  CONST_BTN_F2
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F2


	;; F3			-> VAR_CURRENT_DIN_BTN_VALUE =10 	-> -
	movlw  CONST_BTN_F3
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F3

	;; F4			-> VAR_CURRENT_DIN_BTN_VALUE =11	-> -
	movlw  CONST_BTN_F4
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F4


	;; F5			-> VAR_CURRENT_DIN_BTN_VALUE =12	-> -
	movlw  CONST_BTN_F5
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F5


	;; F6			-> VAR_CURRENT_DIN_BTN_VALUE =13	-> -
	movlw  CONST_BTN_F6
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F6


	;; F7			-> VAR_CURRENT_DIN_BTN_VALUE =14	-> -
	movlw  CONST_BTN_F7
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F7


	;; F8			-> VAR_CURRENT_DIN_BTN_VALUE =15	-> -
	movlw  CONST_BTN_F8
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
	;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
	goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_F8
	;; -----------------------------------------------------------------------------
	;; # IT'S FX MENU HERE - "MENU8 SHORT CUT BUTTONS" INSTEAD "NORMAL CS BUTTONS" #
	;; -----------------------------------------------------------------------------

	;; BTN TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	movlw  CONST_BTN_TONE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE A
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			;; BTN TONE A ----> FX FUNCTION NAME "ON TONE A"
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_TONE_A

	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	movlw  CONST_BTN_TONE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE B
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_TONE_B


	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	movlw  CONST_BTN_TONE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE C
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_TONE_C


	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	movlw  CONST_BTN_ADD_NOISE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE A
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_NOISE_A


	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	movlw  CONST_BTN_ADD_NOISE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE B
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_NOISE_B


	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	movlw  CONST_BTN_ADD_NOISE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE C
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto 	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_NOISE_C


	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	movlw  CONST_BTN_ENVELOPE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE A ON/OFF
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_ENV_A


	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	movlw  CONST_BTN_ENVELOPE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE B ON/OFF
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_ENV_B


	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	movlw  CONST_BTN_ENVELOPE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE C ON/OFF
			;; REDIRECT TO MENU8 SHORT CUT FUNCTION
			;; [SHORTCUT BUTTON FOR A FX FUNCTION NAME] SEE sub_routine_button_shortcuts_menu8.inc
			goto	MENU8_BTN_SHORTCUT_SET_FX_FUNCTION_ENV_C

	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	movlw  CONST_BTN_FX_TAB_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE A ON/OFF
			;; DEC TAB POS -1
			goto 	DEC_FX_TAB_POS
	

	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	movlw  CONST_BTN_FX_TAB_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE A ON/OFF
			;; INC FX TAB DELAY TIME +1
			goto	INC_FX_DELAY_TIME

	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	movlw  CONST_BTN_FX_TAB_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE C ON/OFF
			;; INC FX TAB POS +1
			goto	INC_FX_TAB_POS
	
	return


;; ------------------------------------[END OF MENU0-8 ]--------------------------------------------------------
;; --------------------------------------------------------------------------------------------------------------

;; --------------------------------------------------------------------------------------------------------------
;; ----------------------------------------[CS ABC BTN GROUP]----------------------------------------------------
CHECK_CS_ABC_BTN_GROUP
	;; CS TONE ABC BTN GROUP
	
	;; TONE A		-> VAR_CURRENT_DIN_BTN_VALUE =16	-> SWITCH TONE A (on/off)
	movlw  CONST_BTN_TONE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE A
			goto	BTN_TONE_A_HAD_BEEN_PRESSED

	;; TONE B		-> VAR_CURRENT_DIN_BTN_VALUE =17	-> SWITCH TONE B (on/off)
	movlw  CONST_BTN_TONE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE B
			goto	BTN_TONE_B_HAD_BEEN_PRESSED


	;; TONE C		-> VAR_CURRENT_DIN_BTN_VALUE =18	-> SWITCH TONE C (on/off)
	movlw  CONST_BTN_TONE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN TONE C
			goto	BTN_TONE_C_HAD_BEEN_PRESSED


	;; ADD NOISE A	-> VAR_CURRENT_DIN_BTN_VALUE =19	-> ADD NOISE TO TONE A (on/off)
	movlw  CONST_BTN_ADD_NOISE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE A
			goto	BTN_ADD_NOISE_TO_A_HAD_BEEN_PRESSED


	;; ADD NOISE B	-> VAR_CURRENT_DIN_BTN_VALUE =20	-> ADD NOISE TO TONE B (on/off)
	movlw  CONST_BTN_ADD_NOISE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE B
			goto	BTN_ADD_NOISE_TO_B_HAD_BEEN_PRESSED


	;; ADD NOISE C	-> VAR_CURRENT_DIN_BTN_VALUE =21	-> ADD NOISE TO TONE C (on/off)
	movlw  CONST_BTN_ADD_NOISE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; BTN ADD NOISE TO TONE C
			goto	BTN_ADD_NOISE_TO_C_HAD_BEEN_PRESSED


	;; ENVELOPE A	-> VAR_CURRENT_DIN_BTN_VALUE =22	-> SWITCH ENV TONE A (on/off)
	movlw  CONST_BTN_ENVELOPE_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE A ON/OFF
			goto	BTN_ENV_A_BEEN_PRESSED


	;; ENVELOPE B   -> VAR_CURRENT_DIN_BTN_VALUE =23	-> SWITCH ENV TONE B (on/off)
	movlw  CONST_BTN_ENVELOPE_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE B ON/OFF
			goto	BTN_ENV_B_BEEN_PRESSED


	;; ENVELOPE C	-> VAR_CURRENT_DIN_BTN_VALUE =24	-> SWITCH ENV TONE C (on/off)
	movlw  CONST_BTN_ENVELOPE_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE ENV TONE C ON/OFF
			goto	BTN_ENV_C_BEEN_PRESSED

	;; FX TAB A		-> VAR_CURRENT_DIN_BTN_VALUE =25	-> SWITCH FX TAB TONE A (on/off)
	movlw  CONST_BTN_FX_TAB_A
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE A ON/OFF
			goto	BTN_FX_TAB_A_BEEN_PRESSED
	

	;; FX TAB B		-> VAR_CURRENT_DIN_BTN_VALUE =26	-> SWITCH FX TAB TONE B (on/off)
	movlw  CONST_BTN_FX_TAB_B
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE A ON/OFF
			goto	BTN_FX_TAB_B_BEEN_PRESSED

	;; FX TAB C		-> VAR_CURRENT_DIN_BTN_VALUE =27	-> SWITCH FX TAB TONE C (on/off)
	movlw  CONST_BTN_FX_TAB_C
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE FX TAB TONE C ON/OFF
			goto	BTN_FX_TAB_C_BEEN_PRESSED	
	
	
	return