
MENU_03_ABC_MIXER

	;; CS F1-F8 BTN LED'S = OFF
	call	LED_F1_off
	call	LED_F2_off
	call	LED_F3_off
	call	LED_F4_off
	call	LED_F5_off
	call	LED_F6_off
	call	LED_F7_off
	call	LED_F8_off

	
	;; CLEAR LCD
	call    MIOS_LCD_Clear
   
	

    ;; PRINT MENUE MIXER [Fx] ON/OFF
    TABLE_ADDR TEXT_AY_MENU_MIXER_FX_ON_OFF
    call    MIOS_LCD_PrintString
    ;; PRINT LCD ROW 2 - TONE ABC on/off
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_NOISE_MIX
	call    MIOS_LCD_PrintString
	;; PRINT LCD ROW 3 MIX - add noise
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_NOISE_MIX2
	call    MIOS_LCD_PrintString
	;; LCD ROW 4 - SHOW AY NOISE PERIOD
	TABLE_ADDR TEXT_AY_MENU_NOISE_PERIOD
	call    MIOS_LCD_PrintString

MENU_03_ABC_MIXER_JUMP_IN_POINT_FOR_CC_VALUE_LCD_MENU_REFRESH

	;; ---------------[CHECK: NOISE PERIOD = VELOCITY CONTROLED?]-------------------
	;; CHECK if velosity control noise period => velocity from TONE A 
	;; CHECK IF IT NOISE PERIOD IS CONTROLLED By VELOCITY from TONE A
	;; BIT Test 5, skip if set
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_NOISE_PERIOD_CONTROLED_VIA_VELOCITY_TONE_A_ON_OFF
		;; NO - CHECK TONE B
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_CHK_VELOITY_NOISE_PERIOD_TONE_B
		;; YES - IT's TONE A - GO AND WRIT IT TO LCD
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_A_NOISE_PERIOD
		

LABEL_AY_MENU_MIX_NOISE_PERIOD_CHK_VELOITY_NOISE_PERIOD_TONE_B
	;; BIT Test 6, skip if set
	;; CHECK IF IT NOISE PERIOD IS CONTROLLED by VELOCITY from TONE B
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_NOISE_PERIOD_CONTROLED_VIA_VELOCITY_TONE_B_ON_OFF
		;; NO - Check next Tone
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_CHK_VELOITY_NOISE_PERIOD_TONE_C
		;; YES - IT's TONE B - GO AND WRIT IT TO LCD
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_B_NOISE_PERIOD


LABEL_AY_MENU_MIX_NOISE_PERIOD_CHK_VELOITY_NOISE_PERIOD_TONE_C
	;; BIT Test 7, skip if set
	;; CHECK IF IT NOISE PERIOD IS CONTROLLED BY VELOCITY from TONE C
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_NOISE_PERIOD_CONTROLED_VIA_VELOCITY_TONE_C_ON_OFF
		;; NO - NOW WE CHECKED TONE ABC
		;; THERE WAS NO VELOCITY AT TONE ABC, SO
		;; JUST WRITE THE NOISE PERIOD VALUE ON LCD
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VALUE_TO_LCD
		;; YES - IT's TONE C - GO AND WRIT IT TO LCD
		rgoto LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_C_NOISE_PERIOD

LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VALUE_TO_LCD
	movlw   LCD_ROW3 + 0x0d
	call    MIOS_LCD_CursorSet
	
	;; SHOW REVERSE VALUE ON LCD
	;; 0  => LCD 31
	;; 31 => LCD 0
	movlw 	NOISE_PERIOD_MAX_VALUE  ;; 31
	movwf 	VAR_AY_CHIP_R6_NOISE_PERIOD_REVERSE_VALUE
	movf 	VAR_AY_CHIP_REG6_NOISE_PERIOD, W
	subwf 	VAR_AY_CHIP_R6_NOISE_PERIOD_REVERSE_VALUE, W
	;; PRINT REVERSE NOISE PERIOD VALUE
	;; TO LCD 
	call        MIOS_LCD_PrintBCD3


;; -----------------------[CHECK: FX A|B|C ON or OFF]---------------------------------------		
LABEL_AY_MENU_FX_A
        ;; IS FX @ A ON OR OFF? (BIT0 SET or CLEAR?)
        ;; btfsc = Überspringe wenn BIT0 = 0 ist
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_FX_ON_OFF_TONE_A

        ;; NO, BIT0 = 1  
        ;; SO FX @ CH A IS ENABLED 
        rgoto  LABEL_AY_MENU_FX_A_ON
		
		;; YES, BIT0 = 0
		;; FX @ CH A IS NOT ENABLED 
		rgoto LABEL_AY_MENU_FX_A_OFF

LABEL_AY_MENU_FX_B
	
	;; IS FX @ B ON OR OFF? (BIT1 SET or CLEAR?)
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FX_ON_OFF_TONE_B
	
        ;; NO, BIT1 = 1  
        rgoto LABEL_AY_MENU_FX_B_ON
		
		;; YES, BIT1 = 0
		rgoto  LABEL_AY_MENU_FX_B_OFF

LABEL_AY_MENU_FX_C
	;; IS FX @ C ON OR OFF? (BIT2 SET or CLEAR?)
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_FX_ON_OFF_TONE_C
	
        ;; NO, BIT2 = 1  
        rgoto  LABEL_AY_MENU_FX_C_ON
		
		;; YES, BIT2 = 0
		rgoto  LABEL_AY_MENU_FX_C_OFF	

	

;; -----------------------[CHECK: TONE A|B|C ON or OFF]---------------------------------------		
LABEL_AY_MENU_MIX_A
    ;; CHK: TONE A ON OR OFF?
    ;; btfsc: If bit 'b' in register ’f' is 0, then the
	;; next instruction is skipped
	;; IS BIT 0 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT0_TONE_A_ON_OFF
	
        ;; NO - BIT0 IS *NOT* = 0
        ;; BIT0 = 1 => SO TONE A IS *NOT* ON 
        rgoto LABEL_AY_MENU_MIX_ABC_NOISE_A_NOT 
		
		;; YES - BIT0 = 0
		;; BIT0 = 0 => SO TONE A *IS* ON 
		rgoto LABEL_AY_MENU_MIX_ABC_NOISE_A_SET 

LABEL_AY_MENU_MIX_B

	;; IS TONE B ON OR OFF?
	;; IS BIT 1 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT1_TONE_B_ON_OFF

        ;; NO - SO BIT1 *IS* SET
        rgoto LABEL_AY_MENU_MIX_ABC_NOISE_B_NOT
		
		;; YES - SO BIT1 IS *NOT* SET
		rgoto  LABEL_AY_MENU_MIX_ABC_NOISE_B_SET

LABEL_AY_MENU_MIX_C

	;; IS TONE C ON OR OFF?
	;; IS BIT2 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT2_TONE_C_ON_OFF
	
        ;; NO - SO BIT2 *IS* SET
        rgoto 	LABEL_AY_MENU_MIX_ABC_NOISE_C_NOT
		
		;; YES - SO BIT2 IS *NOT* SET
		rgoto  	LABEL_AY_MENU_MIX_ABC_NOISE_C_SET



;; -----------------------[CHECK: NOISE A|B|C ON or OFF]---------------------------------------		
LABEL_AY_MENU_NOISE_MIX_A
	
	;; NOISE CH. A - ON OR OFF?
	;; IS BIT3 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT3_NOISE_A_ON_OFF
	
        ;; NO - SO BIT3 *IS* SET
        rgoto  LABEL_AY_MENU_MIX_NOISE_A_NOT
		
		;; YES - SO BIT2 IS *NOT* SET
		rgoto  LABEL_AY_MENU_MIX_NOISE_A_SET


LABEL_AY_MENU_NOISE_MIX_B
	
	;; NOISE CH. B - ON OR OFF?
	;; IS BIT4 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT4_NOISE_B_ON_OFF
	
        ;; NO - SO BIT4 *IS* SET
        rgoto  LABEL_AY_MENU_MIX_NOISE_B_NOT
		
		;; YES - SO BIT4 IS *NOT* SET
		rgoto   LABEL_AY_MENU_MIX_NOISE_B_SET


LABEL_AY_MENU_NOISE_MIX_C
	
	;; NOISE CH. C - ON OR OFF?
	;; ;; IS BIT5 IN VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH = 0?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT5_NOISE_C_ON_OFF
	
        ;; NO - SO BIT5 *IS* SET
        rgoto LABEL_AY_MENU_MIX_NOISE_C_NOT 
		
		;; YES - SO BIT5 IS *NOT* SET
		rgoto  LABEL_AY_MENU_MIX_NOISE_C_SET



;; -------------------[CSR POS @ MAIN MENU 3]------------------------------------
;; MAIN MENU 3: 
;; MIXER 
;; TONE ABC +NOISE ABC
;; ADD FX TO ABC
;; NOISE FREQ. (NOISE PERIOD)

;; Show the CSR POS 
MENU3_SET_CSR_POS
	;; FIXED CSR POS: CSR @ ITEM3 = NOISE FREQ.
	movlw	CONST_MENU_ITEM_POS3
	movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ABC_NOISE
	
	;; EDITING MODE @ ADD NOISE TO CH ABC
	;; PRINT ">" ON EDIT POSITION3
	movlw 	CSR_POS_MENU3_ITEM3
	call    MIOS_LCD_CursorSet
	movlw   '~'
	call    MIOS_LCD_PrintChar
	;; BLINKING CSR HANDLING
	movlw 	CSR_POS_MENU3_ITEM3
	movff	WREG, VAR_CURSOR_BLINKING_POS
	movlw   '~'
	movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR	
	
	;; EXIT HERE ALL DONE
	return


;; ----------------------------------------------------------------------------------------
;; ---[END OF MAIN MENU3 ROUTINE]----------------------------------------------------------
;; ----------------------------------------------------------------------------------------



;; ---------------------------------------------------------------------------------------
;; ----------[START LCD SUB ROUTINE FOR MENU: FX ABC / CH ABC / NOISE PERIOD]-------------
;; ---------------------------------------------------------------------------------------


;; ----------------[PRINT FX ABC on or off]-----------------------------------------------

;; MIXER FX ITEM:
;; PRINT "A" or "-" LCD ROW1 
;; FX @ TONE A on or of
LABEL_AY_MENU_FX_A_OFF
	TABLE_ADDR	TEXT_AY_MENU3_FX_A_OFF
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_FX_B

LABEL_AY_MENU_FX_A_ON
	TABLE_ADDR  	TEXT_AY_MENU3_FX_A_ON
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_FX_B

;; PRINT "B" or "-" LCD ROW1 
;; FX @ TONE B on or off
LABEL_AY_MENU_FX_B_OFF
	TABLE_ADDR 	TEXT_AY_MENU3_FX_B_OFF
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_FX_C

LABEL_AY_MENU_FX_B_ON
	TABLE_ADDR 	TEXT_AY_MENU3_FX_B_ON
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_FX_C
        

;; PRINT "C" or "-" LCD ROW1 
;; FX @ TONE C on or off
LABEL_AY_MENU_FX_C_OFF
	TABLE_ADDR  	TEXT_AY_MENU3_FX_C_OFF
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_MIX_A

LABEL_AY_MENU_FX_C_ON
	TABLE_ADDR  	TEXT_AY_MENU3_FX_C_ON
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_MIX_A



;; ----------------[PRINT TONE ABC on or off]--------------------------------------------

;; JUMPED IN HERE FROM: MIX CH ABC 
;; SEE: LABEL_AY_MENU_MIX_A
;; PRINT "A" or "-" LCD ROW2 
;; TONE A
LABEL_AY_MENU_MIX_ABC_NOISE_A_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_A_NOT
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_MIX_B

LABEL_AY_MENU_MIX_ABC_NOISE_A_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_A_SET
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_MIX_B

;; SEE: LABEL_AY_MENU_MIX_B
;; PRINT "B" or "-" LCD ROW2 
;; TONE B
LABEL_AY_MENU_MIX_ABC_NOISE_B_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_B_NOT
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_MIX_C

LABEL_AY_MENU_MIX_ABC_NOISE_B_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_B_SET
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_MIX_C
        

;; PRINT "C" or "-" LCD ROW2 
;; TONE C
LABEL_AY_MENU_MIX_ABC_NOISE_C_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_C_NOT
    call    MIOS_LCD_PrintString
    rgoto 	LABEL_AY_MENU_NOISE_MIX_A

LABEL_AY_MENU_MIX_ABC_NOISE_C_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_C_SET
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_NOISE_MIX_A


;; ----------------[PRINT NOISE ABC on or off]--------------------------------------------

;; PRINT IF NOISE IS ENABLED OR NOT
;; PRINT "A" or "-" LCD ROW2 
;; NOISE MIX CH. A
LABEL_AY_MENU_MIX_NOISE_A_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_A_NOT
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_NOISE_MIX_B


LABEL_AY_MENU_MIX_NOISE_A_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_A_SET
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_NOISE_MIX_B

;; PRINT "B" or "-" LCD ROW2 
;; NOISE MIX CH. B
LABEL_AY_MENU_MIX_NOISE_B_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_B_NOT
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_NOISE_MIX_C


LABEL_AY_MENU_MIX_NOISE_B_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_B_SET
    call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_NOISE_MIX_C


;; PRINT "C" or "-" LCD ROW2 
;; NOISE MIX CH. C
LABEL_AY_MENU_MIX_NOISE_C_NOT
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_C_NOT
    call    MIOS_LCD_PrintString
    rgoto	MENU3_SET_CSR_POS


LABEL_AY_MENU_MIX_NOISE_C_SET
	TABLE_ADDR TEXT_AY_MENU_TONE_ABC_MIX_NOISE_C_SET
    call    MIOS_LCD_PrintString
    rgoto	MENU3_SET_CSR_POS


;; -----------------[IF VELOCITY TO NOISE PERIOD IS ACTIVATED]--------------------
;; -----------------PRINT THIS INFORMATION ON LCD---------------------------------

LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_A_NOISE_PERIOD
	TABLE_ADDR TEXT_AY_MENU_NOISE_PERIOD_VELOCITY_A
	call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_FX_A

			
LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_B_NOISE_PERIOD
	TABLE_ADDR TEXT_AY_MENU_NOISE_PERIOD_VELOCITY_B
	call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_FX_A


LABEL_AY_MENU_MIX_NOISE_PERIOD_WRITE_VEOCITY_C_NOISE_PERIOD
	TABLE_ADDR TEXT_AY_MENU_NOISE_PERIOD_VELOCITY_C
	call    MIOS_LCD_PrintString
    rgoto	LABEL_AY_MENU_FX_A

;; -----------------------------------------------------------------------------------
;; ---------------------[END LCD SUB ROUTINES]----------------------------------------
;; -----------------------------------------------------------------------------------


