;; user_tick_lcd_redraw.inc
;; 
;; FUNCTION:
;; CHECKING FOR MENU REFRESH
;; IS THERE WAS A CC|PITCH BEND|MODULATION WHEEL MIDI EVENT @ THE associated MENU

;; --------[MIDI CCLIST ]---------------------------------------------------------------------
; ;     CONTROLLER 01 - ENVELOPE SHAPE CONTROL:
; ;     	CC1 Value 000-015 dec. ⇒ ENVELOPE SHAPE down
; ;     	CC1 Value 016-023 dec. ⇒ ENVELOPE SHAPE up down
; ;     	CC1 Value 024-031 dec. ⇒ ENVELOPE SHAPE down continue
; ;     	CC1 Value 032-039 dec. ⇒ ENVELOPE SHAPE down continue2
; ;     	CC1 Value 040-047 dec. ⇒ ENVELOPE SHAPE down up
; ;     	CC1 Value 048-055 dec. ⇒ ENVELOPE SHAPE up continue
; ;     	CC1 Value 056-063 dec. ⇒ ENVELOPE SHAPE up
; ;     	CC1 Value 064-127 dec. ⇒ ENVELOPE SHAPE up continue2
; ;     CONTROLLER 02 - GLOBAL ENVELOPE FINE 0-127 (128-255 with +128 OFFSET CC3)
; ;     CONTROLLER 03 - GLOBAL ENVELOPE FINE +128 OFFSET (Value 0 ⇒ NO OFFSET, Value 1-128 ⇒ OFFSET +128)
; ;     CONTROLLER 04 - GLOBAL ENVELOPE COARSE 0-127 (128-255 with +128 OFFSET CC5)
; ;     CONTROLLER 05 - GLOBAL ENVELOPE COARSE +128 OFFSET (Value 0 ⇒ NO OFFSET, Value 1-128 ⇒ OFFSET +128)
; ;     CONTROLLER 06 - GLOBAL NOISE PERIOD (Value 0-127 ⇒ 0-31 NIOSE PERIOD)
; ;     CONTROLLER 07 - VOLUME A (Value 0-127 ⇒ 0-15 VOLUME)
; ;     CONTROLLER 08 - VOLUME B (Value 0-127 ⇒ 0-15 VOLUME)
; ;     CONTROLLER 09 - VOLUME C (Value 0-127 ⇒ 0-15 VOLUME)
; ;     CONTROLLER 10 - Value 1-127 = Tone A ON / Value 0 = Tone A OFF
; ;     CONTROLLER 11 - Value 1-127 = Tone B ON / Value 0 = Tone B OFF
; ;     CONTROLLER 12 - Value 1-127 = Tone C ON / Value 0 = Tone C OFF
; ;     CONTROLLER 13 - Value 1-127 = Noise A ON / Value 0 = Noise A OFF
; ;     CONTROLLER 14 - Value 1-127 = Noise B ON / Value 0 = Noise B OFF
; ;     CONTROLLER 15 - Value 1-127 = Noise C ON / Value 0 = Noise C OFF
; ;     CONTROLLER 16 - Value “Envelope Mode” Tone A on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 17 - Value “Envelope Mode” Tone B on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 18 - Value “Envelope Mode” Tone C on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 19 - Value “Velocity Mode” Tone A on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 20 - Value “Velocity Mode” Tone B on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 21 - Value “Velocity Mode” Tone C on/off - Value 0 = OFF / Value 1-127 = ON
; ;     CONTROLLER 22 - Value “Noise Period to Velocity” ON/OFF
; ;     	Value 0 ⇒ “Velocity to Noise Period” = OFF
; ;     	Value 1 ⇒ “Velocity to Noise Period” = ON [Take Velocity from MIDI Channel TONE A]
; ;     	Value 2 ⇒ “Velocity to Noise Period” = ON [Take Velocity from MIDI Channel TONE B]
; ;     	Value 3 ⇒ “Velocity to Noise Period” = ON [Take Velocity from MIDI Channel TONE C]
; ;     	Value > 3 ⇒ NOT effective
; ;     	Note: CC22 is effective on the MIDI Channel of Tone A or B or C



CHECK_EVENT_MENU_REDRAW
		;; CHECK IF A MIDI EVENT (CC|PITCH BEND|MODULATION WHEEL) HAS BEEN RECEIVED
		;; IF NO (CC|PITCH BEND|MODULATION WHEEL) MIDI EVENT HAS BEEN RECEIVED
		;; THE VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG MUST BE = 0
		;; IF A MIDI EVENT (CC|PITCH BEND|MODULATION WHEEL) HAS BEEN WRITTEN
		;; THE VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG == THE CC|PITCH BEND|MODULATION WHEEL| *NUMBER*
		;; (*NOT* THE CC|PITCH BEND|MOD WHEEL "VALUE")
		;; IF THERE WAS A (CC|PITCH BEND|MODULATION WHEEL) A NUMBER HAS BEEN WRITTEN
		;; TO THE VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG 
		;; MIDI EVENT CHANGE CC                			== 0 to 127 (*)
		;; MIDI EVENT CHANGE PITCH BEND 				== 30 *
		;; MIDI EVENT CHANGE EXEPTION: MOD WHEEL		== 32 *
		clrw
		cpfsgt VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG

				;; NO,
				;; THE FLAG = 0 
				;; EXIT, NO LCD MENU REWRITING NEEDET HERE
				return

				;; YES,
				;; CC FLAG IS > 0
				;; GO ON AND CHECK IF THE (CC|PITCH BEND|MODULATION WHEEL)-NUMBER
				;; HIT A ITEM AT THE CURRENT MENU
				

	;; BRANCH TO CURRENT MIDI VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG NUMBER
	;; ---------------------------------------------------------------------------------------------------------
	movf VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG, W
	;; JUMP TO VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG NUMBER ROUTINE
	JUMPTABLE_2BYTES 33 ; entries (0-32)
	    rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 00 - NOT USED 
	    rgoto	CC1TO5_CHECK_IF_MAIN_MENU_IS_5		; CONTROLLER 01 - ENVELOPE SHAPE 
		rgoto	CC1TO5_CHECK_IF_MAIN_MENU_IS_5		; CONTROLLER 02 - ENV. FINE 
	    rgoto	CC1TO5_CHECK_IF_MAIN_MENU_IS_5		; CONTROLLER 03 - ENV. FINE OFFSET + 128 (BIT7)
	    rgoto	CC1TO5_CHECK_IF_MAIN_MENU_IS_5		; CONTROLLER 04 - ENV. COARSE
	    rgoto	CC1TO5_CHECK_IF_MAIN_MENU_IS_5		; CONTROLLER 05 - ENV. COARSE OFFSET + 128 (BIT7)
		rgoto	CC6_CHECK_IF_MAIN_MENU_IS_3		 	; CONTROLLER 06	- NOISE PERIOD
		rgoto	CC7TO9_CHECK_IF_MAIN_MENU_IS_4		; CONTROLLER 07	- VOLUME A
		rgoto	CC7TO9_CHECK_IF_MAIN_MENU_IS_4		; CONTROLLER 08	- VOLUME B
		rgoto	CC7TO9_CHECK_IF_MAIN_MENU_IS_4		; CONTROLLER 09	- VOLUME C
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 10	- ON/OFF A
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 11	- ON/OFF B
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 12	- ON/OFF C
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 13	- NOISE A ON/OFF
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 14	- NOISE B ON/OFF
		rgoto	CC10TO15_CHECK_IF_MAIN_MENU_IS_3	; CONTROLLER 15	- NOISE C ON/OFF
		rgoto	CC16TO18_CHECK_IF_MAIN_MENU_IS_5	; CONTROLLER 16	- TONE A ENV. ON/OFF
		rgoto	CC16TO18_CHECK_IF_MAIN_MENU_IS_5	; CONTROLLER 17	- TONE B ENV. ON/OFF
		rgoto	CC16TO18_CHECK_IF_MAIN_MENU_IS_5	; CONTROLLER 18	- TONE C ENV. ON/OFF
		rgoto	CC19TO22_CHECK_IF_MAIN_MENU_IS_7	; CONTROLLER 19	- TONE A VELOCITY TO VOLUME ON/OFF
		rgoto	CC19TO22_CHECK_IF_MAIN_MENU_IS_7	; CONTROLLER 20	- TONE B VELOCITY TO VOLUME ON/OFF
		rgoto	CC19TO22_CHECK_IF_MAIN_MENU_IS_7	; CONTROLLER 21	- TONE C VELOCITY TO VOLUME ON/OFF
		rgoto	CC19TO22_CHECK_IF_MAIN_MENU_IS_7	; CONTROLLER 22	- VELOCITY TO NOISE PERIOD ABC ON/OFF
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 23	- RESERVED for CC
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 24	- RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 25	- RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 26	- RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 27	- RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 28	- RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; CONTROLLER 29	- RESERVED
		rgoto	USER_TICK_PITCH_BEND_CHECK_IF_MAIN_MENU_IS_2	; [30] PITCH BEND - PITCH BEND TONE A B C
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; [31] - RESERVED
		rgoto	USER_TICK_CC_DO_NO_REDRAW			; [32] - MODULATION WHEEL
		


;; ----------------------------------------------------------------
;; ---------[EXIT AND DO *NOT* REDRAW THE MAIN MENU]---------------
USER_TICK_CC_DO_NO_REDRAW	
		;; EXIT HERE
		return


;; -------------------------------------------------------------------
;; -------------------------------------------------------------------


;; ----------[CC IS 1-5 CHECK IF MAIN MENU = ENVELOPE (5) ?]-----------------

CC1TO5_CHECK_IF_MAIN_MENU_IS_5

		;; MAIN MENU = 5 ?
		movlw 	CONST_MAIN_MENU_05
		cpfseq 	VAR_CURRENT_MAIN_MENU
		
			;; NO - OK, QUIT 
			return

			; YES 
			goto MENU_05_ABC_ENVELOPE_JUMP_IN_POINT_FOR_LCD_REFRESH


;; ---------[END: CHECK CC 1-5 AND MAIN MENU 5 (ENV)------------------------------

;; ---------[CC=6 (NOISE PERIOD) - IS MAIN MENU = 3 (MIXER)?]--------------------

CC6_CHECK_IF_MAIN_MENU_IS_3
	;; CC = 6 => NOISE PERIOD HAS BEEN WRITTEN
		;; CHECK IF MAIN MENU = 3
		movlw 	CONST_MAIN_MENU_03
		cpfseq 	VAR_CURRENT_MAIN_MENU
		
			;; NO 
			return

			; YES 
			goto MENU_03_ABC_MIXER_JUMP_IN_POINT_FOR_CC_VALUE_LCD_MENU_REFRESH
	

;; ---------[IS MAIN MENU = 4 (TONE A B C VOLUME)?]--------------------
CC7TO9_CHECK_IF_MAIN_MENU_IS_4
		;; MAIN MENU = 4 (TONE A B C VOLUME)?
		movlw 	CONST_MAIN_MENU_04
		cpfseq 	VAR_CURRENT_MAIN_MENU
		
			;; NO - OK, QUIT 
			return

			; YES 
			goto MENU4_JUMP_IN_POINT_FOR_CC_VALUE_LCD_MENU_REFRESH


;; ---------[IS MAIN MENU = 3 (TONE A B C + NOISE = ON or OFF)?]--------------------
CC10TO15_CHECK_IF_MAIN_MENU_IS_3
		;; MAIN MENU = 3 (MIXER - TONE ABC and NOISE ABC => ON OFF)?
		movlw 	CONST_MAIN_MENU_03
		cpfseq 	VAR_CURRENT_MAIN_MENU
		
			;; NO - OK, QUIT 
			return

			; YES 
			goto MENU_03_ABC_MIXER_JUMP_IN_POINT_FOR_CC_VALUE_LCD_MENU_REFRESH



;; ---------[IS MAIN MENU = 5 (TONE A B C VELOCITY MAIN MENU)?]--------------------
CC16TO18_CHECK_IF_MAIN_MENU_IS_5

		;; MAIN MENU = 5?
		movlw CONST_MAIN_MENU_05
		cpfseq VAR_CURRENT_MAIN_MENU
			;; NO - OK, QUIT 
			return
			
			;; YES 
			goto MENU_05_ABC_ENVELOPE_JUMP_IN_POINT_FOR_LCD_REFRESH



;; ---------[IS MAIN MENU = 7 (TONE A B C ENVELOPE MAIN MENU)?]--------------------
CC19TO22_CHECK_IF_MAIN_MENU_IS_7
		;; MAIN MENU = 7?
		movlw CONST_MAIN_MENU_07
		cpfseq VAR_CURRENT_MAIN_MENU
			;; NO - OK, QUIT 
			return
			
			; YES 
			goto MENU_07_VELOCITY_LCD_REFRESH_JUMP_IN_POINT


;; ---------[IS MAIN MENU == 2 (DETUNE A B C / PITCH BEND A B C)]-------
USER_TICK_PITCH_BEND_CHECK_IF_MAIN_MENU_IS_2
		;; MAIN MENU = 2?
		movlw 	CONST_MAIN_MENU_02
		cpfseq 	VAR_CURRENT_MAIN_MENU
		
		;; NO - OK, QUIT 
		return
			
		; YES 
		goto MENU_02_ABC_TUNE_JUMP_IN_POINT_FOR_PITCH_BEND_MENU_REFRESH




