; $Id: tia_env_table.inc 111 2008-02-22 00:41:21Z tk $
;
; MIDIbox TIA
; Envelope Table
; generated with env_delay.pl - calculates sweep from 800 uS to 30s
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;; In: index (0x00-0x7f) in WREG
;; Out: low byte in WREG and MIOS_PARAMETER1, high byte in MIOS_PARAMETER2
;; --------------------------------------------------------------------------
TIA_ENV_TABLE_Get
	clrc
	rlf	WREG, W
	addlw	TIA_ENV_TABLE & 0xff
	movwf	TBLPTRL
	clrf	TBLPTRH
	movlw	TIA_ENV_TABLE >> 8
	addwfc	TBLPTRH, F

	tblrd*+
	movff	TABLAT, MIOS_PARAMETER1
	tblrd*+
	movff	TABLAT, MIOS_PARAMETER2
	movf	MIOS_PARAMETER1, W
	return

;   x |  Time/s | ADD_H | ADD_L 
; ----+---------+-------+-------
;   1 |  0.0008 |   256 |     0
;   2 |  0.0010 |   202 |   196
;   3 |  0.0016 |   124 |   217
;   4 |  0.0027 |    76 |    21
;   5 |  0.0042 |    49 |    41
;   6 |  0.0061 |    33 |   198
;   7 |  0.0084 |    24 |   105
;   8 |  0.0111 |    18 |    97
;   9 |  0.0143 |    14 |    74
;  10 |  0.0180 |    11 |   103
;  11 |  0.0220 |     9 |    76
;  12 |  0.0265 |     7 |   183
;  13 |  0.0315 |     6 |   128
;  14 |  0.0369 |     5 |   139
;  15 |  0.0428 |     4 |   200
;  16 |  0.0492 |     4 |    41
;  17 |  0.0560 |     3 |   167
;  18 |  0.0634 |     3 |    59
;  19 |  0.0712 |     2 |   224
;  20 |  0.0796 |     2 |   147
;  21 |  0.0884 |     2 |    80
;  22 |  0.0978 |     2 |    23
;  23 |  0.1078 |     1 |   230
;  24 |  0.1183 |     1 |   187
;  25 |  0.1294 |     1 |   149
;  26 |  0.1411 |     1 |   115
;  27 |  0.1533 |     1 |    85
;  28 |  0.1662 |     1 |    59
;  29 |  0.1798 |     1 |    35
;  30 |  0.1940 |     1 |    14
;  31 |  0.2088 |     0 |   251
;  32 |  0.2244 |     0 |   233
;  33 |  0.2407 |     0 |   217
;  34 |  0.2578 |     0 |   203
;  35 |  0.2756 |     0 |   190
;  36 |  0.2942 |     0 |   178
;  37 |  0.3136 |     0 |   167
;  38 |  0.3339 |     0 |   157
;  39 |  0.3550 |     0 |   147
;  40 |  0.3771 |     0 |   139
;  41 |  0.4001 |     0 |   131
;  42 |  0.4241 |     0 |   123
;  43 |  0.4492 |     0 |   116
;  44 |  0.4753 |     0 |   110
;  45 |  0.5024 |     0 |   104
;  46 |  0.5308 |     0 |    98
;  47 |  0.5603 |     0 |    93
;  48 |  0.5910 |     0 |    88
;  49 |  0.6231 |     0 |    84
;  50 |  0.6565 |     0 |    79
;  51 |  0.6913 |     0 |    75
;  52 |  0.7275 |     0 |    72
;  53 |  0.7653 |     0 |    68
;  54 |  0.8046 |     0 |    65
;  55 |  0.8456 |     0 |    62
;  56 |  0.8883 |     0 |    59
;  57 |  0.9328 |     0 |    56
;  58 |  0.9792 |     0 |    53
;  59 |  1.0276 |     0 |    51
;  60 |  1.0780 |     0 |    48
;  61 |  1.1305 |     0 |    46
;  62 |  1.1854 |     0 |    44
;  63 |  1.2425 |     0 |    42
;  64 |  1.3021 |     0 |    40
;  65 |  1.3643 |     0 |    38
;  66 |  1.4292 |     0 |    36
;  67 |  1.4970 |     0 |    35
;  68 |  1.5677 |     0 |    33
;  69 |  1.6415 |     0 |    31
;  70 |  1.7186 |     0 |    30
;  71 |  1.7991 |     0 |    29
;  72 |  1.8832 |     0 |    27
;  73 |  1.9710 |     0 |    26
;  74 |  2.0629 |     0 |    25
;  75 |  2.1589 |     0 |    24
;  76 |  2.2592 |     0 |    23
;  77 |  2.3642 |     0 |    22
;  78 |  2.4740 |     0 |    21
;  79 |  2.5890 |     0 |    20
;  80 |  2.7092 |     0 |    19
;  81 |  2.8352 |     0 |    18
;  82 |  2.9670 |     0 |    17
;  83 |  3.1051 |     0 |    16
;  84 |  3.2498 |     0 |    16
;  85 |  3.4015 |     0 |    15
;  86 |  3.5605 |     0 |    14
;  87 |  3.7272 |     0 |    14
;  88 |  3.9020 |     0 |    13
;  89 |  4.0855 |     0 |    12
;  90 |  4.2781 |     0 |    12
;  91 |  4.4802 |     0 |    11
;  92 |  4.6925 |     0 |    11
;  93 |  4.9155 |     0 |    10
;  94 |  5.1498 |     0 |    10
;  95 |  5.3961 |     0 |     9
;  96 |  5.6550 |     0 |     9
;  97 |  5.9273 |     0 |     8
;  98 |  6.2138 |     0 |     8
;  99 |  6.5153 |     0 |     8
; 100 |  6.8327 |     0 |     7
; 101 |  7.1670 |     0 |     7
; 102 |  7.5190 |     0 |     6
; 103 |  7.8900 |     0 |     6
; 104 |  8.2811 |     0 |     6
; 105 |  8.6934 |     0 |     6
; 106 |  9.1283 |     0 |     5
; 107 |  9.5871 |     0 |     5
; 108 | 10.0714 |     0 |     5
; 109 | 10.5827 |     0 |     4
; 110 | 11.1227 |     0 |     4
; 111 | 11.6932 |     0 |     4
; 112 | 12.2961 |     0 |     4
; 113 | 12.9335 |     0 |     4
; 114 | 13.6076 |     0 |     3
; 115 | 14.3208 |     0 |     3
; 116 | 15.0756 |     0 |     3
; 117 | 15.8746 |     0 |     3
; 118 | 16.7207 |     0 |     3
; 119 | 17.6171 |     0 |     2
; 120 | 18.5671 |     0 |     2
; 121 | 19.5742 |     0 |     2
; 122 | 20.6422 |     0 |     2
; 123 | 21.7753 |     0 |     2
; 124 | 22.9777 |     0 |     2
; 125 | 24.2542 |     0 |     2
; 126 | 25.6098 |     0 |     2
; 127 | 27.0500 |     0 |     1

TIA_ENV_TABLE
	db	0xff, 0xff	; delay=0.0008
	db	0xff, 0xff	; delay=0.0008
	db	0xc4, 0xca	; delay=0.0010
	db	0xd9, 0x7c	; delay=0.0016
	db	0x15, 0x4c	; delay=0.0027
	db	0x29, 0x31	; delay=0.0042
	db	0xc6, 0x21	; delay=0.0061
	db	0x69, 0x18	; delay=0.0084
	db	0x61, 0x12	; delay=0.0111
	db	0x4a, 0x0e	; delay=0.0143
	db	0x67, 0x0b	; delay=0.0180
	db	0x4c, 0x09	; delay=0.0220
	db	0xb7, 0x07	; delay=0.0265
	db	0x80, 0x06	; delay=0.0315
	db	0x8b, 0x05	; delay=0.0369
	db	0xc8, 0x04	; delay=0.0428
	db	0x29, 0x04	; delay=0.0492
	db	0xa7, 0x03	; delay=0.0560
	db	0x3b, 0x03	; delay=0.0634
	db	0xe0, 0x02	; delay=0.0712
	db	0x93, 0x02	; delay=0.0796
	db	0x50, 0x02	; delay=0.0884
	db	0x17, 0x02	; delay=0.0978
	db	0xe6, 0x01	; delay=0.1078
	db	0xbb, 0x01	; delay=0.1183
	db	0x95, 0x01	; delay=0.1294
	db	0x73, 0x01	; delay=0.1411
	db	0x55, 0x01	; delay=0.1533
	db	0x3b, 0x01	; delay=0.1662
	db	0x23, 0x01	; delay=0.1798
	db	0x0e, 0x01	; delay=0.1940
	db	0xfb, 0x00	; delay=0.2088
	db	0xe9, 0x00	; delay=0.2244
	db	0xd9, 0x00	; delay=0.2407
	db	0xcb, 0x00	; delay=0.2578
	db	0xbe, 0x00	; delay=0.2756
	db	0xb2, 0x00	; delay=0.2942
	db	0xa7, 0x00	; delay=0.3136
	db	0x9d, 0x00	; delay=0.3339
	db	0x93, 0x00	; delay=0.3550
	db	0x8b, 0x00	; delay=0.3771
	db	0x83, 0x00	; delay=0.4001
	db	0x7b, 0x00	; delay=0.4241
	db	0x74, 0x00	; delay=0.4492
	db	0x6e, 0x00	; delay=0.4753
	db	0x68, 0x00	; delay=0.5024
	db	0x62, 0x00	; delay=0.5308
	db	0x5d, 0x00	; delay=0.5603
	db	0x58, 0x00	; delay=0.5910
	db	0x54, 0x00	; delay=0.6231
	db	0x4f, 0x00	; delay=0.6565
	db	0x4b, 0x00	; delay=0.6913
	db	0x48, 0x00	; delay=0.7275
	db	0x44, 0x00	; delay=0.7653
	db	0x41, 0x00	; delay=0.8046
	db	0x3e, 0x00	; delay=0.8456
	db	0x3b, 0x00	; delay=0.8883
	db	0x38, 0x00	; delay=0.9328
	db	0x35, 0x00	; delay=0.9792
	db	0x33, 0x00	; delay=1.0276
	db	0x30, 0x00	; delay=1.0780
	db	0x2e, 0x00	; delay=1.1305
	db	0x2c, 0x00	; delay=1.1854
	db	0x2a, 0x00	; delay=1.2425
	db	0x28, 0x00	; delay=1.3021
	db	0x26, 0x00	; delay=1.3643
	db	0x24, 0x00	; delay=1.4292
	db	0x23, 0x00	; delay=1.4970
	db	0x21, 0x00	; delay=1.5677
	db	0x1f, 0x00	; delay=1.6415
	db	0x1e, 0x00	; delay=1.7186
	db	0x1d, 0x00	; delay=1.7991
	db	0x1b, 0x00	; delay=1.8832
	db	0x1a, 0x00	; delay=1.9710
	db	0x19, 0x00	; delay=2.0629
	db	0x18, 0x00	; delay=2.1589
	db	0x17, 0x00	; delay=2.2592
	db	0x16, 0x00	; delay=2.3642
	db	0x15, 0x00	; delay=2.4740
	db	0x14, 0x00	; delay=2.5890
	db	0x13, 0x00	; delay=2.7092
	db	0x12, 0x00	; delay=2.8352
	db	0x11, 0x00	; delay=2.9670
	db	0x10, 0x00	; delay=3.1051
	db	0x10, 0x00	; delay=3.2498
	db	0x0f, 0x00	; delay=3.4015
	db	0x0e, 0x00	; delay=3.5605
	db	0x0e, 0x00	; delay=3.7272
	db	0x0d, 0x00	; delay=3.9020
	db	0x0c, 0x00	; delay=4.0855
	db	0x0c, 0x00	; delay=4.2781
	db	0x0b, 0x00	; delay=4.4802
	db	0x0b, 0x00	; delay=4.6925
	db	0x0a, 0x00	; delay=4.9155
	db	0x0a, 0x00	; delay=5.1498
	db	0x09, 0x00	; delay=5.3961
	db	0x09, 0x00	; delay=5.6550
	db	0x08, 0x00	; delay=5.9273
	db	0x08, 0x00	; delay=6.2138
	db	0x08, 0x00	; delay=6.5153
	db	0x07, 0x00	; delay=6.8327
	db	0x07, 0x00	; delay=7.1670
	db	0x06, 0x00	; delay=7.5190
	db	0x06, 0x00	; delay=7.8900
	db	0x06, 0x00	; delay=8.2811
	db	0x06, 0x00	; delay=8.6934
	db	0x05, 0x00	; delay=9.1283
	db	0x05, 0x00	; delay=9.5871
	db	0x05, 0x00	; delay=10.0714
	db	0x04, 0x00	; delay=10.5827
	db	0x04, 0x00	; delay=11.1227
	db	0x04, 0x00	; delay=11.6932
	db	0x04, 0x00	; delay=12.2961
	db	0x04, 0x00	; delay=12.9335
	db	0x03, 0x00	; delay=13.6076
	db	0x03, 0x00	; delay=14.3208
	db	0x03, 0x00	; delay=15.0756
	db	0x03, 0x00	; delay=15.8746
	db	0x03, 0x00	; delay=16.7207
	db	0x02, 0x00	; delay=17.6171
	db	0x02, 0x00	; delay=18.5671
	db	0x02, 0x00	; delay=19.5742
	db	0x02, 0x00	; delay=20.6422
	db	0x02, 0x00	; delay=21.7753
	db	0x02, 0x00	; delay=22.9777
	db	0x02, 0x00	; delay=24.2542
	db	0x02, 0x00	; delay=25.6098
	db	0x01, 0x00	; delay=27.0500
	db	0x01, 0x00	; dummy
