; $Id: tia_tune.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; Routines to play short tunes (when a BankStick is attached/deattached)
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;;  TIA_PLAY Disconnected Tune
;; --------------------------------------------------------------------------
TIA_TUNE_PlayDisconnect
    movlw   0x0d
    movwf   TMP1
	movlw	0x06
	rcall	TIA_TUNE_Note_Init

 	movlw	0x0b
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x01
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x01
	rcall	TIA_TUNE_Wait
	movlw	0x18
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x10
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x04
	rcall	TIA_TUNE_Note_On
	movlw	0x02
	rcall	TIA_TUNE_Wait
	rcall	TIA_TUNE_Note_Off
	movlw	0x02
	rcall	TIA_TUNE_Wait

	rgoto	TIA_TUNE_End
    
;; --------------------------------------------------------------------------
;;  TIA_PLAY Ok Tune
;; --------------------------------------------------------------------------
TIA_TUNE_PlayOk
    movlw   0x0d
    movwf   TMP1
	movlw	0x06
	rcall	TIA_TUNE_Note_Init

 	movlw	0x0b
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x04
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x01
	rcall	TIA_TUNE_Wait
	movlw	0x18
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x10
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x01
	rcall	TIA_TUNE_Note_On
	movlw	0x02
	rcall	TIA_TUNE_Wait
	rcall	TIA_TUNE_Note_Off
	movlw	0x02
	rcall	TIA_TUNE_Wait

	rgoto	TIA_TUNE_End

;; --------------------------------------------------------------------------
;;  TIA_PLAY Wrong Tune
;; --------------------------------------------------------------------------
TIA_TUNE_PlayWrong
    movlw   0x0d
    movwf   TMP1
	movlw	0x06
	rcall	TIA_TUNE_Note_Init

 	movlw	0x0b
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x04
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x05
	rcall	TIA_TUNE_Wait
	movlw	0x18
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x10
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x1d
	rcall	TIA_TUNE_Note_On
	movlw	0x0f
	rcall	TIA_TUNE_Wait
	rcall	TIA_TUNE_Note_Off
	movlw	0x04
	rcall	TIA_TUNE_Wait

	rgoto	TIA_TUNE_End   
    
;; --------------------------------------------------------------------------
;;  TIA_PLAY Fanfare Tune
;; --------------------------------------------------------------------------
TIA_TUNE_Play_Fanfare
    movlw   0x02
	rcall	TIA_TUNE_Note_Init

    movlw   0x0f
    movwf   TMP1
	movlw	0x0b
	rcall	TIA_TUNE_Note_On_Wait01
    movlw   0x08
    movwf   TMP1
	movlw	0x08
	rcall	TIA_TUNE_Note_On_Wait01
    movlw   0x04
    movwf   TMP1
	movlw	0x06
	rcall	TIA_TUNE_Note_On_Wait01
    movlw   0x0b
    movwf   TMP1
	movlw	0x05
	rcall	TIA_TUNE_Note_On_Wait01


	movlw	0x0f
	rcall	TIA_TUNE_Wait
    movlw   0x08
    movwf   TMP1
	movlw	0x06
	rcall	TIA_TUNE_Note_On_Wait01
    movlw	0x04
	rcall	TIA_TUNE_Wait
    movlw   0x0c
    movwf   TMP1
	movlw	0x05
	rcall	TIA_TUNE_Note_On_Wait01


	movlw	0x1a
	rcall	TIA_TUNE_Wait
	rcall	TIA_TUNE_Note_Off
	movlw	0x06
	rcall	TIA_TUNE_Wait

	rgoto	TIA_TUNE_End
    
;; --------------------------------------------------------------------------
;;  TIA_PLAY Tune #1
;; --------------------------------------------------------------------------
TIA_TUNE_Play1
    movlw   0x0d
    movwf   TMP1
	movlw	0x08
	rcall	TIA_TUNE_Note_Init

 	movlw	0x0b
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x02
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x03
	rcall	TIA_TUNE_Wait
	movlw	0x10
	rcall	TIA_TUNE_Note_On_Wait01
	movlw	0x1c
	;movf	TMP2,W
	rcall	TIA_TUNE_Note_On
	movlw	0x30
	rcall	TIA_TUNE_Wait
	rcall	TIA_TUNE_Note_Off
	movlw	0x04
	rcall	TIA_TUNE_Wait

	rgoto	TIA_TUNE_End
    
;; --------------------------------------------------------------------------
;;  TIA_PLAY End 
;; --------------------------------------------------------------------------
TIA_TUNE_End
	bcf	TIA_STAT, TIA_STAT_ENGINE_DISABLE; turn on TIA software synth part again
	;goto	TIA_PATCH_Init			; init patch and exit
    return


;; --------------------------------------------------------------------------
;;  TIA_PLAY Initialization routine
;; --------------------------------------------------------------------------
TIA_TUNE_Note_Init
	bsf	TIA_STAT, TIA_STAT_ENGINE_DISABLE; turn off TIA software synth part

	SET_BSR TIA_BASE
	andlw	0x0f
	movwf	TIA_AUDC0, BANKED
    movf    TMP1, W
    andlw   0x0f
	movwf	TIA_AUDV0, BANKED
    goto	_TIA_SR_Handler
;; --------------------------------------------------------------------------
;;  TIA_PLAY a note (in: Note Number)
;; --------------------------------------------------------------------------
TIA_TUNE_Note_On
	SET_BSR	TIA_BASE
	movwf	TIA_AUDF0, BANKED

	goto	_TIA_SR_Handler  

TIA_TUNE_Note_Off
	SET_BSR	TIA_BASE
	clrf	TIA_AUDV0, BANKED
	clrf	TIA_AUDV1, BANKED
	goto	_TIA_SR_Handler

TIA_TUNE_Note_On_Wait01
	rcall	TIA_TUNE_Note_On
	movlw	0x01
	rgoto	TIA_TUNE_Wait
    

;; --------------------------------------------------------------------------
;;  TIA_PLAY wait for a certain time and poll TIA_SR Handler
;; --------------------------------------------------------------------------
TIA_TUNE_Wait
	movwf	TMP1
	clrwdt
TIA_TUNE_WaitLoop
	movlw	10
	call	MIOS_Delay
	decfsz	TMP1, F
	rgoto	TIA_TUNE_WaitLoop
	return
