; $Id: tia_sr.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; TIA Shift Register Service Routine
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================
;
; define the pins to which the MBHPS_TIA module is connected
;
#if DEFAULT_IS_CARTRIDGE==1
TIA_SR_LAT_SCLK	EQU	LATC
TIA_SR_PIN_SCLK	EQU	0		; Pin C.0
TIA_SR_LAT_RCLK	EQU	LATC
TIA_SR_PIN_RCLK	EQU	2		; Pin C.2
TIA_SR_LAT_OUT	EQU	LATC
TIA_SR_PIN_OUT	EQU	3		; Pin C.3

TIA_SR_LAT_WR     EQU	LATC
TIA_SR_PIN_WR     EQU	1		; Pin C.1
#else    
TIA_SR_LAT_SCLK	EQU	LATD
TIA_SR_PIN_SCLK	EQU	5		; Pin D.5
TIA_SR_LAT_RCLK	EQU	LATC
TIA_SR_PIN_RCLK	EQU	4		; Pin C.4
TIA_SR_LAT_OUT	EQU	LATD
TIA_SR_PIN_OUT	EQU	6		; Pin D.6

TIA_SR_LAT_WR	EQU	LATC
TIA_SR_PIN_WR	EQU	5		; Pin C.5
#endif

;; --------------------------------------------------------------------------
;;  Initialize the MBHP_TIA module
;; --------------------------------------------------------------------------
TIA_SR_Init
	;; reset the TIA
    clrf	MIOS_PARAMETER1
	clrf	MIOS_PARAMETER2
	rcall	TIA_SR_Write     
    return
	;; reset will be released with first call of TIA_SR_Handler

;; --------------------------------------------------------------------------
;;  Check for changes in TIA registers, transfer values to TIA
;;  and handle Wavetable
;; --------------------------------------------------------------------------
TIA_SR_Handler
	btfsc	TIA_STAT, TIA_STAT_ENGINE_DISABLE
	return

	;call	TIA_WT_Handler			; call wavetable handler before continue
_TIA_SR_Handler
TIA_SR_Start

	TABLE_ADDR TIA_SR_REGWRITE_TABLE	; contains order of register accesses
	movlw	6		; number of registers (0x06)
	movwf	TMP1				; TMP1 is the loop counter
	lfsr	FSR0, TIA_BASE			; store base address of TIA registers in FSR0
	lfsr	FSR1, TIA_SHADOW_BASE		; store base address of shadow registers in FSR1

	IRQ_DISABLE				; disable interrupts

TIA_SR_Loop
	tblrd*+
	movf	TABLAT, W
	movff	PLUSW0, MIOS_PARAMETER2		; store value of TIA in MIOS_PARAMETER1 and increment FSR0
	BRA_IFSET TIA_STAT, TIA_STAT_FORCE_REFRESH, ACCESS, TIA_SR_Transfer; don't skip if refresh has been forced
	movf	PLUSW1, W			; get content of appr. shadow register
	cpfseq	MIOS_PARAMETER2, ACCESS; transfer to TIA if not equal
	rgoto TIA_SR_Transfer	
  	rgoto	TIA_SR_Next			; skip following code if equal

TIA_SR_Transfer
	;; register change: write value into shadow register and transfer it to TIA
	movf	TABLAT, W
	movff	MIOS_PARAMETER2, PLUSW1		; store value in shadow register

	movf	TABLAT, W			; extract address, add offset
    addlw   0x05
	movwf	MIOS_PARAMETER1			; store in address register

	rcall	TIA_SR_Write			; transfer to TIA
    bsf     TIA_LEDMTR_STAT, TIA_LEDMTR_AUDX_REQ
    
TIA_SR_Next
	decfsz	TMP1, F				; decrement loop counter until it is zero
	rgoto	TIA_SR_Loop

	IRQ_ENABLE				; enable interrupts again

	bcf	TIA_STAT, TIA_STAT_FORCE_REFRESH; clear refresh request (if it has been set before)

	return
	
;; --------------------------------------------------------------------------
;;  TIA Write: write to TIA register
;; --------------------------------------------------------------------------
TIA_SR_Write
	;; TIA signals:
	;; MIOS_PARAMETER2[4..0]: Data
	;; MIOS_PARAMETER1[3..0]: Address
	;; temporary used as counter: MIOS_PARAMETER3

    bcf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; clear clock

	;; superfast transfer with unrolled loop (takes some memory, but guarantees the
	;; lowest system load :)
TIA_SR_WRITE_BIT MACRO reg, bit
	bcf	TIA_SR_LAT_OUT, TIA_SR_PIN_OUT	; set out pin depending on register content (reg.bit)
	btfsc	reg, bit
	bsf	TIA_SR_LAT_OUT, TIA_SR_PIN_OUT
        bsf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; rising clock edge
        bcf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; falling clock edge
	ENDM
#if DEFAULT_IS_CARTRIDGE==1
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 0     ; IC2.O0
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 1     ; IC2.O1
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 2     ; IC2.O2
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 3     ; IC2.O3
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 4     ; IC2.O4
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O5
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O6
    TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O7

	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 3     ; IC7.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 2     ; IC7.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 1     ; IC7.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 0     ; IC7.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O7

#else    
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 0     ; IC2.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 1     ; IC2.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 2     ; IC2.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 3     ; IC2.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 4     ; IC2.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O7

	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 3     ; IC3.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 2     ; IC3.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 1     ; IC3.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 0     ; IC3.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O7
#endif
    bsf     TIA_SR_LAT_RCLK, TIA_SR_PIN_RCLK	; latch TIA values

	bcf     TIA_SR_LAT_WR, TIA_SR_PIN_WR	; enable write
    bcf     TIA_SR_LAT_OUT, TIA_SR_PIN_OUT      ; clear out pin (standby)
    bcf     TIA_SR_LAT_RCLK, TIA_SR_PIN_RCLK	; release latch
    
    bcf	TIA_SR_LAT_WR, TIA_SR_PIN_WR	; enable write
	bra	$+2				; to ensure compatibility with on-board oscillator,
	bra	$+2				; wait for 0.840 uS (1 us) (> one TIA clock cycle)
	bra	$+2
	bra	$+2
	bra	$+2
	bsf	TIA_SR_LAT_WR, TIA_SR_PIN_WR	; disable write (MBHP_TIA: chip select)
    
	return

;; --------------------------------------------------------------------------
TIA_SR_REGWRITE_TABLE
	;; order in which the TIA registers are written
	db	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06
    
    
    
    
    
