
// STANDALONE ARPEGGIATOR v0.1 - bill@parishq.net


void ARP(void){// THIS FUNCTION IS CALLED PERIODICALY BY THE CLOCKBOX
	
	midi_channel=0;// midi channel 1

	//midi_channel=8;// My BassStation :)
	

	if(arp_n==0){
		//here we could stop the clockbox ;), and restart synced it when buffer != empty
		return;//ARP BUFFER IS EMPTY
	}

	arp_tik++;

	//if(arp_tik>=12){// arp speeds : 1/3/6/12/24)
	if(arp_tik>=3){// arp speeds : 1/3/6/12/24)

		arp_tik=0;//reset
	

		// KILL LAST PLAYED NOTE
		if(last_arp<0x80){
			MIOS_MIDI_TxBufferPut(144 + midi_channel);//Note on
			MIOS_MIDI_TxBufferPut(last_arp);
			MIOS_MIDI_TxBufferPut(0x00);//velocity null (note off)
		}

		// PLAY NEW NOTE
		MIOS_MIDI_TxBufferPut(144 + midi_channel);//Note on
		MIOS_MIDI_TxBufferPut(arp_buffer[arp_step]);
		MIOS_MIDI_TxBufferPut(0x7F);//VELOCITY MAX

		last_arp=arp_buffer[arp_step];//SAVE LAST PLAYED NOTE
		
		arp_step++;//PUSH ARP POINTER
		if(arp_step>=arp_n)arp_step=0;//LOOP ARP POINTER

	}
	return;
}






// ADD NOTE TO ARPEGGIO //
void add_arp(unsigned char note){
	
	unsigned char i;
	unsigned char swap;

	// I SORT NOTES TO GET INTERESTING RESULTS //
	for(i=0;i<arp_n;i++){
		if(note<arp_buffer[i]){//swap
			swap=arp_buffer[i];
			arp_buffer[i]=note;
			note=swap;
		}
	}

	arp_buffer[arp_n]=note;

	arp_n++;//INCREMENT ARP NOTE NUMBER COUNTER
	
	MIOS_LCD_CursorSet(0x40);
	MIOS_LCD_PrintCString("ARP_LEN:");
	MIOS_LCD_PrintBCD2(arp_n);//SHOW ARP LENGTH
	
	return;
}



//REM NOTE FROM ARPEGGIO
void rem_arp(unsigned char note){//Rem note to arpeggio

	unsigned char i;

	for(i=0;i<arp_n;i++){
		if(arp_buffer[i]>=note)arp_buffer[i]=arp_buffer[i+1];//unstack (swap)
	}

	arp_n--;// DECREMENT ARP NOTE NUMBER COUNTER

	if(arp_n==0){// Kill last played note
		MIOS_MIDI_TxBufferPut(144 + midi_channel);	//Note
		MIOS_MIDI_TxBufferPut(last_arp);//Note Number
		MIOS_MIDI_TxBufferPut(0x00);	//Velocity null
		last_arp=0x80;//null note
	}

	MIOS_LCD_CursorSet(0x40);
	MIOS_LCD_PrintCString("ARP_LEN:");
	MIOS_LCD_PrintBCD2(arp_n);//ARP LENGTH
	return;
}

