;
; Specific Defines and variables of MIOS Application
;
; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================

	;; free memory for user applications:	
	;; 0x010-0x37f
	
	;;These will EQUate variable names with Static RAM addresses.

DISPLAY_UPDATE_REQ	EQU	0x010	; bit 0 will be set to request a display update


ENC_NUMBER		EQU	0x011	; number of last moved encoder
ENC_INC			EQU	0x012	; incrementer value
ENC_VALUE_16BIT_L	EQU	0x014	; low byte of 16-bit absolute value, address must be even!!!
ENC_VALUE_16BIT_H	EQU	0x015	; high byte of 16-bit absolute value, address must be odd!!!
CHANNEL_NUMBER          EQU     0x016   ;
DB_VALUE                EQU     0x017   ;

PGA_SR_CTR		EQU	0x018 ;
PGA_SR_BIT_CTR		EQU	0x019 ;
PGA_SR			EQU	0x01A ;

MIDI_CC_CHAN	EQU 0x01B;
MIDI_DISP_CHAN	EQU 0x01C;
paircount		EQU	0x01D;
master			EQU	0x01E;
ChanScan		EQU	0x01F;
meterchars		EQU	0x020;
meterlevel		EQU	0x021;
metertrip		EQU	0x022;
loghold			EQU	0x023;
mastr			EQU 0x024;
ARG1H			EQU	0x025;
ARG1L			EQU 0x026;
ARG2H			EQU 0x027;
ARG2L			EQU 0x028;
RES3			EQU	0x029;
RES2			EQU 0x02A;
RES1			EQU 0x02B;
RES0			EQU 0x02C;
mybits			EQU 0x02D;
mybank			EQU 0x02E;
holdsr			EQU	0x02F;


; BANK 0, Non-Access RAM ;; does not matter since we use FSRs for all access
;; 64 audio channels seems reasonable.. 16 X 4 signals, 16 PGA4311 chips or 
;; 32 PGA2311 chips
;;NOTE: Just because the software supports up to 16 PGA4311 chips doesn't
;; mean the hardware will. I'm sure you'll need signal buffering to reach
;; a fan-out of 16.

CHANNEL_GAIN_0          EQU     0x060; This holdsthe actal values to be sent to the PGA chips
CHANNEL_GAIN_63			EQU		0x09F; 64 bytes maximum table space: 16 chan * 4(L,R,FX1,FX2)

MIDI1					EQU		0x100;	- 0x17F Table of 16 MIDI channels data
MIDI2					EQU		0x108;Flags,Volume,Expression,Balance,FX1,FX2,spare,spare
MIDI3					EQU		0x110;
MIDI4					EQU		0x118;
MIDI5					EQU		0x120;
MIDI6					EQU		0x128;
MIDI7					EQU		0x130;
MIDI8					EQU		0x138;
MIDI9					EQU		0x140;
MIDI10					EQU		0x148;
MIDI11					EQU		0x150;
MIDI12					EQU		0x158;
MIDI13					EQU		0x160;
MIDI14					EQU		0x168;
MIDI15					EQU		0x170;
MIDI16					EQU		0x178;
;As follows. Each channel image is 
;0;Flags
;1;Volume (CC7)
;2;Expression (CC11)
;3;Balance/Pan (CC8,10)
;4;FX1 Level	(CC12)
;5;FX2 Level (CC13)
;6;Unused
;7;Unused

;Flags are defined as
;Bit 0; FX1 Pre (CC80)
;Bit 1; FX2 Pre (CC81)
;Bit 2; FX1 Mute (CC82)
;Bit 3; FX2 Mute (CC83)
;Bit 4; WithFX, indicates that this channel includes 2 FX loops (CC15)
;Bit 5; 
;Bit 6; Valid Settings (should always be set)
;Bit 7; NeedCalc, Will signal MBMixer to recalculate this channel

;;RAM space to manage loads and saves
MEMBANK					EQU		0x180 ;through 1BF
