; ==========================================================================
;
; MBStor
;
; (C)2008 Lyle Hazelwood (lylehaze@gmail.com)
; MBStor is a project that allows the use of a vinculum device as a 
; filesystem for MIDIBox projects. This is released "as-is" for teh end user
; to modify, as I will probably never fully realize all the options.
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================
;; ---[ MIOS header file ]---
#include "mios.h"

;; ---[ useful macros ]---
#include "macros.h"

;; ---[ vectors to MIOS functions (never change!) ]---
#include "mios_vectors.inc"

;; ---[ user hooks (never change!) ]---
#include "user_vectors.inc"

;; ==========================================================================
;;  General Application Settings
;; ==========================================================================

;; ---[ variables used by application ]---
#include "app_defines.h"

; ==========================================================================

;; ---[ configuration table for MIDI processor and rotary encoders ]---
;; #include "mios_tables.inc"
#include <mios_mt_table.inc>
#include <mios_enc_table.inc>

;; ---[ Custom LCD driver ]---
#include <app_lcd.inc>
	
;; lcd fucntions
#include "user_lcd.inc"

;; pga functions
; #include "pga.inc"
	
; #include "preset.inc"

	; MIDI volume/Pan/Balance handling
; #include "setlevels.inc"

	; logarithmic conversion tables
; #include "logbyte.inc"

;; SysEx receive, recognize and dispatch
#include "SXInput.inc"
#include "MBStor.inc"

;; ==========================================================================
;;  All MIOS hooks in one file
;; ==========================================================================



;; --------------------------------------------------------------------------
;;  This function is called by MIOS after startup to initialize the
;;  application
;; --------------------------------------------------------------------------
USER_Init
	;; define number of shift registers: for 128 IOs, we need
	;; 16 registers. Btw.: thats the maximum number of supported DIN/DOUTs
	movlw	1
	call	MIOS_SRIO_NumberSet

	;; define the update frequency (latency) of DIN/DOUTs in mS
	movlw	1 ; ms
	call	MIOS_SRIO_UpdateFrqSet

	;; the VIN is a vinculum VMusic2 module, MBStor
	call	VIN_Init

	
	;; Setup pga and gain to 0dB or preset 0
;	call	PGA_Init

	;; setup match header with the SysEx header we want to recognize
	lfsr 	0,matchheader
	movlw	0xF0
	movwf	POSTINC0
	movlw	0x00
	movwf	POSTINC0
	movwf	POSTINC0
	movlw	0x7e
	movwf	POSTINC0
	movlw	0x4d
	movwf	POSTINC0
	; setup the EOX byte for comparison
	movlw	0xF7
	movwf	EOX
	
	call  resetreply	; init our matching code
	clrf	sxindex

	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS in the mainloop when nothing else is to do
;;  We are using it for MBStor Sysex Handling (both ways)
;; --------------------------------------------------------------------------
USER_Tick		;; if there is a byte coming in from Vinc,
	btfss	vin_bits,1	; byte2go is set if last write failed
	bra		ok4newstuff	; last write was good, proceed as normal
	movf	vin_data,W	; reload last byte
	call	VIN_Write	; try it again
	return
ok4newstuff
	call getfromQ		; get next write character
	bz		readit		; did we get one?
	call	VIN_Write	; yes, send it out
	return
readit
	call 	VIN_Read	; nothing to send, try a read cycle
	return

	
	;; --------------------------------------------------------------------------
;;  This function is periodically called by MIOS. The frequency has to be
;;  initialized with MIOS_Timer_Set
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;; --------------------------------------------------------------------------
USER_Timer
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a debug command has been received
;;  via SysEx
;;  Input:
;;     o WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3 like
;;       specified in the debug command
;;  Output:
;;     o return values WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_DebugTrigger
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when the display content should be
;;  initialized. Thats the case during startup and after a temporary message
;;  has been printed on the screen
;; --------------------------------------------------------------------------
USER_DISPLAY_Init
	call	MIOS_LCD_Clear			; clear LCD

	TABLE_ADDR TEXT_WELCOME_0		; print welcome message
	call	MIOS_LCD_PrintString
	TABLE_ADDR TEXT_WELCOME_1		; print welcome message
	call	MIOS_LCD_PrintString

	return
; Here's my tacky startup text
TEXT_WELCOME_0	STRING 20, 0x00, " MIDIBox Mixer V2.0 "
TEXT_WELCOME_1	STRING 20, 0x40, "   Lyle Hazelwood   "


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a complete MIDI event has been received
;;  Input:
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
; We simply look for messages we are interested in
; for this app, we only look for control and program changes.
; SysEx stuff is handled somewhere else.
USER_MPROC_NotifyReceivedEvent
    return	

	
;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has been received
;;  which has been specified in the MIOS_MPROC_EVENT_TABLE table
;;  Input:
;;     o number of entry in WREG
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyFoundEvent
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has not been completly
;;  received within 2 seconds
;; --------------------------------------------------------------------------
USER_MPROC_NotifyTimeout
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received
;;  Input:
;;     o received MIDI byte in WREG and MIOS_PARAMETER1
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedByte
	call	everybyte	;; Our SysEx handler
	return

USER_MIDI_NotifyTx
	return
USER_MIDI_NotifyRx
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an button has been toggled
;;  Input:
;;     o Button number in WREG and MIOS_PARAMETER1
;;     o Button value MIOS_PARAMETER2:
;;       - 1 if button has been released (=5V)
;;       - 0 if button has been pressed (=0V)
;; --------------------------------------------------------------------------
USER_DIN_NotifyToggle
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an encoder has been moved
;;  Input:
;;     o Encoder number in WREG and MIOS_PARAMETER1
;;     o signed incrementer value in MIOS_PARAMETER2:
;;       - is positive when encoder has been turned clockwise
;;       - is negative when encoder has been turned counter clockwise
;; --------------------------------------------------------------------------
USER_ENC_NotifyChange
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the shift register are loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Prepare
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS after the shift register have been loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Finish
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a pot has been moved
;;  Input:
;;     o Pot number in WREG and MIOS_PARAMETER1
;;     o LSB value in MIOS_PARAMETER2
;;     o MSB value in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_AIN_NotifyChange
	return


	END
