; SXInput.inc
; check incoming MIDI bytes for a specific SysEx pattern
; called with incoming byte in MIOS_PARAMETER1
#define sxheadsize 5 ; how many bytes of incoming message must match the header?
#define sxbufsize 63 ; How big is the receive buffer?
#define bufferlen 32	; this is the transmit Queue

;; we need sxbuf and matchheader declared as ram space (non-access)
;; This is in app_defines.h
;; we need matchheader initialized with the desired SysEx start bytes
;; we need EOX initialized to 0xF7
;; we need sxindex initialized to zero
;; these are done in USER_Init of main.asm
;; we need to call everybyte from USER_MPROC_NotifyReceivedByte
;; This is in main.asm

everybyte	; call this with each incoming MIDI byte
	; the first task is to copy the incoming byte to buffer[index]
	; we need to figure the address
	movf	sxindex,w	; get the current buffer index into W
	lfsr	0,sxbuff	; load the fsr with the address of the buffer
	addwf	FSR0L,f		; add them to get the current buffer address
	bnc		nocarry1	; if there's a carry to the high address byte
	incf	FSR0H,f		; then make it so
nocarry1	; now we are pointing at the address, get the data
	movf	MIOS_PARAMETER1,w	; get the byte into W
	movwf	INDF0		; and copy to the current buffer position
	; the new data is now in the buffer

	; the next task is to figure out if we are still matching
	; characters with the desired header, or possibly storing incoming bytes.
	movlw	sxheadsize	; the size of the part that has to match
	cpfslt	sxindex		; skip if index < headsize
	bra 	pastheader	; we are past header matching already

	; at this point, we are in the "matching" part of the header
	; if the character matches, increment sxindex, otherwise reset sxindex

	; we need to find the header character to test for matching
	movf	sxindex,w
	lfsr	0,matchheader
	addwf	FSR0L,f
	bnc		nocarry2
	incf	FSR0H,f
nocarry2	; now we are pointing at the header char to test with
	movf	MIOS_PARAMETER1,w
	cpfseq	INDF0
	bra		failout		; no match, reset and fail
	incf	sxindex,f	; yes they match, increment index
	return				; done until the next character arrives

; we are past comparing the header stuff, just keep saving to
; sxbuffer until the message is complete
pastheader
	incf	sxindex,f	; increment the index pointer
	movlw	0xF7		; the "End of Exclusive" byte
	cpfseq	MIOS_PARAMETER1	; do they match?
	bra		nofail		; no match, wait for next character
	bcf		vin_bits,0
	movlw	0x0D
	call	add2Q
failout
	clrf	sxindex		; reset incoming message buffer to zero
	return
nofail
	movf	MIOS_PARAMETER1,w
	call 	add2Q
	return

	
add2Q
	btfsc	BFull,5
	return			; we abandon new chars if buffer is full
	movwf	QByte			; store off the incoming byte
	lfsr	FSR0,Buffer		; point to start of buffer
	movf	BEnd,W			
	addwf	FSR0L,f			; now points to end of buffer
	movf	QByte,W			; new byte is stored
	movwf	INDF0
	incf	BFull,f
	incf	BEnd,W
	andlw	bufferlen-1
	movwf	BEnd
	return

getfromQ
	movf	BFull,f			; test for empty buffer
	bnz		okgetit
	clrf	WREG			; if empty
	return					; return with zero
okgetit
	lfsr	FSR0,Buffer
	movf	BStart,W
	addwf	FSR0L,F			; now points to next char coming out
	movf	INDF0,W
	movwf	QByte			; stored in QByte

	incf	BStart,W        ; increment start address
	andlw	bufferlen-1     ; with wraparound
    movwf   BStart
	decf	BFull,F         ; and free up this buffer position
    movf	QByte,W
    return

	
xreply
	movwf	holdindex			;; temp store for the new character
	lfsr	FSR0,matchheader	; point to start of our buffer
	movf	replyindex,W		;; index in to where we are
	incf	replyindex,f
	addwf	FSR0L,f
	bnc		nocarry4
	incf	FSR0H,f
nocarry4	; now we are pointing at the first character
	movf	holdindex,w			; get our new character back
	movwf	INDF0				; add it to the buffer
	movlw	0x0d				; is it a linefeed?
	cpfseq	INDF0
	bra 	alldone				; not a linefeed, go finish up
	;; transmit buffer by syex here
	movlw	0xF7				; Terminate the SysEx message
	movwf	PREINC0
	lfsr	FSR0, matchheader	; point to start of message
	call	MIOS_MIDI_BeginStream
nxsx
	movf	POSTINC0,W
	call	MIOS_MIDI_TxBufferPut
	cpfseq	EOX					; until 0xF7 end of SysEx
	bra		nxsx
	call	MIOS_MIDI_EndStream
resetreply
	movlw	sxheadsize			; reset pointer for next character
	movwf	replyindex	
	return
alldone
	;; test for max length then return
	movlw	sxbufsize	; these will abort a message if it's too long
	cpfslt	replyindex
	bra		resetreply
	return


