// Reduced from Michael Sigl for 3 Encoders

#ifndef _MIOS32_ENC_H
#define _MIOS32_ENC_H

#include "TMversion.h"


typedef enum {
				DISABLED=0x00,
				NON_DETENTED=0xff,
				DETENTED1=0xaa,
				DETENTED2=0x22,
				DETENTED3=0x88,
				DETENTED4=0xa5,
				DETENTED5=0x5a
				} mios32_enc_type_t;

typedef enum {
				SLOW,
				NORMAL,
				FAST
				} mios32_enc_speed_t;


typedef union {
				struct {	u32 ALL;	} all;

				struct {
							mios32_enc_type_t   type:8;
							mios32_enc_speed_t  speed:2;
							u8                  speed_par:3;
							u8                  pos:3;
							u8                  sr;
							} cfg;
				} mios32_enc_config_t;

				mios32_enc_config_t enc_config[3];









extern s32 MIOS32_ENC_Init(u32 mode);
extern s32 MIOS32_ENC_ConfigSet(u32 encoder, mios32_enc_config_t config);
extern s32 MIOS32_ENC_UpdateStates(void);
extern s32 MIOS32_ENC_Handler(void *callback);

#endif /* _MIOS32_ENC_H */
