//Clock2Audio2Clock====================================================================//
//========record midiclock with audio recording========================================//
//============2017 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."//
//non-commercial use only. All other rights reserved. Mios32 Based > www.ucapps.de=====//
//thx credits and all the best to TK...who have much off this possible...==============//
//=====================================================================================//

#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <task.h>
#include "tasks.h"
#include <stdio.h>

u8 clock_trigger = 0;
u8 clock_counter = 0;
u8 audio_pulse_durate = 0;
u8 Start_Flag = 1;

//Task Prioritys	               
#define PRIORITY_APP_MIDI_Tick	( tskIDLE_PRIORITY + 4 ) //4 higher then midi

void APP_Init(void){
      
  // initialize J5A pin1 as outputs in Push-Pull Mode OUT
    MIOS32_BOARD_J5_PinInit(1, MIOS32_BOARD_PIN_MODE_OUTPUT_PP);
    MIOS32_BOARD_J5_PinSet(1, 0); //Turn off PIN
      
  // initialize pin 0 of J5A,  as Digital input with internal Pull-DOWN
    MIOS32_BOARD_J5_PinInit(0, MIOS32_BOARD_PIN_MODE_INPUT_PD);
    
  // initialize pin 2 of J5A,  as Digital input with internal Pull-UP //connect to ground
    MIOS32_BOARD_J5_PinInit(2, MIOS32_BOARD_PIN_MODE_INPUT_PU);    
}

void APP_Background(void){ }   
	
void APP_Tick(void){ // called each mS from main task             
    //Timer for Pulse-Output Duration
    if(clock_trigger == 1 && clock_counter <= 2) {clock_counter++;}
    else{clock_trigger = 0;
         MIOS32_BOARD_J5_PinSet(1, 0);
        }
}

void APP_MIDI_Tick(void){       //scan digital input for Audio-Pulses & Dumpout Midiclockdata
    if(MIOS32_BOARD_J5_PinGet(2) == 0)  { //Scan Mode-Switch - are we in Play ore Record Mode?
        //First time we get a Pulse, we send out a CLOCK-START-Signal
        if((MIOS32_BOARD_J5_PinGet(0) == 1) && (audio_pulse_durate == 0) && (Start_Flag == 1) ) {//Pulse = HI,  Pulse start duration
            MIOS32_MIDI_SendClock(32); //send MidiClock
            MIOS32_MIDI_SendStart(32);
            audio_pulse_durate = 1; // Pulse starte duration
            Start_Flag = 0;
            MIOS32_BOARD_LED_Set(1, 1);
        }
        //All other Pulses, are just Clocks, without Startsignals 
        if((MIOS32_BOARD_J5_PinGet(0) == 1) && (audio_pulse_durate == 0) ) {//Pulse = HI,  Pulse start duration
            MIOS32_MIDI_SendClock(32); //send MidiClock
            audio_pulse_durate = 1; // Pulse starte duration
            MIOS32_BOARD_LED_Set(1, 1);
        }
        //Ensure to kill the PULSE DURATION FLAG, after the Pulse is gone....
         if((MIOS32_BOARD_J5_PinGet(0) == 0) && (audio_pulse_durate == 1) ) { //Pulse = LO, Pulse still in duration
            audio_pulse_durate = 0; // Pulse stop duration
            MIOS32_BOARD_LED_Set(1, 0);
        }   
    }
}

void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){   
    if(MIOS32_BOARD_J5_PinGet(2) == 1)  { //Scan Mode-Switch - are we in Play ore Record Mode?
        Start_Flag = 1;//next time we PLAY out the Clock, we send a START Signal
        
        if(port==32){ 
        if(midi_package.evnt0 == 252) {Start_Flag = 1; } //when sequencer is stopped we generate midi clock & transport  
               
      //filter clock           
            if(midi_package.evnt0 == 248) {//248CLK,250Strt,251Cont,252Stp
            clock_trigger = 1;
            clock_counter = 0; //initate Clock HI-State Timer
            MIOS32_BOARD_J5_PinSet(1, 1); //activate GPIO-Pin J5A Pin 2
            Start_Flag = 1; //reset flag in order to send out a start signal when next AUDIO-PULSE COMES IN
            }
        }
    }
}
