//this file allows to re-configure default functions of MIOS32
//available switches are listed in $MIOS32_PATH/modules/mios32/MIOS32_CONFIG.txt

#ifndef _MIOS32_CONFIG_H
#define _MIOS32_CONFIG_H
#define MIOS32_USB_MIDI_NUM_PORTS 1           // we provide 4 USB ports

#define MIOS32_USE_MIDI
#define MIOS32_USE_UART
#define MIOS32_USE_UART_MIDI
#define MIOS32_UART_NUM 2
#define MIOS32_UART0_ASSIGNMENT 1 //1=Midi, 0= Disabled, 2= COM
#define MIOS32_UART1_ASSIGNMENT 1
#define MIOS32_UART2_ASSIGNMENT 0
#define MIOS32_UART3_ASSIGNMENT 0

#define MIOS32_SRIO_NUM_SR 7 //  BLMD-DIN: 5, DINx3: 3  =  summed 8   +++ DOUT Pages 19 = 27
//#define MIOS32_SRIO_NUM_DOUT_PAGES 19 // BLM-DOUT: 5*3=15,  DOUTx4: 4  summed: 19



#define MIOS32_ENC_NUM_MAX 4

#define MIOS32_DONT_USE_MF 1
#define MIOS32_DONT_USE_OSC 1
#define MIOS32_DONT_USE_COM 1
// #define MIOS32_DONT_USE_IIC
// #define MIOS32_DONT_USE_IIC_MIDI
//#define MIOS32_USE_I2S

#define MIOS32_DONT_USE_ENC28J60
#define MIOS32_DONT_USE_AIN

#define MIOS32_LCD_BOOT_MSG_LINE1 "TeslaCoilWind"
//                                "             "
#define MIOS32_LCD_BOOT_MSG_LINE2 "V0.00        "


// AIN Activate J5A
#define MIOS32_AIN_CHANNEL_MASK 0x00ff

// AIN define the deadband (min. difference to report a change to the application hook)
#define MIOS32_AIN_DEADBAND 31 //7Bit
#define MIOS32_AIN_OVERSAMPLING_RATE  1
#define MIOS32_AIN_IDLE_CTR 1500 //1,5sec goes into idle ---standart 3s
#endif /* _MIOS32_CONFIG_H */
