//MSQ-CC-BCR-V1=======================================================================//
// V1 is without Patch-Variants!
//======Synth-Programmer with CC-Automation==========================================//
//============2015 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."//
//non-commercial use only. All other rights reserved. Mios32 Based > www.ucapps.de=====//
//thx credits and all the best to TK...who have much off this possible...==============//
//=====================================================================================//

//NORD DRUM II ---- EDITON//
#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <seq_bpm.h>
#include <wchar.h> // to copy pattern-memory

xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card
      
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//System Variables
////////////////////////////////////////////////

    // External MidiController Remote
    #define  Remote1Port 32         // connect there BCR2000     [32=UART0=Midi-A, 33=UART1=Midi-B]...
    #define  Remote1_Automate_CH 0  // only the Synthesizer CCs
    #define  Remote1_Setting_CH 1   // only the Application Remote CCs (Record, Mute...)

    // Note, Clock, PC  SOURCE  &&  DESTINATION
    #define  PCChIN 6  //ProgramChange Input Channel
    #define  CC_PC_Bank 32 // Bank for Program-Change in order to use more then 128 songs....
    #define  CC_Tact_mono 23 // 3/4,   4/4 tact system receive for external sequencers
    #define  CC_Save_mono 24 // external store signal, so this app save @ same time like external (only one save button in setup...)
    #define  MeloPort 33 //connect there @IN SEQUENCER    @OUT SYNTHESIZERs ... it also handles ProgramChange
    const    u8 MeloCh[8]   = {6,7,8,9,10,11,4,5};   // receive Triggers (4 Melody Morph)  &  send the CCs to this CHannels  //ACT ALSO AS MIDIFILTER! avoid to much traffic!
    #define  DumpOutRateSyx 4 //starting with 0>1x34ms, 1>2*34=68ms, 2>3*34=102ms 3>4x34=136ms....every 2ms one of 34 CCs on 8 MidiChannels is dumped out 
    #define  DumpOutRateRemote 8 //starting with 0>1x34ms, 1>2*34=68ms, 2>3*34=102ms 3>4x34=136ms....every 2ms one of 34 CCs on 8 MidiChannels is dumped out
    #define  DumpOutRateRemote_Velo 8
    #define  DumpOutRateSynth 4 //starting with 0>1x34ms, 1>2*34=68ms, 2>3*34=102ms 3>4x34=136ms....every 2ms one of 34 CCs on 8 MidiChannels is dumped out
    
    #define  TrigMidiThruClock 1 //MeloPort send Midiclock reroute that to the UART-Outputs
  
    #define  LED_Gestic_Rate 256        // (ms) - changing Parameter Blinks and Actions
    #define  LED_Gestic_Duration 1024   // (ms) - Duration of the LED-Animation in ms (1500 = 1,5s)
    #define  SD_Check_Time 131072       // (us?)
    #define  PC_Load_Timer 500          // (ms)
    #define  PC_Save_Timer 500          // (ms)

    // Task Prioritys	
    #define PRIORITY_MSQ	            ( tskIDLE_PRIORITY + 2 ) //4:high            
    #define PRIORITY_APP_Tick	        ( tskIDLE_PRIORITY + 2 ) //2 lower then midi
    #define PRIORITY_TASK_SEQ		    ( tskIDLE_PRIORITY + 4 ) // higher priority than MIDI receive task!

    // local prototype of the task function
    static void Router(u32 port, u32 control, s32 value);
    void SD(u16 clip, u16 job);
    static void TASK_SEQ(void *pvParameters);
    static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 byte);

    u8 CC_Tact_Ext_Storage = 0;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//CC Mapping- Internal > External
/////////////////////////////////
// What is IO Mapping: short: >>> PRESET >>> Routing! --- make it Fit to your SYNTH or SYNTHs! 
// I = Internal > the communication between BCR2000 & MSQ_CC_BCR
// O = External >  SYNTH

  u8 CC_Map_Mode = 0;  // 0:Deep Edit: ALL Automatable controlls for 1 Channel 
                        //              all 29 (of 32) Encoders on the BCR representing a Single Part.  
                        //              Here Automations REC & PLAY is possible
                        // 1:Channel Strip: 4 Controls on 8 Channels
                        //                  8x4 Vertical Rows, each Row representing 4CCs of one of the 8 Parts... take it as a Mixer-overview... 4 the most importent CCs 
                        //                  No Automation REC, because we automate already in Deep Edit 
                        //                  By using the 8 Buttons you can now switch between......?????
                        // There is a Switch on the BCR to toggle between both modes... so here you just initalize

    // 4 CC_Route_Mode = 0:     =  1x Syntheditor             
    const u8 CC_Map0[8][33] = { // CC_Map0 [Part]        [Internal CC Nr] = value of external CC   >>
                                // CC_Map1 [MidiChannel] [Remote/Source]  = Value of Synth/Destination
              //  1st Row Horizontal      (top-row)               //  2nd Row Horizontal                             //  3rd Row Horizontal                              //  4th Row Horizontal
 // CC-on-BCR:  0     1     2     3     4     5     6     7         8     9    10    11    12    13    14    15       16    17    18    19    20    21    22    23        24    25    26    27    28    29    30    31      32
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 1   MidiCh  7
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 2   MidiCh  8
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 3   MidiCH  9
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 4   MidiCh 10
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 5   MidiCh 11
            {  57 ,  56 ,  24 ,  23 ,  26 ,  25 ,  10 ,   7 ,      15 ,  17 ,  14 ,  16 ,  18 ,  19 ,  20 ,  21 ,     46 ,  52 ,  53 ,  47 ,  48 ,  54 ,  55 , 127 ,      50 ,  51 ,  49 ,  30 ,  58 , 255 , 255 , 255    ,255 } ,    // Nord Drum 2    Voice 6   MidiCh 12
            { 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,    255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255    ,255 } ,   //not in Use
            { 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,    255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255    ,255 }}; //not in Use          
       //   {  45 ,  46 ,  47 ,  48 ,  62 ,   5 ,  63 ,  61 ,      18 ,  19 ,  20 ,  21 ,  30 ,  31 ,  58 ,  57 ,     14 ,  15 ,  16 ,  17 ,  28 ,  29 ,  54 ,  55 ,      56 ,  50 ,  51 ,  52 ,  53 , 255 , 255 , 255    ,255 } ,    // Waldorf Pulse1 Page  1   MidiCh  6
       //   {  32 ,  36 , 102 ,  24 , 109 , 112 , 115 ,  33 ,      37 , 103 ,  25 , 108 , 111 , 117 ,  34 ,  38 ,    106 ,  26 , 110 , 113 , 116 ,  35 ,  39 ,  41 ,      40 ,  27 , 255 , 255 , 255 , 255 , 255 , 255    ,255 }};  // Waldorf Pulse1 Page  2   MidiCh  6
       //   { 100 , 101 , 102 , 103 , 104 , 105 , 106 , 107 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,    255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,     255 , 255 , 255 , 255 , 255 , 255 , 255 , 255    ,255 } ,  //example Jomox Mbase01 100-107
    //        -----------------------------------------------     -----------------------------------------------    -----------------------------------------------     ---------------------------------------------
    // 57:ClipTyp, 56:ClipLev  24:DistTyp 23:Dist  26-25:EQ      15:N.Filt 17:N.Res  14:N.Freq  19:N.Atk  21:N.Dec   46:Wav 52:Timbre   47:TimDec   54:Bend50:DecHi 51:DecLo 58:Bal 
    // 10:Pan 7:Gain   >>> Example 1st Row Horiz NordDrum2
       
   // 4 CC_Route_Mode = 1: = 8x Channelstrip          
    const u8 CC_Map1[8][32] = { //CC_Map1 [Active_Strip_Set] [CC to remap to Map0]
              //  1st Row Horizontal                              //  2nd Row Horizontal                             //  3rd Row Horizontal                               //  4th Row Horizontal
            {   1 ,   1 ,   1 ,   1 ,   1 ,   1 ,  32 ,  32 ,      28 ,  28 ,  28 ,  28 ,  28 ,  28 ,  32 ,  32 ,       3 ,   3 ,   3 ,   3 ,   3 ,   3 ,  32 ,  32 ,       7 ,   7 ,   7 ,   7 ,   7 ,   7 ,  32 ,  32  } ,    // Channel-Strip-Set1 (Mixer)
            {   8 ,   8 ,   8 ,   8 ,   8 ,   8 ,  32 ,  32 ,       9 ,   9 ,   9 ,   9 ,   9 ,   9 ,  32 ,  32 ,       4 ,   4 ,   4 ,   4 ,   4 ,   4 ,  32 ,  32 ,       5 ,   5 ,   5 ,   5 ,   5 ,   5 ,  32 ,  32  } ,    // Channel-Strip-Set2 (Filter)
            {  15 ,  15 ,  15 ,  15 ,  15 ,  15 ,  32 ,  32 ,      19 ,  19 ,  19 ,  19 ,  19 ,  19 ,  32 ,  32 ,      24 ,  24 ,  24 ,  24 ,  24 ,  24 ,  32 ,  32 ,      25 ,  25 ,  25 ,  25 ,  25 ,  25 ,  32 ,  32  } ,    // Channel-Strip-Set2 (Decay)
            {  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32  } ,  //not used
            {  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32  } ,  //not used
            {  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32  } ,  //not used
            {  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32  } ,  //not used
            {  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,      32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32 ,  32  }};//not used
          // CC_Map1[0][0]=1 > shows CC_Map0[x][1] = Synth-CC:56 = ClickLevel-CC
          
// to get:   CC_Map0[0-7][ CC_Map1[0][0-7] ] = 56CC-Nr.= ClickGain  CC_Map0[0-7][ CC_Map1[0][8-15] ] = 58CC-Nr. = Bal      in the End: CC_Map0[0-7][ CC_Map1[Active_Strip_Set][0-32] ] = ..CC-Nr. 
//                                1                                                    28
// to get:   CC_Map0[0-7][ CC_Map1[1][0-7] ] = 15CC-Nr.= N.Filt     CC_Map0[0-7][ CC_Map1[1][8-15] ] = 17CC-Nr.= N.Res     For Value:  beat[8].CC_Store[32]
//                                8                                                     9                                              beat[0-7].CC_Store[ CC_Map1[Active_Strip_Set][0-32] ]
// to get:   CC_Map0[0-7][ CC_Map1[2][0-7] ] = 21CC-Nr.= N.Decay    CC_Map0[0-7][ CC_Map1[2][8-15] ] = 47CC-Nr.= TimDec
//                                15                                                   19
// to get:   CC_Map0[0-7][ CC_Map1[3][0-7] ] = 255CC-Nr.= Nothing-will be filtered out! > blank out LEDRING
//                                32

          // this shows only Routing, the value is saved via:
          // beat[0-7].CC_Store[0-31];
          //

    
      u8 Active_Strip_Set = 0; //Active Channel Strip SET
      u8 Strip_CH = 0; //last Mooved Encoder makes Channelstrip Nummer...?

      
      // POSSIBLE VALUES:
      // * 0-127 CC (normal Midi ControlChange)
      // The Following are Master OFFsets for CCs: what is a Master-Offset? > 
      // * 128: Master Offset for CC0
      // * 129: Master Offset for CC1
      // * 130: Master Offset for CC2
      // * 131: Master Offset for CC3
      // * 255: should make always BLANK dont matter what you moove - to indicate there is nothing to control with, why are the last 3 always 255? because i need that controlls for the APP.
      //        However we loose the Offset-Mapping for the 128th CC with that!




/*
//CC-Routing-2-Synth MIN MAX Value >>> PRESET >>> Routing! ... for example you dont need full Attack (because it is a bassliner) but want to use alle 16LEDs to show it...
  //Example Waldorf Pulse 2    
  u8  CC_Map0_MinMax[8][32][2] = {
      {0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0}
      {127,127,127,127,127,127,127,127,   127,127,127,127,127,127,127,127,   127,127,127,127,127,,127,127,127,   127,127,127,127,127,127,127,127},
 
      */

     

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables --- No normally user Settings here
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   u8 Button_Bank = 0; 

   u8 Velo_From_Note[8] = {0,0,0,0,0,0,0,0};

   u8 MSQ_Mute_Remote = 0; //just mute the Datastream to the BCR  

    u8 MSQ_Clear_Sel   = 0;
    u8 MSQ_Clear_All   = 0;
    
    // LED Gestics
    u8 LED_Gestic = 0;  // 0: Just Display rythm Set and BPM blink

   u16 PCIN = 0;        // received Programchange Value 
    
    u8 rythm_count = 1;

    // Store-Load Variables
    u16 SongNrStor = 0; // store song
    u16 SongNrLoad = 0; // load  song


void APP_Init(void){
static u16 x = 0;
static u16 y = 0;
static u16 z = 0;  // for FOR loops....
Active_Part  = 0;
static  u8 track = 0;

/////////////////////////////////////////////////////////////////////////
    // Initate Flags
    flag.PCLoad        = 0;
    flag.PCSave        = 0;
    flag.Tact_Ex_Load  = 0;
    flag.NeedSync      = 1; // to indicate that PAGE length has changed
    flag.FirstTic      = 1;
    flag.Update_Remote = 0;
    flag.Update_Synth  = 0;
    flag.SYX           = 0;      
    flag.one_gestic    = 0; //ONE TIME OPERATION FLAG -- for not looped gestics
    flag.Update_Remote_Velo = 0;
    flag.MSQ_Mute_Remote_timer = 0;
    
    // Init Beat-Loop
    beat[0].rythm           = 4;    // 4x4=16, 5x3=15 usw... to calculate maximal duration per matrix page
    beat[0].PAGE_Steps     = 16;    // calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat       
    beat[0].MainLoop       = 32;    // max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)
    beat[0].bpm           = 100;
 

    for(x=0; x<8; x++){for(y=0; y<32; y++){for(z=0; z<256; z++){
        beat[x].MSQ_Store[y][z] =  0;   // [Parts][CCs][Step>Value]
        }}} 
        
    for(x=0; x<8; x++){for(y=0; y<32; y++){
        beat[x].CC_Store[y] = 0;
        beat[x].Velo_Morph[y]   = 63;   // middle postion 0 64=+1  63=-1
        beat[x].CC_Morph[y]     = 63;   // middle postion 0 64=+1  63=-1

        } } // [Parts][CCs]  
                                            
    for(track=0; track < 8; track++) {
        beat[track].loop_lenght_set   = 1; // 0-15 = Value of LED of a ring
        beat[track].MSQ_Active        = 1;
        beat[track].Velo_Morph_Offset = 63;
        beat[track].CC_Morph_Offset   = 63;
        beat[track].MSQ_Rec           = 0;
        beat[track].MSQ_Rec_mem       = 0;   // to save and tomparary overide MSQ_REC

        beat[track].MSQ_LastMoved     = 0;
    }

    for( x=0; x<8; x++ ) {for(y=0; y<32; y++) {for(z=0; z<32; z++) { beat[x].Mod_Matrix[y][z] = 0; }}}
    
///////////////////////////////////////////////////////////////////////////////////////////////////////
    
    // initialize all LEDs
    MIOS32_BOARD_LED_Init(0xffffffff);
    
    // initialize J5A pin1-3 & J5B pin0-3 as outputs in Push-Pull Mode
    static u8 pin = 0;
    for(pin=1; pin<8; ++pin) {  MIOS32_BOARD_J5_PinInit(pin, MIOS32_BOARD_PIN_MODE_OUTPUT_PP);
                                MIOS32_BOARD_J5_PinSet (pin, 0); } // Turn off all LEDs
    
    // initialize pin 0 of J5A,  as Digital input with internal Pull-Up
    MIOS32_BOARD_J5_PinInit(0, MIOS32_BOARD_PIN_MODE_INPUT_PU);
     
    // BCR-LAYOUT-SYSEX-DUMP-button
    if(MIOS32_BOARD_J5_PinGet(0) == 0) { flag.SYX = 1; }// The "RYTHM" Button was presse while powering up: make sysexdump to BCR2000 with preset from SD-Card, to initalize the BCR-Layout HURRAY!

    xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex(); // create semaphores
    FILE_Init(0);										    // initialize file functions
    
    
    // SEQUENCER TASKS
    MIOS32_BOARD_LED_Set(1, 0);
    SEQ_Init(0);   // initialize sequencer
    MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);
    xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task     
    
    // Clear Motion Sequences
    for(z=0; z<8;   z++) {
    for(x=0; x<32;  x++) {
    for(y=0; y<256; y++) { beat[z].MSQ_Store[x][y] = 128; }}} //[Parts][CCs][Step>Value]  
                                                                                                         
    LED_Gestic = 0; // LED-Gestic Show rythm-Set 
    
    // Dump Remote Buttons Out     
    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 15, CC_Map_Mode);                                                                              
}


void APP_Background(void){    // Set Bet Structure without LCD but with PIN 1 of J5A
    
    // BCR-LAYOUT-SYSEX-DUMP
    if(flag.SYX  == 1) { MUTEX_SDCARD_TAKE; //the flag is normally activated by pressing a button connected to J5A Pin0 while powering up the core
                         FILE_SendSyxDump( "/bcr1.syx", Remote1Port, 15 * DumpOutRateSyx); 	 //Send SYSEX FILE to BCR2000 - to change the CC-Layout.
                         MUTEX_SDCARD_GIVE;	
                         flag.SYX = 0; } //avoid loop


    // check J5 pin 0 for changes
    static s16 count       = 0;
        
    if ( MIOS32_BOARD_J5_PinGet(0) == 0 ) { count = 500; }
    if ( count != 0  ) { count--; }
    if ( count == 1 )  {                        
        
                rythm_count++;

                switch ( rythm_count ) {
                        case 1:  beat[0].rythm = 3;  beat[0].PAGE_Steps = 12; break;
                        case 2:  beat[0].rythm = 4;  beat[0].PAGE_Steps = 16; break;
                        case 3:  beat[0].rythm = 5;  beat[0].PAGE_Steps = 10; break;
                        case 4:  beat[0].rythm = 6;  beat[0].PAGE_Steps = 12; break;
                        case 5:  beat[0].rythm = 7;  beat[0].PAGE_Steps = 14; break;
                        case 6:  beat[0].rythm = 9;  beat[0].PAGE_Steps =  9; break;
                        case 7:  beat[0].rythm = 11; beat[0].PAGE_Steps = 11; break;
                        default: beat[0].rythm = 13; beat[0].PAGE_Steps = 13; rythm_count = 0; break;
                        }

    
                // rythm repeats...5x5? or 5x50?
                beat[0].MainLoop = beat[0].rythm * 8;
                flag.NeedSync = 1;      //  to give the order to change the loop...after some time it will change.

                LED_Gestic = 0;           // LED-Gestic "Indicate rythm & Show rythm-Set"     
      
      }


////////////////////////////////////////////////////////////////////////////////////////////7        

    static u32 SDCardCount = 0;
    SDCardCount++; // 2s Counter > send Check-SDCard-Commant to StoreLoad-Function (track, clip, job)
    if (SDCardCount > SD_Check_Time) { SDCardCount = 0; SD(0, 3); }   

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



    if(flag.Update_Synth == 1) {
        
                static u16 DumpCount = 0;
                DumpCount++;
                if( DumpCount >= DumpOutRateSynth)   {

                                DumpCount = 0; // reset counter, for next cycle
                                
                                static u8 cc = 0; 
                                cc++; //dump CC number out 
                                
                                if(cc > 31){ cc = 0; flag.Update_Synth = 0;} // when all CCs are sent out, delete the Flag...

                                    static u8 track = 0; 
                                    for(track=0; track<8; track++) {

                                        //only Dump out if the CC is really in use! (255=not used)
                                        if(beat[track].CC_Store[cc] != 255){
                                            MIOS32_MIDI_SendCC(MeloPort, MeloCh[track], CC_Map0[track][cc], beat[track].CC_Store[cc]);} 
                                        else if(beat[track].CC_Store[cc] == 255){         
                                            MIOS32_MIDI_SendCC(MeloPort, MeloCh[track], CC_Map0[track][cc], 0); } } // else turn of Encoder (0 position)
                                }
                            //Disable RELOAD Button
                            if(Button_Bank == 1) {  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 12, 0);} 
            LED_Gestic = 2;} //LED-Gestic "DONE"


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    if(flag.Update_Remote == 1) {
        
        // Dump OUT REMOTE CCs to BCR      
        if(CC_Map_Mode == 0) { // 0: Deep Edit Mode - ALL controlls for 1 Channel 
                    
                static u32 count = 0;
                count++;
                if( count >= DumpOutRateRemote)   {

                        count = 0; // reset counter, for next cycle
                        
                        static u8 cc = 0; 
                        cc++;  // CC dump-out-number 0-31 counter
                        
                        // when everything is done:....
                        if(cc > 31){    cc = 0;                 // break loop
                                        flag.Update_Remote = 0; // break loop: when all CCs are sent out, delete Flag...
                                        LED_Gestic = 2;         // LED-Gestic "DONE"

                                        if(Button_Bank == 0) {  u8 x; for(x=0; x<8; x++) {
                                                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8, beat[x].MSQ_Active);
                                                             } }
                                                             
                                        if(Button_Bank == 1) {  u8 x; for(x=0; x<8; x++) {
                                                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8, 0); } // disable buttons
                                                                }
                                        
                                        
                                        u8 x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0); }         // disable old PART LEDs
                                                                   MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1); // enable new part
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19,  beat[Active_Part].MSQ_Rec);            // restore REC Button
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37,  beat[Active_Part].loop_lenght_set);    // restore Loop Length Enc         
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38,  beat[Active_Part].Velo_Morph_Offset);  // restore Offset Enc
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 16,  CC_Map_Mode);  // send out CC_Map_Mode State
                                        if(Button_Bank == 1) {  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 9, 0); }            // Disable LOAD Button 
                                    }
                                 
                        if(CC_Map0[Active_Part][cc] != 255) { // But only if the CC is really used (255: not used/mapped)
                                    
                                MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, cc, beat[Active_Part].CC_Store[cc]);    }

                        // else turn off Encoder ////// 505
                        else if(beat[Active_Part].CC_Store[cc] == 255) {    MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,  cc,  0);     }       
                } }


        // Dump OUT REMOTE CCs to BCR      
        if(CC_Map_Mode == 1) { // 1: Channelstrip Mode - 4 controlls for 8 Channels

                static u32 count = 0;
                count++;
                if( count >= DumpOutRateRemote)   {

                        count = 0; // reset counter, for next cycle
                        
                        static u8 cc = 0; 
                        cc++;  // CC dump-out-number 0-32 counter

                            
                        // when everything is done:....
                        if(cc > 32){    cc = 0;                 // break loop
                                        flag.Update_Remote = 0; // break loop: when all CCs are sent out, delete Flag...
                                        LED_Gestic = 2;         // LED-Gestic "DONE" 
                                        u8 x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0); }             // disable old Set LEDs
                                                                   MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Strip_Set, 1);// enable new Set LED
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 16, CC_Map_Mode);  // send out CC_Map_Mode State
                                        if(Button_Bank == 1) {  u8 x; for(x=0; x<8; x++) {
                                                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8, 0); } // disable buttons
                                                                }
                                    }
                                
                        // but bevore...: Dump Out CCs!             
                        //if(CC_Map1[Active_Strip_Set][ cc ] != 32) {   // But only if the CC is really used (32: not used/mapped)
            if (cc == 0 || cc == 8  || cc == 16 || cc == 24) {Strip_CH = 0;}
            if (cc == 1 || cc == 9  || cc == 17 || cc == 25) {Strip_CH = 1;}
            if (cc == 2 || cc == 10 || cc == 18 || cc == 26) {Strip_CH = 2;}
            if (cc == 3 || cc == 11 || cc == 19 || cc == 27) {Strip_CH = 3;}
            if (cc == 4 || cc == 12 || cc == 20 || cc == 28) {Strip_CH = 4;}
            if (cc == 5 || cc == 13 || cc == 21 || cc == 29) {Strip_CH = 5;}
            if (cc == 6 || cc == 14 || cc == 22 || cc == 30) {Strip_CH = 6;}
            if (cc == 7 || cc == 15 || cc == 23 || cc == 31) {Strip_CH = 7;}

MIOS32_MIDI_SendCC( Remote1Port,   Remote1_Automate_CH,  cc,   beat[Strip_CH].CC_Store[ CC_Map1[Active_Strip_Set][cc] ] );  // Val

                        ////////////  //505
                        // else turn off Encoder                                                                        Port         Channel   
                        if(CC_Map1[Active_Strip_Set][ cc ] == 32) {   MIOS32_MIDI_SendCC( Remote1Port,   Remote1_Automate_CH, cc,  0 ); }
                        ///////////
            } } }

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    if(flag.Update_Remote_Velo == 1) {

        // Dump OUT REMOTE CCs to BCR      
                    
                static u32 count = 0;
                count++;
                if( count >= DumpOutRateRemote_Velo)   {

                        count = 0; // reset counter, for next cycle
                        
                        static u8 cc = 0; 
                        cc++;  // CC dump-out-number 0-31 counter
                        
                        // when everything is done:....
                        if(cc > 31){    cc = 0;                       // break loop
                                        flag.Update_Remote_Velo = 0;} // break loop: when all CCs are sent out, delete Flag...
                                        
                        // Dump-Out All LED Rings   with  Velocity assigned Values
                        if(CC_Map0[Active_Part][cc] != 255) { // But only if the CC is really used (255: not used/mapped)
                                    MIOS32_MIDI_SendCC( Remote1Port, Remote1_Automate_CH, cc, beat[Active_Part].Velo_Morph[cc]);
                                    //MIOS32_MIDI_SendDebugMessage("port:%d, ch:%d, cc:%d, value:%d", Remote1Port, Remote1_Automate_CH, cc, beat[Active_Part].Velo_Morph[cc]);
                                    //MIOS32_MIDI_SendDebugMessage("part:%d", Active_Part);
                                    }}
    }

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    if(flag.MSQ_Mute_Remote_timer == 1) { // Unmute Remote after a while

                    
                static u32 count = 0;
                count++;
                if( count >= 500)   {

                        count = 0;                      // reset counter, for next cycle
                        flag.MSQ_Mute_Remote_timer = 0; // kill flag
                        MSQ_Mute_Remote = 0;            // activate  Motion Sequencer Display  again
                }
    }

                                                                



}

static void Router(u32 port, u32 control, s32 value) { // DIN, ENCs, MidiCC all together

    //// Patch-CCs-(Synths) ////

    switch( port ) {


        case 0: // Deep Edit Mode - ALL controlls for 1 Channel
        
                // save last moved CC
                beat[Active_Part].MSQ_LastMoved = control;      // need later to delete MotionSequences on it
            
                // Store CC
                beat[Active_Part].CC_Store[control] = value;    // write  into  CC-Storage

                // Clear Selected Motion Sequences 
                if( MSQ_Clear_Sel == 1 )  { int x; for(x=0; x<256; x++) { beat[Active_Part].MSQ_Store[beat[Active_Part].MSQ_LastMoved][x]=128; } break;}
              
                // Talk to SYNTH - Routing//                                        
                // Send CC        Midi Port  Midi Channel        CC-Nr: [Active Part Number] [last mooved CC Number]            
                MIOS32_MIDI_SendCC(MeloPort, MeloCh[Active_Part],   CC_Map0[Active_Part][beat[Active_Part].MSQ_LastMoved],
                                                              // CC-Val: [Active Part Number] [last mooved CC Number]               
                                                                    beat[Active_Part].CC_Store[beat[Active_Part].MSQ_LastMoved]); 
                break;

        
        case 1: // Channel Strip - importend Controls  on  8 Channels
            
                // get Strip_CH
                if (control == 0 || control == 8  || control == 16 || control == 24) {Strip_CH = 0;}
                if (control == 1 || control == 9  || control == 17 || control == 25) {Strip_CH = 1;}
                if (control == 2 || control == 10 || control == 18 || control == 26) {Strip_CH = 2;}
                if (control == 3 || control == 11 || control == 19 || control == 27) {Strip_CH = 3;}
                if (control == 4 || control == 12 || control == 20 || control == 28) {Strip_CH = 4;}
                if (control == 5 || control == 13 || control == 21 || control == 29) {Strip_CH = 5;}
                if (control == 6 || control == 14 || control == 22 || control == 30) {Strip_CH = 6;}
                if (control == 7 || control == 15 || control == 23 || control == 31) {Strip_CH = 7;}
                
                // Store CC
                beat[Strip_CH].CC_Store  [ CC_Map1[Active_Strip_Set][control] ] = value;    // CC_Map1[8][32] 
                
                // Send CC       //Midi Port //Channel                  // CC-Number                                                   // CC-Value
                //                             of Active Part         of   [StripNr]  [Remapping]                                of       Strip CH    REMAP    Strip CH    Remap      Strip Set        BCR-CC
                MIOS32_MIDI_SendCC(MeloPort,  MeloCh[Strip_CH],    CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][control] ],     beat[Strip_CH].CC_Store  [CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][control]] ]);
                break;

        case 3: // REMOTE THIS APP     
               
        // 0: Deep Edit Mode - ALL controlls for 1 Channel 
        if(CC_Map_Mode == 0) {      
                 
                // Select Part Number   &&   DumpOut States
                if(control < 8 && control >= 0) {
                    
                    // Active Part Number                
                    Active_Part = control;
                    
                        // Disable ALL Active-Part Switches, except the New one
                        int x; for(x=0; x<8; x++) {   if(x != Active_Part){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);} }
                        // Enable the new Active Part Switch
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                        
                        // Dump Different Button States out
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, beat[Active_Part].MSQ_Rec); 
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, beat[Active_Part].loop_lenght_set);             
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, beat[Active_Part].Velo_Morph_Offset); 
                        
                        // Dump Rotary CCs 2 Remote out
                        flag.Update_Remote = 1; 
                        }

                    
                // The Rest of the Controlls

                // MSQ Record - Btn & FootSwitch
                if(control == 19 || control == 26) {beat[Active_Part].MSQ_Rec =! beat[Active_Part].MSQ_Rec;   MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, beat[Active_Part].MSQ_Rec); }
                // Rotary Loop Length Set
                if(control == 37) {beat[Active_Part].loop_lenght_set = value; flag.NeedSync = 1;}
                // Rotary Global Morph Offset
                if(control == 38) {beat[Active_Part].Velo_Morph_Offset = value;} 

                // MSQ_Clear_Select - Btn & Footswitch              
                if(control == 18 || control == 27) {MSQ_Clear_Sel = value;} //CLEAR LAST Selected Motion Sequence
                //CLEAR ALL MSQs   
                if(control == 17) {MSQ_Clear_All = value;  
                                    if(MSQ_Clear_All == 1) { //CLEAR MSQ only by pressed button
                                    int x; for(x=0; x<256; x++) { int y; for(y=0; y<32; y++) {beat[Active_Part].MSQ_Store[y][x]=128;}}}}
            }
                
        // 1: Channel Strip - 4 Controls on 8 Channels
        if(CC_Map_Mode == 1) {    
              
                // Select Strip Number
                if(control < 8 && control >= 0) {
                                                    Active_Strip_Set = control;
                                                    flag.Update_Remote = 1;
                }
                    }
                   
 
        // GLOBAL APP REMOTE PARAMETERS
        
        // Button Bank Switch  +  Virtual Button Group "Button_Bank" for the upper 8 horizontal LED-Buttons...
        if(control == 24) {Button_Bank = 0;  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 24, 1); //MSQ_ACTIVE-Bank --- is MSQ Active
                                             MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 25, 0);
                                             flag.Update_Remote = 1;}                                             
        
        
        // Button Bank Switch  +  Virtual Button Group "Button_Bank" for the upper 8 horizontal LED-Buttons...                                                                        
        if(control == 25) {Button_Bank = 1;  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 24, 0); 
                                             MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 25, 1);
                                             flag.Update_Remote = 1;}
        
        
        // MSQ - Mute Buttons
        if( Button_Bank == 0 ) { 
                                if(control > 7 && control < 16) {   beat[control-8].MSQ_Active =! beat[control-8].MSQ_Active;  }  }


        // Load, Store, Reload-Synth, COPY PASTE
        if( Button_Bank  == 1 ) {
                                //Bank Variants
                                if(control ==  8) { SD(SongNrStor, 2); } // save
                                if(control ==  9) { SD(SongNrLoad, 1); } // load
                                if(control == 12) { flag.Update_Synth = 1; } // send all CCs to Synth again
                                
            if( CC_Map_Mode == 0) { // Copy Paste Single Drum-voices
                                if(control == 13) { memcpy ( &beat_cpy,  &beat[Active_Part],  sizeof (store_t) ); // COPY
                                                    flag.Update_Remote = 1; }
                                if(control == 14) { memcpy ( &beat[Active_Part],  &beat_cpy,  sizeof (store_t) );          // PASTE
                                                    flag.Update_Remote = 1; }
                                                            //memcpy(&beat_cpy,    &beat,  sizeof (store_t) );        // beat info
                                                            
                                                            //memcpy(&beat,   &beat_cpy,      sizeof (store_t) );  // beat info
                                }
            if( CC_Map_Mode == 1) { // Copy Paste ALL Drum-voices   //   303 copys only one Voice!!!!
                                if(control == 13) { memcpy (  &beat_cpy,  &beat,  8*(sizeof (store_t) )  ); // COPY
                                                    flag.Update_Remote = 1; }
                                if(control == 14) { memcpy (  &beat,  &beat_cpy,  8*(sizeof (store_t) )  ); // PASTE
                                                    flag.Update_Synth  = 1;
                                                    flag.Update_Remote = 1; }
                                                            //memcpy(&beat_cpy,    &beat,  sizeof (store_t) );        // beat info
                                                            
                                                            //memcpy(&beat,   &beat_cpy,      sizeof (store_t) );  // beat info
                                }

                                
            } 

    }
}//End Hook ROUTEER


void APP_Tick(void){
        // Programchange Load when Stopped turning the Wheel (from External Source, internal we use a LOAD-Button for that)
    if( flag.PCLoad == 1 )  {
            static u32 x = 0;
            x++; 
            if( x > PC_Load_Timer ) {   x            = 0;       // init counter for the next run
                                        flag.PCLoad  = 0;       // Kill Flag to avoid double triggering events
                                        SD(SongNrLoad, 1); }}   // LOAD

    if( flag.PCSave == 1 )  {
            static u32 x = 0;
            x++;

            if( x > PC_Save_Timer ) {   x            = 0;     // init counter for the next run
                                        flag.PCSave  = 0;     // Kill Flag to avoid double triggering events
                                        SD(SongNrStor, 2);
                                        flag.Update_Synth = 1;// send all CCs to Synth again
                                        
                                        }} // Store

    if( flag.Tact_Ex_Load == 1 )  {
            static u32 x = 0;
            x++; 
            if( x >  PC_Load_Timer  + 10 ) {
                                        x                  = 0;         // init counter for the next run
                                        flag.Tact_Ex_Load  = 0;         // Kill Flag to avoid double triggering events
                                        beat[0].rythm = CC_Tact_Ext_Storage;   // external received Tact over-ruling internal saved Tact
                    switch(CC_Tact_Ext_Storage) {
                        case 3:  rythm_count = 1; beat[0].PAGE_Steps = 12; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break;
                        case 4:  rythm_count = 2; beat[0].PAGE_Steps = 16; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break; 
                        case 5:  rythm_count = 3; beat[0].PAGE_Steps = 10; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break; 
                        case 7:  rythm_count = 5; beat[0].PAGE_Steps = 14; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break; 
                        case 9:  rythm_count = 6; beat[0].PAGE_Steps =  9; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break; 
                        case 11: rythm_count = 7; beat[0].PAGE_Steps = 11; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break; 
                        case 13: rythm_count = 8; beat[0].PAGE_Steps = 13; flag.NeedSync = 1; beat[0].MainLoop = beat[0].rythm * 8; break;
                    }}} // Done
                                        
/////////////////////////////////////////////////////////////////////////////////////////////////////7
//Blink Counter for Varios functions...
static u32 count = 0;   
static u8 LED_Gestic_move  = 0;
static u32 Duration_count = 0;
static u8 x = 1;
                
    //Gestics off the minimal LED-Interface
    //Visualize LEDs @ J5A Pin1-3 and J5B Pin 0-3 dont use Pin0 of J5B because it is the Button Input for RYTHM > see APP_Background
    

    switch ( LED_Gestic ) {
        
        
        case 0: // Normal Mode Just dumpout RYTHM-SET-LED    
                    for( x=1; x<8; x++) { MIOS32_BOARD_J5_PinSet(x, 0);}   // Turn off all LEDs
                    
                    switch ( beat[0].rythm ) {
                        case 3:  MIOS32_BOARD_J5_PinSet(1, 1); break; // Turn on one LED - Indicate rythmset (4/4 by default)
                        case 4:  MIOS32_BOARD_J5_PinSet(2, 1); break;
                        case 5:  MIOS32_BOARD_J5_PinSet(3, 1); break;
                        case 7:  MIOS32_BOARD_J5_PinSet(4, 1); break;
                        case 9:  MIOS32_BOARD_J5_PinSet(5, 1); break;
                        case 11: MIOS32_BOARD_J5_PinSet(6, 1); break;
                        case 13: MIOS32_BOARD_J5_PinSet(7, 1); break;} break;

        case 1: // Operating - busy
                count++; 
                if(count > LED_Gestic_Rate) {
                        count = 0;          // some time has passed - do something
                        for(x=1; x<8; x++) { MIOS32_BOARD_J5_PinSet(x, 0); } // Turn off all LEDs
                        
                        LED_Gestic_move++; // counter for the led sequence
                        switch ( LED_Gestic_move ) {                        
                                case 1: MIOS32_BOARD_J5_PinSet(1, 1);  break;  //  X......
                                case 2: MIOS32_BOARD_J5_PinSet(2, 1);  break;  //  .X.....
                                case 3: MIOS32_BOARD_J5_PinSet(3, 1);  break;  //  ..X....
                                case 4: MIOS32_BOARD_J5_PinSet(4, 1);  break;  //  ...X...
                                case 5: MIOS32_BOARD_J5_PinSet(5, 1);  break;  //  ....X..
                                case 6: MIOS32_BOARD_J5_PinSet(6, 1);  break;  //  .....X.
                                case 7: MIOS32_BOARD_J5_PinSet(7, 1);  break;  //  ......X
                                default:LED_Gestic_move = 0; break; }
                        // Endless Sequence, unless something out there change the LED_Gestic value  
                    }
                    
    
        case 2: // YES! operation done  
                    Duration_count++;
                    if(Duration_count < LED_Gestic_Duration) { // some time has passed do something
                        
                        count++;
                        if(count > LED_Gestic_Rate * 2) {
                            
                                count = 0;
                                
                                for(x=1; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);} // Turn off all LEDs
        
                                LED_Gestic_move++; // counter for the led sequence
                                
                                switch ( LED_Gestic_move ) {                        
                                        case 1: MIOS32_BOARD_J5_PinSet(7, 1);           //  X.....X
                                                MIOS32_BOARD_J5_PinSet(1, 1); break;
                                        case 2: MIOS32_BOARD_J5_PinSet(6, 1);           //  .X...X. 
                                                MIOS32_BOARD_J5_PinSet(2, 1); break;
                                        case 3: MIOS32_BOARD_J5_PinSet(5, 1);           //  ..X.X..
                                                MIOS32_BOARD_J5_PinSet(3, 1); break;     
                                        case 4: MIOS32_BOARD_J5_PinSet(4, 1); break;    //  ...X...
                                        case 5: MIOS32_BOARD_J5_PinSet(7, 1);           //  X.....X
                                                MIOS32_BOARD_J5_PinSet(1, 1); break;
                                        case 6: MIOS32_BOARD_J5_PinSet(7, 1);           //  X.....X
                                                MIOS32_BOARD_J5_PinSet(1, 1); break;  
                                        default:LED_Gestic_move = 0;          break;}
                }}
                
                    else {  Duration_count  = 0;
                            LED_Gestic      = 0;
                            LED_Gestic_move = 0;
                            count           = 0;
                            for(x=1; x<8; x++) { MIOS32_BOARD_J5_PinSet(x, 0); } // Turn off all LEDs
                            break;}// break cycle

               
        case 3: // Nope! something went wrong!     
                Duration_count++; // timer

                    count++; 
                    if(count >= LED_Gestic_Rate) { // some time has passed do something
                            count = 0;          
                            for(x=1; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);} // Turn off all LEDs
                            
                        LED_Gestic_move++; // counter for the led sequence
                        
                        switch ( LED_Gestic_move ) {     // LED-SEQUENCE                    
                                case 1: MIOS32_BOARD_J5_PinSet(4, 1); break;// ...X... //activate middle LED (we have 7 LEDs)
                                case 2: MIOS32_BOARD_J5_PinSet(3, 1);       // ..X.X..
                                        MIOS32_BOARD_J5_PinSet(5, 1); break;
                                case 3: MIOS32_BOARD_J5_PinSet(4, 1); break;// ...X... //activate middle LED (we have 7 LEDs)
                                default:LED_Gestic_move = 0;          break;}
                    }
                if(Duration_count >  6 * LED_Gestic_Duration) {
                            Duration_count  = 0;
                            LED_Gestic      = 0;
                            LED_Gestic_move = 0; // goto normal mode again
                            count           = 0; } 
                
            break;
            
        } // End Switch
        
    } // called each mS from main task which also handles DIN, ENC and AIN events. You could add more jobs here - dont do more than 300uS!

       
void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){
    
// local Variables
static u8 old_CC_Map_Mode = 0;
static u8 Bank = 0; // CC  for  Program-Change Bank

    // Midi CCs
    switch(port) {
        
        case Remote1Port: /////////////////////////////////////////////////////////////////////////////////////////////////////////
        
                        switch(midi_package.chn) {
        
                            
                                case Remote1_Setting_CH:  // Forward CCs  -  4 Internal Functions...
        
        
                                            switch( midi_package.cc_number ) {
                
                                                    case 29: // Velocity Assign Button      switch between:   Velocity Mode   &   CC-Map Modes
                                                    
                                                            if( midi_package.value == 1 ) {     // Velocity Assign Button - is pressed
                                                                MSQ_Mute_Remote = 1;            // avoid Conflicts, since CC-UI  is  multiple used
                                                                old_CC_Map_Mode = CC_Map_Mode;  // backup Map_Mode - save
                                                                CC_Map_Mode = 2;                // 2: Velocity Assign, 0:CC-Voice, 1:CC-Channelstrip
                                                            
                                                                beat[Active_Part].MSQ_Rec_mem  = beat[Active_Part].MSQ_Rec; // save actual REC state
                                                                beat[Active_Part].MSQ_Rec      = 0;    // Temporary  Deactivate  Record Mode 

                                                                flag.Update_Remote_Velo = 1;    // send out   all Velocity-Offset-Encs   to   Remote     
                                                                
                                                            break; }


                                                            if( midi_package.value == 0 ) {     
                                                                
                                                                beat[Active_Part].MSQ_Rec   = beat[Active_Part].MSQ_Rec_mem;    // Recall Patch & States 

                                                                flag.Update_Remote = 1; // Recall All LED Rings  with  CC-Storage
                                                                
                                                                CC_Map_Mode = old_CC_Map_Mode;  // backup Map_Mode restore

                                                                flag.MSQ_Mute_Remote_timer = 1; // activate  Motion Sequencer Display  again ... after a while
                                                                
                                                            break; } 
   

                                                    case 30: // Clear ALL Velo-Morphs   -  -  initalize to 63 - which is neutral (-63+)  
                                                            if(midi_package.value == 1) {   // CLEAR Morph only by pressed button
                                                                MSQ_Mute_Remote = 1;        // Mute     Motion Sequecer-Display
                                                                int y; for(y=0; y<32; y++) {beat[Active_Part].Velo_Morph[y] = 63;} break;} // set Morph 0

                                                            if(midi_package.value == 0) {   // Return to Stadard CC View
                                                                    MSQ_Mute_Remote = 0;  break; }  // Un-Mute  Motio Sequencer-Display
                
                                                    case 16: // CC-Map Mode  Toggle-Switch   ( switch between single-Voice   &   8-Voice Channelstrip )   
                                                        CC_Map_Mode = midi_package.value;
                                                        flag.Update_Remote = 1;  // DUMP - OUT CC-Status
                                                        break;


                                                    default: Router( 3, midi_package.cc_number, midi_package.value ); break;
                                                    
                                            break; }
                                break;

        

                                        
                                case Remote1_Automate_CH:  // Forward CCs 
        
                                        if( CC_Map_Mode  ==  0 ) {  Router(0, midi_package.cc_number, midi_package.value);      break; }
                                        if( CC_Map_Mode  ==  1 ) {  Router(1, midi_package.cc_number, midi_package.value);      break; }
                                        if( CC_Map_Mode  ==  2 ) {  beat[Active_Part].Velo_Morph[midi_package.cc_number] = midi_package.value; break; }// write  into  Velocity Morph
                                        break;
                        }



        case MeloPort: /////////////////////////////////////////////////////////////////////////////////////////////////////////

                // forwarding Midiclock & Transport     //    248CLK,250Strt,251Cont,252Stp
                if( TrigMidiThruClock==1  &&  (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252) )
                        { MIOS32_MIDI_SendPackage(MeloPort,  midi_package); break; }


                if( midi_package.chn == PCChIN  &&  midi_package.type == CC) {
                    
                            switch( midi_package.cc_number ) {
                                         
                                        case CC_PC_Bank:    Bank = midi_package.value * 128;  break;
                                        case CC_Tact_mono:  CC_Tact_Ext_Storage = midi_package.value;  flag.Tact_Ex_Load = 1;  break;  // set Rythm
                                        case CC_Save_mono:  SongNrLoad  = midi_package.value + Bank; // generate ProgramChange message via SAVE dialog
                                                            SongNrStor  = SongNrLoad;   
                                                            flag.PCSave = 1;  break; // Save after a while
                            }}
                                    
                            switch(midi_package.evnt0) {
                                    //  Midi CH         PC-Channel         Song-Nr   =              PC-Nr + Bank   Load after a while    also set Store-Number 
                                        case 192:   if( PCChIN == 0 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 193:   if( PCChIN == 1 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 194:   if( PCChIN == 2 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 195:   if( PCChIN == 3 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 196:   if( PCChIN == 4 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 197:   if( PCChIN == 5 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 198:   if( PCChIN == 6 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 199:   if( PCChIN == 7 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 200:   if( PCChIN == 8 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 201:   if( PCChIN == 9 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 202:   if( PCChIN == 10 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 203:   if( PCChIN == 11 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 204:   if( PCChIN == 12 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 205:   if( PCChIN == 13 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 206:   if( PCChIN == 14 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 207:   if( PCChIN == 15 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                            }
                            

              // Make Velocity
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[0]  &&  midi_package.velocity > 0 )  { Velo_From_Note[0] = midi_package.velocity; }
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[1]  &&  midi_package.velocity > 0 )  { Velo_From_Note[1] = midi_package.velocity; }
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[2]  &&  midi_package.velocity > 0 )  { Velo_From_Note[2] = midi_package.velocity; }  
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[3]  &&  midi_package.velocity > 0 )  { Velo_From_Note[3] = midi_package.velocity; }  
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[4]  &&  midi_package.velocity > 0 )  { Velo_From_Note[4] = midi_package.velocity; }  
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[5]  &&  midi_package.velocity > 0 )  { Velo_From_Note[5] = midi_package.velocity; }
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[6]  &&  midi_package.velocity > 0 )  { Velo_From_Note[6] = midi_package.velocity; }  
              if( midi_package.type == NoteOn  &&  midi_package.chn == MeloCh[7]  &&  midi_package.velocity > 0 )  { Velo_From_Note[7] = midi_package.velocity; }  

              //forwarding Notes
              if(midi_package.evnt0==144) {//Note @ Midi Channel 1
                     if(MeloCh[0]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==145) {//Note @ Midi Channel 2
                     if(MeloCh[0]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==146) {//Note @ Midi Channel 3
                     if(MeloCh[0]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==147) {//Note @ Midi Channel 4
                     if(MeloCh[0]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==148) {//Note @ Midi Channel 5
                     if(MeloCh[0]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==149) {//Note @ Midi Channel 6
                     if(MeloCh[0]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==150) {//Note @ Midi Channel 7
                     if(MeloCh[0]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==151) {//Note @ Midi Channel 8
                     if(MeloCh[0]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==152) {//Note @ Midi Channel 9
                     if(MeloCh[0]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==153) {//Note @ Midi Channel 10
                     if(MeloCh[0]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==154) {//Note @ Midi Channel 11
                     if(MeloCh[0]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}   
                else if(MeloCh[3]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==155) {//Note @ Midi Channel 12
                     if(MeloCh[0]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==156) {//Note @ Midi Channel 13
                     if(MeloCh[0]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==157) {//Note @ Midi Channel 14
                     if(MeloCh[0]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==158) {//Note @ Midi Channel 15
                     if(MeloCh[0]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
              if(midi_package.evnt0==159) {//Note @ Midi Channel 16
                     if(MeloCh[0]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[4]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[5]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[6]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[7]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} } 
        }
        }


void APP_SRIO_ServicePrepare(void){}
void APP_SRIO_ServiceFinish(void){}
void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){}

static void TASK_SEQ(void *pvParameters){ // called each mS > seuecer request
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

// SEQ --- Installed via MIOS32_MIDI_DirectRxCallback_Init
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if(port == MeloPort) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}



u8 MSQ(u8 port, u8 step) {  //  CC Automation - Motion Sequencer


 //Play MSQ @ REMOTE
 if( Active_Part == port  &&  CC_Map_Mode == 0  &&  MSQ_Mute_Remote == 0 ) {

    if (beat[Active_Part].MSQ_Active == 1 ) {
        
        // Show automated CCs
        int x; for(x=0; x<32; x++) {
           if(beat[port].MSQ_Store[x][step] != 128) { 
             // 2 Remote
             MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, x, beat[port].MSQ_Store[x][step]);}} // but only if there is data in there!
             
        // REC MSQ
        if(beat[port].MSQ_Rec == 1) {  beat[port].MSQ_Store[beat[Active_Part].MSQ_LastMoved][step] = beat[Active_Part].CC_Store[beat[Active_Part].MSQ_LastMoved]; }
   }
   
    //show Loop Position on a LED-RING
    static int IND = 0; 
    IND = ((10000*loop_step_pos[Active_Part]/(beat[0].PAGE_Steps*(beat[Active_Part].loop_lenght_set+1))) * 16)/10000; // scale LoopLength to 0-15 LEDs   
    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND); // send to Remote
       }



 // Play MSQ @ SYNTH && ADD Velocity Offset
 if( port < 8  &&  beat[port].MSQ_Active == 1 ) {
        static float value = 0;
        static float morph = 0;
                  
        int x; for(x=0; x<32; x++) {

            value = beat[port].CC_Store[x]; // VALUE = Actually CC-VALUE of REMOTE
                      
            if( beat[port].MSQ_Store[x][step] != 128 ) { value =  beat[port].MSQ_Store[x][step]; } // overwrite  VALUE  with MotionSequence
            

            if( beat[port].MSQ_Store[x][step] != 128   ||   beat[port].Velo_Morph[x] != 63 ) { // no Motion Sequence   but  Velocity Offset
                
                    // calculate CC Value    
                    morph = (((Velo_From_Note[port]/127.0) * (beat[port].Velo_Morph[x]-64.0))  / 64.0)   *   beat[port].Velo_Morph_Offset;
                    int morphint = morph;
                    
                    value = value + morph;
                    
                    if(value <=   0) { value = 0; }    // only in a range of 0-127
                    if(value >= 127) { value = 127; }  // only in a range of 0-127
                    
                    int valueint = value;

                    if(port == 0 ) { MIOS32_MIDI_SendDebugMessage("cc:%d, morph:%d, value:%d", x, morphint, valueint);}  // DEBUG
        
               //Talk to SYNTH   --- and ADD Velocity Morph!
               MIOS32_MIDI_SendCC(MeloPort, MeloCh[port], CC_Map0[port][x], valueint);

    }}
}

  return 0; // no error,
}


// S T O R A G E - SD - C A R D      ///        // read write clips/programchanges
void SD(u16 clip, u16 job){           // Job1=load, Job2=store, Job3=initalize card

    const static char file_type[4] = "bcr1";    // definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header
    static char file_path[16] =  {};            // STORE-path - Number of Pathsymbols tm/512.tm    
    static s8 statusSD;			                // Status of the SDCard--connected? fat?
    static s8 statusDir;			            // Status "is" your direction "sdcard/t" there?
    static file_t midifile_fi;                  // used to read files from SD-Card
    
                             
    switch(job) {   
 
// R E A D /////////////////////////////////////////////////////////////////////////////////////////////////////// 
          
            case 1:
                    // L O A D Clip
                    sprintf         ( file_path, "bc/%d.bc", clip );
                    
                    MUTEX_SDCARD_TAKE;  
                        FILE_ReadOpen   ( &midifile_fi, file_path );
                        FILE_ReadBuffer ( (u8 *)&file_type, sizeof(file_type) ); 
                        FILE_ReadBuffer ( (u8 *)&beat, 8 * sizeof(store_t) );
                        FILE_ReadClose  ( &midifile_fi );
                    MUTEX_SDCARD_GIVE;
                    
                    flag.NeedSync = 1; //update ClockCounter when ready...
                    LED_Gestic = 2;
                    
                    flag.Update_Remote = 1;
                    flag.Update_Synth  = 1;
                break;
                	
                    
// S T O R E /////////////////////////////////////////////////////////////////////////////////////////////////////               
  
            case 2:
                    // S A V E Clip
                    sprintf(file_path, "bc/%d.bc", clip);
                     
                    MUTEX_SDCARD_TAKE;
                            //Write to File           
                            FILE_WriteOpen	( file_path,        sizeof(file_path) );   
                            FILE_WriteBuffer( (u8  *)&file_type,sizeof(file_type) ); //"SIGL" = 4 Positons                                                     
                            FILE_WriteBuffer( (u8  *)&beat, 8 * sizeof(store_t) );                                                             
                            FILE_WriteClose	(); 
                    MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                    
                    LED_Gestic = 2;
                    flag.Update_Remote = 1;
                break;
                    

//  I N I T - S D - CARD //////////////////////////////////////////////////////////////////////////////////7//////   
  // THIS WILL TAKE 10minutes//
            case 3: //check SD-Card
                    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
                      statusSD = FILE_CheckSDCard();
                      switch(statusSD) {
                          case 2:
                                // MIOS32_MIDI_SendDebugMessage("no card");
                                LED_Gestic=3;
                            break;
                            
                          case 1: // YES CARD!  >>> next: check Card-content
                             statusDir = FILE_DirExists("bc");	 // ask file.c: exist a folder "t/" on the CARD? // 
                             if (statusDir == 1){                                         
                                    //MIOS32_MIDI_SendDebugMessage("SD OK");
                                    LED_Gestic=0;
                                  break;} 
                             
                             if (statusDir == 0){
                                                                          
                                    //MIOS32_MIDI_SendDebugMessage("Init Card, take a minute");
                                    LED_Gestic=1;
                                                      
            
                                        FILE_MakeDir("bc");                           

                                        // calculate file path
                                        sprintf(file_path, "bc/%d.bc", clip);
                                        
                                        //C L I P > Write to File           
                                        FILE_WriteOpen	( file_path,                sizeof(file_path) );                 
                                                FILE_WriteBuffer( (u8  *)&file_type,sizeof(file_type) ); //"SIGL" = 4 Positons     
                                                FILE_WriteBuffer( (u8  *)&beat, 8 * sizeof(store_t) ); 
                                        FILE_WriteClose	();

                                                            
                                            //copy-prototype file to 512x clip files on SD-Card
                                                u16 clipco;  // declare clip Counter 
                                                for(clipco = 0; clipco<256; clipco++){  //countes 2 511 and do following commandos 511 times in a loop:

                                                    char copyfilepath[16];
                                                    sprintf   (copyfilepath, "bc/%d.bc", clipco);  // make a new filename depending on the counter value 1.tm, 2.tm, 3.tm...511.tm
                                                    FILE_Copy ( (char *)"bc/0.bc", (char *)copyfilepath );} // copy the File 0.tm to all other 511 files...

                                    //MIOS32_MIDI_SendDebugMessage("Init Done");
                                    LED_Gestic=2;
                                
                                    break;} 
                        }
                        MUTEX_SDCARD_GIVE;
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 15, 0); //deactivate the Store button on the BCR, so you notice that it is done!  
                        }
}
