#ifndef _APP_H
#define _APP_H
extern s32 SEQ_Init(u32 mode);
extern s32 SEQ_Reset(void);
extern s32 SEQ_Handler(void);
extern void APP_Init(void);
extern void APP_Background(void);
extern void APP_Tick(void);
extern void APP_MIDI_Tick(void);
extern void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package);
extern void APP_SRIO_ServicePrepare(void);
extern void APP_SRIO_ServiceFinish(void);
extern void APP_DIN_NotifyToggle(u32 pin, u32 pin_value);
extern void APP_ENC_NotifyChange(u32 encoder, s32 incrementer);
extern void APP_AIN_NotifyChange(u32 pin, u32 pin_value);
extern u8 MSQ(u8 port, u8 step);
       u8 Active_Part; //selected Synthpart-Remote
       u16 loop_step_pos[8]; // straight step position bevore swing

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCard
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 typedef struct storage {   // to optimize SD-Load-Time, each clips data is stored in this struct
     
        u8      MSQ_Store[32][256];   // [Parts][CCs][Step>Value] 
        u8      Mod_Matrix[32][32];   // 8x32x32  For Synths witch built in Mod Matrix
        
        u8      Velo_Morph[32];
        u8      CC_Morph[32];       // not needet - you can used it for something other - (dont change the SIZE!)
        u8      CC_Store[32];         // [Parts][CCs]
        
        u8      Last;           // Last Step
        u8      loop_lenght_set; //>Loop Length - END        
        u8      Velo_Morph_Offset;    // Add Velocity to the Automated Parameters        
        u8      CC_Morph_Offset;
        u8      MSQ_Active;
        u8      MSQ_Rec;
        u8      MSQ_Rec_mem;    //to save and tomparary overide MSQ_REC
        u8      MSQ_Active_mem; //to save and tomparary overide MSQ_Active
        u8      MSQ_LastMoved;

        u16     bpm; 
        u8      rythm;          // 4x4=16, 5x3=15 usw... to calculate maximal duration per UI-matrix page
        u8      PAGE_Steps;     // calculate from 0 on....so 0-15 are 16 Steps that are visible with a 4/4Beat
        u16     MainLoop;       // max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)

} store_t;

 store_t beat[8];     // Data for  beat.clips
 store_t beat_cpy;


 // Struct for different flags
 typedef struct flags {     // to optimize Memory usage and data, i fill all 1bit flags into a struct
   unsigned PCLoad : 1;     // init 0   // flag.PCLoad      // ProgramChange via Midi received!
   unsigned PCSave : 1;     // init 0   // flag.PCSave      // Save Program on SD- from external Device
   unsigned NeedSync : 1;   // init 0   // flag.NeedSync    // Update Loop-Length and other Sequencer Variables
   unsigned FirstTic : 1;   // init 1   // flag.FirstTic    // Initalize Sequencer Sync and Init-Operations....
   unsigned Update_Remote: 1;   // init 0
   unsigned Update_Synth: 1;    // init 0
   unsigned SYX: 1;             // init 0
   unsigned one_gestic: 1;      // init 0  //ONE TIME OPERATION FLAG -- for not looped gestics
   unsigned Tact_Ex_Load: 1;        // init 0 // flag.Tact_Ex_Load  // when the external Sequencer can Transmit x/4 Rythm Data then overrule
   unsigned Update_Remote_Velo: 1;  // init 0 // flag.Update_Remote_Velo
   unsigned MSQ_Mute_Remote_timer: 1; // init 0 // in orer to un-mute the Remote
   u8 j10PinState[16];   
}flag_t;

 flag_t flag;

#endif /* _APP_H */
