//TM+SEQ 4 BLM=========================================================================//
//======TriggerMatrix V3  4 Button-LED-Matrix 16*16+X==================================//
//============2018 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."//
//non-commercial use only. All other rights reserved. Mios32 Based > www.ucapps.de=====//
//thx to: TK 4 MIOS, Latigid, Bruno,

#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <wchar.h> // to copy pattern-memory
#include <seq_bpm.h>
#include <blm_scalar.h>

void Router(u16 ID, u16 H, u16 V, s16 value);
    #define PRIORITY_Router                 ( tskIDLE_PRIORITY + 3 ) // 4: high   //303 is not a task!!! no effect?
void shift(u16 ID, u16 H, u16 V, s16 value);
void Note_Buffer(u8 track, u8 velocity,  u8 note);
    #define PRIORITY_MELODY_BUFFER 	         ( tskIDLE_PRIORITY + 2 ) // 3: Mios standart //303 is not a task!!! no effect?
void SD(u8 track, u16 clip, u16 job);
void SD_PORTER(u8 track, u16 clip, u16 job);

static void TASK_SEQ(void *pvParameters);
    #define PRIORITY_TASK_SEQ		        ( tskIDLE_PRIORITY + 4 ) // higher priority than MIDI receive task!
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 byte); // reroute midiclock to seq task


xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card

    
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// System Variables
/////////////////////////////////////////////////////////// Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B, 34=UART2=Midi-C, 35=UART3=Midi-D] //

    #define  Port_IN_Clock 34  // Midiclock + Program Change Input Port (Midiclock Slave)    
    #define  Port_OUT_Poly 34  // Midi-Port
    #define  Port_OUT_Mono 33  // Midi-Port
    #define  Port_OUT_Trig 32  // Midi-Port
    const u8 Port_THRU_Clock[4] = { 1,1,1,1 }; // Clockport > reroute to 4 Midi-Outs  //1: thru, 0: blocked
    #define  Port_IN_Poly 32	//MidiPort - Melody-Line-Input
    const u8 CH_IN_Melo[6] = {0, 1, 2, 3, 4, 5};
    
    #define  CH_IN_PC 15       // ProgramChange Input Channel                       16
    const u8 PCBank      [17]   = { 0, 1, 2, 3, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };   //Program-Change-Bank, Bank16 is for Trigger Channel!    
    const u8 CH_OUT_Melo [16]   = { 0, 1, 2, 3, 4,  5, 6, 7, 8, 9, 10,11,12,13,13,13 };   // Midi-Output-Channel Set...0-5 Poly-Melody, 6-11 MonoMelo, rest not used.
    const u8 CH_OUT_Trig [16]   = { 14,14,14,14,14, 14,14,14,14,14,14,14,14,14,14,15 };   // Output-Channel Set for OneNoteTriggers (parallel 2 Poly/Mono-Channels)
    const u8 TrigOutNote [16]   = { 48,49,50,51,52, 53,54,55,56,57,58,59,60,61,62,63 };   // Trigger-Out-Notes 
    const u8 PitchbendPWR[16]   = { 1, 1, 1, 1, 1,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  };   // only Activate Channels you really need! otherwhise midioutput is messed up...
    const u8 Port_THRU_CC[16]   = { 1, 1, 1, 1, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  };   // only activate channels you really need... its better to ADD CC-automations after this Device...
                                 // -----Poly-----  --------------Mono---------------
                                 // --------------------TRIGGER----------------------

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// ENCODER            SR begin with 1, ENC with 0)   //    setup the Pinout of Encoders
    const mios32_enc_config_t encoders[1] = {{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=7, .cfg.pos=0 }};

// FADERS  Analog Inputs
    u8  KILL_Melo        = 127;   // Kill Melody
    u8  DECAY_Melo       = 127;   // DECAY Melody
    u8  KILL_Mono        = 127;   // KILL Drum
    u8  KILL_Trig        = 127;   // KILL Trigger Channel
    s16 VELO_Offset      =  64;   // VEL DRUM  
    u8  ROLL_Variation   =   0;
    u8  ROLL_Variation_change = 127;
    u8  KILL_VELO        =  64;   // set the velocity range 4 the 3 velo-kill-switche
    u8  StepVelo         = 127;   // Velocity off the Currently Pressed Matrix Button 

// Buttons
    u8  PolyROLL = 1;
    u8  MonoROLL = 1;
    u8  TrigROLL = 1;


/////////////////////////////////////////////////////////////     
//// T R I G G E R  M A T R I X  ////  ////  ////  ////  ////

    u8  VeloKill[3] = {0,0,0}; //VeloKill Velocity Ranges //Kill low notes (velocity values from incoming drum-trigger) hi notes, & all between
    u8  VeloInvert = 0;        //Invert Velocity Value (lo get hi, and hi get low...)
    u8  vel[3] = {48, 64, 127}; // Range 4 the 3 VeloKill Switches
    u16 DECAY;   // only initial... later processed via CC

    u8 MATRIXcpy[16][16] ={{}};     // Copy Paste Matrix/Container 4 single Matrices
    u8 MATRIXcpyALL[16][16][16] = {{{}}};
    //  BLM-X: [x][0]: SongPartSelect,  [x][1]: Roll-Button
    u8 EXTRA[16][2]   = {{1,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1},
                         {0,1}};

    u8 MATRIX[16][16][16]={         // Trigger-Routing-LED-16x16-Matrix
        {{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Part0    // Routing Matrix 1:1 IO (sequencer0-15 = 0-15midiouts)
         {0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
         {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
         {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0}, 
         {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0},
         {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
         {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
         {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
         {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
         {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
         {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
         {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},
         {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
         {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
         {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
         {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1}},
    
        {},{},{}, {},{},{},{}, {},{},{},{}, {},{},{}, // Routing 1-14 --- blanked out
        //1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6
        {{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // 1 Part15    // Routing Matrix 1:1 IO (sequencer0-15 = 0-15midiouts)
         {0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0}, // 2
         {0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0}, // 3
         {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0}, // 4
         {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0}, // 5
         {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0}, // 6
         {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // 7
         {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0}, // 8
         {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0}, // 9
         {0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0}, // 0
         {0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0}, // 1
         {0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1}, // 2
         {1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0}, // 3
         {0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0}, // 4
         {1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0}, // 5
         {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1}} // 6
         };

    typedef struct triggermatrix {   // to optimize SD-Load-Time, each clips data is stored in this struct
     
        char    leader:1;           // Programchange able? - only 1 of 4 Song-Clips can send Programchanges via BLMatrix
        char    virgin:1;           // is there any data in the clip? need to display on a ButtonLed Matrix-Launcher
        char    seq_variation;
        u8      NoteBuff[16][8];    //
                 
    } triggermatrix_t;
    
    triggermatrix_t tm;     // Data for 8 Tracks    


//////////////////////////////////////////////////////////////
//// C O N T R O L   M O D E ////  ////  ////  ////  //// ////

    // Control Diverse Functions of the Programs...
    u8 CCMtx[16][16] = // BLM as Control-Switch-Board to Controll importend Performance Variables
    //1,2,3,4,5,  6,7,8,9,0,11,2,3,4,5,16  -- OutputChannelStrips
    {{1,0,0,0,0,  1,1,1,1,1,1,1, 1,1,1,1},   // Melody-IO-Matrix, MidiInCh 1
     {0,1,0,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, MidiInCh 2
     {0,0,1,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, MidiInCh 3
     {0,0,0,1,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, MidiInCh 4
     {0,0,0,0,1,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, MidiInCh 5
     {0,0,0,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, MidiInCh 6
     {0,0,0,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Melody-IO-Matrix, Mute MidiInChannels (Hold Note)
     {0,0,0,0,0,  0,1,1,1,1,1,1, 1,1,1,1},   // Pitch+1OCT
     {1,0,0,0,0,  0,0,0,0,0,1,0, 0,0,0,0},   // Pitch+1OCT
     {0,0,1,1,1,  0,0,0,0,0,0,0, 0,0,0,0},   // Pitch-1OCT
     {0,0,0,1,1,  0,0,0,0,0,0,0, 0,0,0,0},   // Pitch-1OCT
     {0,0,0,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // For Mono-Tracks: Lowest-HighestNote
     {0,1,1,1,1,  1,1,1,1,1,1,1, 1,1,1,1},   // Lowest/Highest Velocity
     {1,1,1,1,1,  1,0,1,1,1,1,1, 0,1,1,1},   // Kill-Effect, does the Kill-rotary has Effekt on Channel?
     {0,0,0,0,0,  0,0,0,0,0,0,0, 0,0,0,0},   // Solo Output
     {1,1,1,1,1,  1,1,1,1,1,1,1, 1,1,1,1}};   // Mute Output
    

    // Color Patterns for the CCMtx[][]
    const u8 COLOR[16][16]=
	{{4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //when toggling button states, u get State 0/1, 0 is OFF, and 1 is LED-ON RED..
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //want different colors? u have to interprete them via a MASK - tada! "COLOR" Mask
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //Here are the interpretation for every Cell saved.
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //COLOR val:  MATRIX val=0,  MATRIX val=1
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //     0         0 > OFF      1 > BLUE
	 {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2}, //     1         0 > OFF      2 > GREEN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     2         0 > OFF      3 > CYAN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     3         1 > BLUE     1 > BLUE 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     4         1 > BLUE     2 > GREEN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     5         1 > BLUE     3 > CYAN
     {6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1}, //     6         0 > OFF      0 > OFF
     {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},  
     {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},  
     {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},
	 {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};


    //  BLM-X:  Vari         X Y XInv YInv
    const u8 COLORex[16][4] = {{2,2,2,5},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,1},
                        {2,2,2,5},
                        {2,2,2,5},
                        {2,2,2,5}};



//////////////////////////////////////////////////////////////
//// L A U N C H P A D ////  ////  ////  ////  ////  //// ////
    u8 main_song = 0;
    u8 seq_song = 0;
    u8 melo_variation[4] =  {0,0,0,0};
    u8 melo_song[4] =       {0,0,0,0};
    u8 last_used_item = 0; // 0-3: melody0-3, 4:drums, 5:tm... used to copy paste clips
    s8 launch_page = 0;
  
//////////////////////////////////////////////////////////////
//// S E Q U E N C E R ////  ////  ////  ////  ////  //// ////
   s16 Fullvelo = 64;
   u8 seqMATRIXcopy[18][16]={{}}; //just a memory container to copy paste Sequencer beat.PAGEs
   u8 Seq_copy_all[18][256] = {{}}; // memory container to copy paste whole sequence
   u8 SeqTic[18][256]={{}};     // TicOffset for Seq[x][y]
   u8 SeqTicDelay[18]={};       // TicOffset for Seq calculated from SeqTic+Delays
   u8 SeqTicCopy[18][16] = {{}};// just a memory containter to copy paste Sequencer-Tic-beat.PAGEs

   
   u8 Seq[18][256]={ // Sequencer-INITAL-preset Pattern
    //  1   2   3   4   5   6   7   8    9  10  11  12  13  14  15  16, NEXT PAGE_actual....
     { 40, 30, 90, 70,127,  0,  0,  0, 127,  0,  0,  0,  0,  0,  0,  0, }, // 1
	 {  0,  0,  0,  0,127,  0,  0,  0,   0,  0,  0,  0,120,  0,  0,  0, }, // 2
	 {  0,  0,  0,  0,127,  0,  0,  0,   0,  0,  0,  0,127,  0,  0,  0, }, // 3     
	 { 60,  0, 60,  0, 60,  0, 60,  0,  60,  0, 60,  0, 60,  0, 60,  0, }, // 4
	 { 40, 10,127, 10, 40, 10,127, 10,  40, 10,127, 10, 40, 10,127, 10, }, // 5
	 {  0,  0,  0, 40,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0, }, // 6
	 {127,  0,  0,  0,  0,  0,  0,  0, 127,  0,  0,  0,  0,  0,  0,  0, }, // 7
	 { 10,  0,  0,  0,  0,  0,  0,  0, 127,  0,  0,  0,  0,  0,  0,  0, }, // 8
	 {  0,  0,  0,  0,127,  0,  0,  0,   0,  0,  0, 10,127,  0,  0,  0, }, // 9
	 {127, 115,  0, 0,  0,  0,  0, 60,  75, 60,  0,  0,  0, 50,  0, 40, }, // 10
	 {  0,  0,  65, 0,120,  0, 90,  0,   0,  0, 80,127,127,  0, 75,  0, }, // 11
	 {100,  0,  0,  0,127,  0,  0,  0, 100,  0,  0,  0,127,  0,  0,  0, }, // 12
     {127,  0,  0,  0,  0,  0,  0,  0, 127,  0,  0,  0,  0,  0,  0,  0, }, // 13
	 {127,  0,  0,  0,127,  0,  0,  0, 127,  0,127,  0,127,  0,127,127, }, // 14
	 {  0,  0,  0,  0,127,  0,  0,  0,   0,  0,  0,  0,127,  0,  0,  0, }, // 15
	 {  0,  0,  0, 32,  0,  0,  0,  0,   0,  0, 32,  0, 32,  0,  0,  0, }, // 16
     
	 {  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,}, // 0:SwingOFF 1:Swing ON16th, 2:SwingON8th (4wholeStep@AllTracks)
	 {  0,  0,  1,  0,  0,  0,  1,  0,   0,  0,  1,  0,  0,  0,  1,  0,  0,}};// Swing Ammount


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//// N O   S E T T I N G S  H E R E ! !    but global used
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    s8 MtxPartNr = 0;           // Which MtxPart is displayd on the BLM
    
    // Shift-Button  -  Modes
    u16 shiftcounter = 0;

    // Retrigger
    u8  MtxLoad[16][16]={{}};    // Represent actual loadet Trigger-Routing - it will decide which Input trigger goes to which output
    u8  AnySolo = 0;             // is any of the 16 Tracks Solo?
    u16 DECAY_Timer_Melo[16][128] ={{}};  // MidiDECAYCounter --- Note OFF Handling
    u16 DECAY_Timer_Trigger[16] = {};        // Monophonic - Drum - Note- Timer
    u8  MeloRandGate = 1;                // if that flag is 0 - no MeloTrigger will come thru....
    u8  MonoRandGate = 1;                // if that flag is 0 - no MonoMeloTrigger will come thru....
    u8  TrigRandGate = 1;                // if that flag is 0 - no DrumTrigger will come thru....

    u16 pitchbend[16] = {8192};         // inital No Pitchbend!
    
    u8 Roll_Random = 0;     // filled by random generator with 0 or 1        // 303
    u8 Roll_Load_MTX = 15;  // the actual Loadet Trigger-Matrix in Roll Mode // 303

    // SD Store-Load Variables   
    u16 SongNrLoad  = 0;			  
    u16 SongNrStor  = 0;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// 505
u16 portflag = 0; //505

void APP_Init(void){
   
  BLM_SCALAR_Init(0);   // initialize BLM_SCALAR driver

// Set GPIO @ J10A
  int pin;
  for(pin=0; pin<16; ++pin){
    MIOS32_BOARD_J10_PinInit(pin, MIOS32_BOARD_PIN_MODE_INPUT_PU);}

// Get GPIO States
    VeloKill[0] = MIOS32_BOARD_J10_PinGet(2); 
    VeloKill[1] = MIOS32_BOARD_J10_PinGet(5); 
    VeloKill[2] = MIOS32_BOARD_J10_PinGet(4); 

// Set Menue Encoder
  int enc;
  for(enc=0; enc<4; ++enc) {
    mios32_enc_config_t enc_config = MIOS32_ENC_ConfigGet(enc);
    enc_config.cfg.type = DETENTED3; // see mios32_enc.h for available types
    enc_config.cfg.sr = 0; // must be 0 if controlled from application
    enc_config.cfg.pos = 0; // doesn't matter if controlled from application
    enc_config.cfg.speed = FAST;
    enc_config.cfg.speed_par = 0;
    MIOS32_ENC_ConfigSet(enc, enc_config);}
    
/////////////////////////////////////////////////////////////////////////
        // Initate Flags
        flag.SRIO_Update = 0;
        flag.MenueUpdate = 0;
        flag.Store       = 0;
        flag.Load        = 0;
        flag.Boot        = 1;
        flag.PCLoad      = 0;
        flag.Beat        = 0;
        flag.NeedSync    = 0;   // to indicate that PAGE length has changed
        flag.LoadSYS     = 1;
        flag.LoadSong    = 1;
        flag.shift       = 0;
        flag.shiftvalue  = 1;
        flag.ShiftPressed= 0;
        flag.FirstTic    = 1;
        flag.Update_LCD_s= 0;    // normal LCD-Labeling back again in 2seconds
 memset(flag.j10PinState, 0, 16 * sizeof(flag.j10PinState[0]));    // Set all cells to 0's


    // Init Beat-Loop
    beat.rythm           = 4;    // 4x4=16, 5x3=15 usw... to calculate maximal duration per matrix page
    beat.PAGE_loop[0]    = 0;    // Loop START PAGE_actual
    beat.PAGE_loop[1]    = 0;    // Loop END PAGE_actual
    beat.PAGE_actual     = 0;    // Step beat.PAGE_actual, in 4/4 Mode one beat.PAGE_actual has 16 Step     
    beat.PAGE_Steps     = 16;    // calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat  
    beat.direction       = 1;    // 0: <, 1>, 2<>   SEQUENCER STEP-COUNTER-DIRECTION       
    beat.MainLoop       = 32;    // max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)
    beat.SWING_32th      = 0;    // swing on Steps, which are marked as 16th
    beat.SWING_16th      = 0;    // swing on Steps, which are marked as 8th
    beat.SWING_Switch    = 0;    // Activate Swing-Step-Settings and Rotarys
    beat.bpm           = 100;
   
    DECAY = ( (60000/beat.bpm)/8 ) / (DECAY_Melo / 4);  // 32th length   

    // Init TM-Struct
    tm.seq_variation = 0; // one of 4 Variations are played last time, the prefered beat ( need for programchange loading!)
    int track; for(track=0; track<16; ++track){
    int note;  for(note =1; note <8;  ++note) {
             tm.NoteBuff[track][note]= 0;  // clear all Notes, empty buffer
             tm.NoteBuff[track][0]   = 60;}} // at least one note in Buffer...
    

     
// Init TriggerMatrix UI
MatrixUse = 4; //switch to CC PAGE_actual

 Router(2, 0, 0, 0); // switch to Routing 0   // elementID, btnX, btnY, value   --2 = Y-BTNs

  MIOS32_BOARD_LED_Init(0xffffffff);   // initialize all LEDs


	xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex();		// create semaphores
	FILE_Init(0);												// initialize file functions



  // SEQUENCER TASKS
  SEQ_Init(0);   // initialize sequencer
  MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);
  xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task 

  


 // Fill Routing Matrixex
int h = 0;
int v = 0;
int route = 1;

for(route = 1; route < 15; route++) { // leave out Matrix 16 - because it is already init 
for( h = 0; h < 16; h++)            {
for( v = 0; v < 16; v++)            {

MATRIX[route][h][v]= MATRIX[0][h][v]; //Matrix 0 already filled above
}}}
}

void DIN_BLM_NotifyToggle(u32 pin, u32 pin_value){

            // determine row and column (depends on the way how the matrix has been connected)
            u8 blm_row = pin >> 3;
            u8 blm_column = pin & 7;
            
            u8 h = (blm_row >> 1);
            u8 v = blm_column | ((blm_row&1) << 3);
            u8 val = pin_value; //? 0x00 : 0x7f;
            
            u8 extra_h = 0;
            u8 extra_v = 0;      
            
            // 16x16 Matrix
            if       ( h < 16 )     {   if( flag.shiftvalue == 0 ) {  shift( 0, h, v, val );  }   // shift  use
                                        if( flag.shiftvalue == 1 ) { Router( 0, h, v, val );  } } // normal use
            // SHIFT
            else if ( h == 16 && v == 12)  {   flag.shiftvalue = val;   // SHIFT calculate elswhere what to do with
                                                if( val == 0 ) { flag.shift   = 1;
                                                                 shiftcounter = 0; } }


            // VERTIKAL - EXTRA
            else if( (blm_row & 0xf9) == 0x20 && blm_column < 4 )
                    {   extra_h = ((blm_row >> 1) & 3) | (blm_column << 2);
                                                
                        if( flag.shiftvalue == 0 ) {  shift(2, extra_h, 0, val);  }   // shift  use
                        if( flag.shiftvalue == 1 ) { Router(2, extra_h, 0, val);  } } // normal use

            // HORIZONTAL - EXTRA
            else if( (blm_row & 0xf9) == 0x21 )
                    {   extra_v = ((blm_row << 1) & 0x0c) | (blm_column & 0x3);

                          //Router(1, 0, extra_v, val}
                                                
                        if( flag.shiftvalue == 0 ) {  shift(1, 0, extra_v, val);  }   // shift  use
                        if( flag.shiftvalue == 1 ) { Router(1, 0, extra_v, val);  }
}
//      MIOS32_MIDI_SendDebugMessage("pin: %d: value: %d", pin, pin_value);
//      MIOS32_MIDI_SendDebugMessage("h: %d: v: %d val: %d", h, v, val); 
//      MIOS32_MIDI_SendDebugMessage("extra_v: %d: extra_h: %d", extra_v, extra_h);
}

 
void APP_Background(void){
//MIOS32_MIDI_SendDebugMessage("char: %d: u16 %d:", sizeof Port_IN_Clock, sizeof Port_OUT_Poly);

///////////////////////////////////////////////////////////////////////////7    
    // BLM-Shift - Button release - time
    if(flag.shiftvalue == 0
    && flag.shift == 1) { 
            shiftcounter++; 
            if(shiftcounter == 650) {
                                    Router(3, 0, 0, flag.shiftvalue);
                                    shift (3, 0, 0, flag.shiftvalue);
                                    //MIOS32_MIDI_SendDebugMessage("long-pressed: %d: shiftvalue %d:", shiftcounter, flag.shiftvalue);
                                    } }  // normal Sub-Shift operations

    if(flag.shiftvalue >= 1
    && flag.shift      == 1                       
    && shiftcounter   > 650)        {
                                    flag.shift     = 0;
                                    Router(3, 0, 0, 1);
                                    shift (3, 0, 0, 1);
                                    //MIOS32_MIDI_SendDebugMessage("long-released: %d: shiftvalue %d:", shiftcounter, flag.shiftvalue);
                                    shiftcounter = 0;
                                    }  // normal Sub-Shift operations                                
                                    
    
    if(flag.shiftvalue == 1 
    && shiftcounter < 650 
    && flag.shift == 1) {
                                    flag.shift      = 0;
                                    //flag.shiftvalue = 1;
                                    static u8  shift_menue_cycle = 0;
                                    shift_menue_cycle = shift_menue_cycle+1;
                                    if(shift_menue_cycle  > 5) { shift_menue_cycle = 0; }
                                    if(shift_menue_cycle == 0) { MatrixUse = 0; Router(5, 0, 0, 0); } // update Matrix - Dump Out
                                    if(shift_menue_cycle == 1) { MatrixUse = 1; Router(5, 1, 0, 0); } // update Matrix - Dump Out
                                    if(shift_menue_cycle == 2) { MatrixUse = 2; Router(5, 2, 0, 0); } // update Matrix - Dump Out
                                    if(shift_menue_cycle == 3) { MatrixUse = 3; Router(5, 3, 0, 0); } // update Matrix - Dump Out
                                    if(shift_menue_cycle == 4) { MatrixUse = 4; Router(5, 4, 0, 0); } // update Matrix - Dump Out
                                    if(shift_menue_cycle == 5) { MatrixUse = 5; Router(5, 5, 0, 0); } // update Matrix - Dump Out                                    
                                    // MIOS32_MIDI_SendDebugMessage("shortcycle: %d: counter: %d", shift_menue_cycle, shiftcounter); 
                                    shiftcounter    = 0;
                                    }  
////////////////////////////////////////////////////////////////////77

       
        
    // DECAY - POLY -  Send Note OFFs after a while
    static u8 DcyNteCount = 0;   // count thru all clips // 303
    for(DcyNteCount = 0;  DcyNteCount < 128; DcyNteCount++) {
                        static u8 DcyTrkCount = 0;  // count thru all tracks
                        for(DcyTrkCount = 0; DcyTrkCount < 16;   DcyTrkCount++) {
                            
                                   if   (DECAY_Timer_Melo[DcyTrkCount][DcyNteCount] != 0) {
                                         DECAY_Timer_Melo[DcyTrkCount][DcyNteCount]   --;
                                         
                                      if (DECAY_Timer_Melo[DcyTrkCount][DcyNteCount] == 0) {
                                           MIOS32_MIDI_SendNoteOff(Port_OUT_Poly, DcyTrkCount, DcyNteCount, 0); // Port, Chn, Note, Velocity 
                                           MIOS32_MIDI_SendNoteOn (Port_OUT_Poly, DcyTrkCount, DcyNteCount, 0); } } } }
            
    
    // DECAY - Drum-Trigger -  Send Note OFFs after a while
     for(DcyNteCount = 0;  DcyNteCount < 16; DcyNteCount++) {
                            
           if   (DECAY_Timer_Trigger[DcyNteCount] != 0) {
                 DECAY_Timer_Trigger[DcyNteCount]   --;
                 
                if (DECAY_Timer_Trigger[DcyNteCount] == 0) {
                    // Trigger Note OFF
                    MIOS32_MIDI_SendNoteOff(Port_OUT_Trig, CH_OUT_Trig[DcyNteCount], TrigOutNote[DcyNteCount], 0);    // Port, Chn, Note, Velocity 
                    MIOS32_MIDI_SendNoteOn (Port_OUT_Trig, CH_OUT_Trig[DcyNteCount], TrigOutNote[DcyNteCount], 0); } } }


///////////////////////////////////////////////////////////////////////////77
// RANDOM - Generators
    static u16 random_seed_l =   0;     // depend on the CController and its range
    static u16 random_seed_h = 127;     // depens on the CController and its range...
    static u16 random_tmp    =  64;				
    static u16 random_nr     = 127;     // depends on the Controller and its range...
    static u16 TMR0L         =   0;     // TMR0L = Timer - Random -Roll Variable

        
    // MELO  -  KILL NOTE GATE
    for(TMR0L=0; TMR0L<127; TMR0L++){random_tmp=random_tmp+1;} //Random-Value 4 RandomKill 
    random_tmp = random_seed_l * random_seed_h;
    random_seed_l = TMR0L + (random_tmp & 0xff); //TMR0L = Timer
    random_seed_h = 0x69 + (random_tmp >> 8);
    random_nr = random_tmp % 127; //>> 2;       // divide by 2 > bitshifting - thx2"kpete" VARIANT
    
    if(KILL_Melo  > random_nr) {MeloRandGate = 1;} //Pass Notes   /KILL_Melo  = MKill - Melody-Trigger-Kill
    if(KILL_Melo  < random_nr) {MeloRandGate = 0;} //Kill Notes   /KILL_Melo  = MKill - Melody-Trigger-Kill

    
    // MONO  -  KILL NOTE GATE
    for(TMR0L=0; TMR0L<127; TMR0L++){random_tmp=random_tmp+1;} //Random-Value 4 RandomKill 
    random_tmp = random_seed_l * random_seed_h;
    random_seed_l = TMR0L + (random_tmp & 0xff); //TMR0L = Timer
    random_seed_h = 0x69 + (random_tmp >> 8);
    random_nr = random_tmp % 127; 
    
    if(KILL_Mono  > random_nr) {MonoRandGate = 1; TrigRandGate = 1;} //Pass Notes   /KILL_Mono = DKill - Drum-Trigger-Kill
    if(KILL_Mono  < random_nr) {MonoRandGate = 0; TrigRandGate = 0;} //Kill Notes   /KILL_Mono = DKill - DRUM-Trigger-Kill

    
    // TRIGGER  -  KILL NOTE GATE
    for(TMR0L=0; TMR0L<127; TMR0L++){random_tmp=random_tmp+1;} //Random-Value 4 RandomKill 
    random_tmp = random_seed_l * random_seed_h;
    random_seed_l = TMR0L + (random_tmp & 0xff); //TMR0L = Timer
    random_seed_h = 0x69 + (random_tmp >> 8);
    random_nr = random_tmp % 127; 

    if(KILL_Trig  > random_nr) {TrigRandGate = 1;} //Pass Notes
    if(KILL_Trig  < random_nr) {TrigRandGate = 0;} //Kill Notes


    // ROLL  -  VARIATIONS
    for(TMR0L=0; TMR0L<127; TMR0L++){random_tmp=random_tmp+1;} //Random-Value 4 RandomKill 
    random_tmp = random_seed_l * random_seed_h;
    random_seed_l = TMR0L + (random_tmp & 0xff); //TMR0L = Timer
    random_seed_h = 0x69 + (random_tmp >> 8);
    random_nr = random_tmp % 16; 

    if(ROLL_Variation_change   < random_nr) {Roll_Random = 0;} // 0-16 steps between 2 variations,
    else                                    {Roll_Random = 1;}
    
    Roll_Load_MTX = 8 + ROLL_Variation + Roll_Random; // +8 because by Routing-Matrix8 we beging with roll Routings!
    if(Roll_Load_MTX > 15) { Roll_Load_MTX = 15;} // clip to max 15 (since Random add +1)

// L O A D   R O U T I N G  M A T R I C E S // ROLL    /////////////////////////////////////////////////////////// 
    static u8 changed = 0;
    static u8 polychanged = 0;
    static u8 monochanged = 0;
    static u8 trigchanged = 0;
    static u8 seq;
    
    if(Roll_Load_MTX != changed  ||  PolyROLL != polychanged) { // Roll MTX has randomly changed
                    polychanged = PolyROLL;
                    for( seq=0; seq<16; seq++ ) {
                    if( PolyROLL == 0 )     {   MtxLoad[seq][0]=MATRIX[Roll_Load_MTX][seq][0];
                                                MtxLoad[seq][1]=MATRIX[Roll_Load_MTX][seq][1];
                                                MtxLoad[seq][2]=MATRIX[Roll_Load_MTX][seq][2];
                                                MtxLoad[seq][3]=MATRIX[Roll_Load_MTX][seq][3];
                                                MtxLoad[seq][4]=MATRIX[Roll_Load_MTX][seq][4];}        // Overwrite temporar Roll  
                                                            
                    else                    {   MtxLoad[seq][0]=MATRIX[MtxPartNr][seq][0];
                                                MtxLoad[seq][1]=MATRIX[MtxPartNr][seq][1];
                                                MtxLoad[seq][2]=MATRIX[MtxPartNr][seq][2];
                                                MtxLoad[seq][3]=MATRIX[MtxPartNr][seq][3];
                                                MtxLoad[seq][4]=MATRIX[MtxPartNr][seq][4];}}} // Change to orginal Routing
    
    if(Roll_Load_MTX != changed  ||  MonoROLL != monochanged) { // Roll MTX has randomly changed
                    monochanged = MonoROLL;
                    for( seq=0; seq<16; seq++ ) {
                    if( MonoROLL == 0 )     {   MtxLoad[seq][5]  = MATRIX[Roll_Load_MTX][seq][5];
                                                MtxLoad[seq][6]  = MATRIX[Roll_Load_MTX][seq][6];
                                                MtxLoad[seq][7]  = MATRIX[Roll_Load_MTX][seq][7];
                                                MtxLoad[seq][8]  = MATRIX[Roll_Load_MTX][seq][8];
                                                MtxLoad[seq][9]  = MATRIX[Roll_Load_MTX][seq][9];
                                                MtxLoad[seq][10] = MATRIX[Roll_Load_MTX][seq][10];
                                                MtxLoad[seq][11] = MATRIX[Roll_Load_MTX][seq][11]; }  // Overwrite temporar Roll  
                                                            
                    else                    {   MtxLoad[seq][5]  = MATRIX[MtxPartNr][seq][5];
                                                MtxLoad[seq][6]  = MATRIX[MtxPartNr][seq][6];
                                                MtxLoad[seq][7]  = MATRIX[MtxPartNr][seq][7];
                                                MtxLoad[seq][8]  = MATRIX[MtxPartNr][seq][8];
                                                MtxLoad[seq][9]  = MATRIX[MtxPartNr][seq][9];
                                                MtxLoad[seq][10] = MATRIX[MtxPartNr][seq][10];
                                                MtxLoad[seq][11] = MATRIX[MtxPartNr][seq][11];}}} // Change to orginal Routing

    if(Roll_Load_MTX != changed  ||  TrigROLL != trigchanged) { // Roll MTX has randomly changed
                    trigchanged = TrigROLL;
                    for( seq=0; seq<16; seq++ ) {
                    if( TrigROLL == 0 )     {   MtxLoad[seq][12]=MATRIX[Roll_Load_MTX][seq][12];
                                                MtxLoad[seq][13]=MATRIX[Roll_Load_MTX][seq][13];
                                                MtxLoad[seq][14]=MATRIX[Roll_Load_MTX][seq][14];
                                                MtxLoad[seq][15]=MATRIX[Roll_Load_MTX][seq][15]; }  // Overwrite temporar Roll  
                                                            
                    else                    {   MtxLoad[seq][12]=MATRIX[MtxPartNr][seq][12];
                                                MtxLoad[seq][13]=MATRIX[MtxPartNr][seq][13];
                                                MtxLoad[seq][14]=MATRIX[MtxPartNr][seq][14];
                                                MtxLoad[seq][15]=MATRIX[MtxPartNr][seq][15];}}} // Change to orginal Routing
    // Toggle State
    changed = Roll_Load_MTX;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////7

    
    static u16 SDCardCount = 0;
    SDCardCount++; // 2s Counter > send Check-SDCard-Commant to StoreLoad-Function (track, clip, job)
    if (SDCardCount > 2000) { SDCardCount = 0; SD(0, 0, 3); }                         


    //Programchange Load when Stopped turning the Wheel (from External Source, internal we use a LOAD-Button for that)
    if( flag.PCLoad == 1 )  {
            static u16 PCLoadCount = 0; // 303
            PCLoadCount++; 
            if( PCLoadCount > 300 ) {   PCLoadCount       = 0;        // init counter for the next run
                                        flag.PCLoad       = 0;        // Kill Flag to avoid double triggering events
                                        tm.seq_variation  = SongNrLoad;
                                        seq_song          = SongNrLoad; 
                                        main_song         = SongNrLoad;
                                        melo_song[0]      = SongNrLoad;
                                        melo_song[1]      = SongNrLoad;
                                        melo_song[2]      = SongNrLoad;
                                        melo_song[3]      = SongNrLoad;
                                        melo_variation[0] = 0;
                                        melo_variation[1] = 0;
                                        melo_variation[2] = 0;
                                        melo_variation[3] = 0;
                                        SD(4, SongNrLoad, 1);                   // LOAD
                                        SD(tm.seq_variation, SongNrLoad, 1); }} // LOAD
                                                                                
    if (flag.Update_LCD_s == 1)   {
            static u16 Upd_LCD_count = 0;
            Upd_LCD_count++;
            if( Upd_LCD_count >= 2100 ) {   Upd_LCD_count = 0;
                                            flag.Update_LCD_s  = 0;
                                            Router(5, 0, 0, 0); }  }

    if (portflag == 1)   { // 505 LOAD MATRIXES FROM CARD
            static u16 portflag_count = 0;
            portflag_count++;
            if( portflag_count >= 2100 ) {   portflag_count = 0;
                                            portflag  = 0;
                                            SD_PORTER(0,0,1);} } // 505 LOAD MATRIXES FROM CARD



    // check for BLM pin changes, call DIN_BLM_NotifyToggle on each toggled pin
    BLM_SCALAR_ButtonHandler(DIN_BLM_NotifyToggle);                                            
        
}


void Router(u16 ID, u16 H, u16 V, s16 value){ //BLM -"MENUE"
    static u8 LoopSetCount = 0;
    static u8 btn = 0;
    static u8 focusMatrixUse[5] = {}; //focus tracks to copy paste them individual
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SEQUENCER MODE -- STEP Set
if(MatrixUse == 0){

                            // MIOS32_MIDI_SendDebugMessage("beat.PAGE_actual: %d beat.PAGE_Steps: %d", beat.PAGE_actual, beat.PAGE_Steps, V, H, value); 
                            // MIOS32_MIDI_SendDebugMessage("V: %d H: %d value: %d ", V, H, value); 
              
            if(ID == 0 && value == 0){ // 16x16 - SET Step-Velocitys         // value = 0 mean button is pressed!
                    // check if the pressed button correspond with a Step that is switched off, then overwrite with a given Velocity
                    if(V < beat.PAGE_Steps) { // deactivate Programming the next page...
                    if(Seq[H][V+(beat.PAGE_actual*(beat.PAGE_Steps))] >= 1)  {Seq[H][V+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0;}
                                                else    { Seq[H][V+(beat.PAGE_actual*(beat.PAGE_Steps))] = Fullvelo; }}} //write Velocity into Matrix
            // focus Track
            if( ID == 2)  { focusMatrixUse[0] = H; }
            if((ID == 2) || (ID == 5 && V == 0)) {             // Dump Out Focus LED to BLM
                    int y; for(y=0; y<16; y++) { BLM_LED(2, 0, y, 0);}                  // clear all extra-y LEDs      // (element, x, y, color);
                                                 BLM_LED(2, 0, focusMatrixUse[0], 3); } // set the Focused-Track-LED  


            if(ID == 7) { // Menue-Encoder --- switch Pages
                    beat.PAGE_actual = beat.PAGE_actual + value;
                    if(beat.PAGE_actual <  0)  { beat.PAGE_actual = 15; }
                    if(beat.PAGE_actual > 15)  { beat.PAGE_actual =  0; }
                    
                    int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}        // deactivate LED Horizontal Extra Buttons
                    BLM_LED(1, beat.PAGE_loop[0],  0, 1);   // activate LED   Loop-Start    
                    BLM_LED(1, beat.PAGE_loop[1],  0, 1);   // activate LED   Loop-END
                    BLM_LED(1, beat.PAGE_actual,   0, 3);   // activate LED   Currently Editet Page
            }

                                                                                   
        // Set Loop Length
        if(ID == 1){ // Horizontal-Buttons
                if(value ==0 && LoopSetCount ==1) { if(V < btn) {beat.PAGE_loop[0] = V;     beat.PAGE_loop[1] = V;}
                                                    if(V > btn) {beat.PAGE_loop[0] = btn;   beat.PAGE_loop[1] = V;}} 
                                                    // 2.while holding 1. pressing 2. set Loop Point
                                                    
                if(value == 0 && LoopSetCount ==0) { LoopSetCount = LoopSetCount+1;     // 1. Show selected beat.PAGE_actual on BLM, set a memory Start beat.PAGE_actual "btn"
                                                     beat.PAGE_actual = V; btn = V;}	// show selected beat.PAGE_actual on the BLM, memory V for 2.
                                                     
                if(value == 1) { LoopSetCount  = 0;   // Clear Counter - its all done
                                 flag.NeedSync = 1;}      // see "seq.c." Call beat.bpm counter that something has to be change
                                
                  //turn off All Buttons
                int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}        // SET Loop Point: press and hold first btn, press 2nd BTN, release booth.
                BLM_LED(1, beat.PAGE_loop[0], 0, 1);   // PAGE_actual Start              // is 2nd BTN greater then 1st.BTN, then LoopEndPoint will be 2ndBTN,
                BLM_LED(1, beat.PAGE_loop[1],  0, 1); } // PAGE_actual END                // is 2nd BTN smaller then 1st.BTN then you loop only the 1stbeat.PAGE_actual.
                                        
    
    // STEP-LIGHT // X...X...X...X...X...X...X...O...X... 
    if(ID == 6) {
        int step = V; //rename V to step...to easyer understanding
        
        //turn off All Buttons
        int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}
        

                //Turn on beat.PAGE_actual-Start & beat.PAGE_loop[1] >> Loop Cycle
                BLM_LED(1, beat.PAGE_loop[0], 0, 1);
                BLM_LED(1, beat.PAGE_loop[1],  0, 1);        
                if(step >= 0             && step <  beat.PAGE_Steps)    {   BLM_LED(1, step, 0, 3); //Set Step LED
                                                                        BLM_LED(1, 0,    0, 2); //PAGE_actual Indicator
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);} //Viewed beat.PAGE_actual                                                                   
                if(step > beat.PAGE_Steps    && step <  beat.PAGE_Steps*2)  {   BLM_LED(1, (step-beat.PAGE_Steps),    0, 3); 
                                                                        BLM_LED(1, 1,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*2  && step <= beat.PAGE_Steps*3)  {   BLM_LED(1, ((step-beat.PAGE_Steps*2)-1),  0, 3); 
                                                                        BLM_LED(1, 2,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*3  && step <= beat.PAGE_Steps*4)  {   BLM_LED(1, (step-(beat.PAGE_Steps*3)-1),  0, 3); 
                                                                        BLM_LED(1, 3,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}   
                if(step > beat.PAGE_Steps*4  && step <= beat.PAGE_Steps*5)  {   BLM_LED(1, (step-(beat.PAGE_Steps*4)-1),  0, 3); 
                                                                        BLM_LED(1, 4,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*5  && step <= beat.PAGE_Steps*6)  {   BLM_LED(1, (step-(beat.PAGE_Steps*5)-1),  0, 3); 
                                                                        BLM_LED(1, 5,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*6  && step <= beat.PAGE_Steps*7)  {   BLM_LED(1, (step-(beat.PAGE_Steps*6)-1),  0, 3); 
                                                                        BLM_LED(1, 6,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}   
                if(step > beat.PAGE_Steps*7  && step <= beat.PAGE_Steps*8)  {   BLM_LED(1, (step-(beat.PAGE_Steps*7)-1),  0, 3); 
                                                                        BLM_LED(1, 7,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*8  && step <= beat.PAGE_Steps*9)  {   BLM_LED(1, (step-(beat.PAGE_Steps*8)-1),  0, 3); 
                                                                        BLM_LED(1, 8,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}   
                if(step > beat.PAGE_Steps*9  && step <= beat.PAGE_Steps*10) {   BLM_LED(1, (step-(beat.PAGE_Steps*9)-1),  0, 3); 
                                                                        BLM_LED(1, 9,    0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*10 && step <= beat.PAGE_Steps*11) {   BLM_LED(1, (step-(beat.PAGE_Steps*10)-1), 0, 3); 
                                                                        BLM_LED(1, 10,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*11 && step <  beat.PAGE_Steps*12) {   BLM_LED(1, (step-(beat.PAGE_Steps*11)-1), 0, 3); 
                                                                        BLM_LED(1, 11,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*12 && step <= beat.PAGE_Steps*13) {   BLM_LED(1, (step-(beat.PAGE_Steps*12)-1), 0, 3); 
                                                                        BLM_LED(1, 12,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*13 && step <= beat.PAGE_Steps*14) {   BLM_LED(1, (step-(beat.PAGE_Steps*13)-1), 0, 3); 
                                                                        BLM_LED(1, 13,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*14 && step <= beat.PAGE_Steps*15) {   BLM_LED(1, (step-(beat.PAGE_Steps*14)-1), 0, 3); 
                                                                        BLM_LED(1, 14,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}  
                if(step > beat.PAGE_Steps*15 && step <= beat.PAGE_Steps*16) {   BLM_LED(1, (step-(beat.PAGE_Steps*15)-1), 0, 3); 
                                                                        BLM_LED(1, 15,   0, 2); 
                                                                        BLM_LED(1, beat.PAGE_actual, 0, 3);}
                }                              


    // Load STEP-Matrix in to BLM-LED-Matrix                                
  if((ID == 0 && value == 0) || (ID == 5 && V == 0));{

    //Set Color      //B ut before we have to change the Color Pattern...
    int y; 
    int x;                      
    for(y=0; y<16; y++)    {
     for(x=0; x<beat.PAGE_Steps; x++)    {                                  
      if( Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] ==  0) { BLM_LED( 0, x, y, 0);}   //(blm, element, x, y, off);
      if( Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] >   0
       && Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] <= 44) { BLM_LED( 0, x, y, 1);}   //(blm, element, x, y, blue);
      if( Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] >= 45
       && Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] <= 89) { BLM_LED( 0, x, y, 2);}   //(blm, element, x, y, green);
      if( Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] >= 90) { BLM_LED( 0, x, y, 3);}}} //(blm, element, x, y, cyan);

    //Blank out unused LEDs (when not using all 16...)
    if(beat.PAGE_Steps != 16) {
    y=0; x=0;   
    int s = 16 - beat.PAGE_Steps;
    for(y=0; y<16; y++)    {
     for(x=0; x<s; x++)    { if(x < 16) {BLM_LED( 0, x+beat.PAGE_Steps, y, 1);}}}}   //(blm, element, x, y, blue);
}} // END SEQUENCER MODE

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SEQUENCER MODE -- SET TIC OFFSET
if(MatrixUse == 1){
    static s16 SeqFocusStep = 0;    // the focused Step from Stepsequencer

           
            if(ID == 7) { // Menue-Encoder --- switch Pages
                    beat.PAGE_actual = beat.PAGE_actual + value;
                    if(beat.PAGE_actual <  0)  { beat.PAGE_actual = 15; }
                    if(beat.PAGE_actual > 15)  { beat.PAGE_actual =  0; }
                    
                    int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}        // deactivate LED Horizontal Extra Buttons
                    V = 0; // set focused step
                    SeqFocusStep = V + (beat.PAGE_actual*beat.PAGE_Steps); 
                    BLM_LED(1, V,  0, 2);   // activate LED   Focus 16th Step 
                    BLM_LED(1, beat.PAGE_actual,   0, 3);}  // activate LED   Currently Editet Page

        // Focus 16th Step
        if(ID == 1 && value == 0) { // Horizontal-Buttons
                SeqFocusStep = V + (beat.PAGE_actual*beat.PAGE_Steps);           // Focused Step = X-Button + beat.PAGE_actual-Offset e.g:. 18 = 2 + (1*16)
                //Clear BLM X-Buttons
                int x;  for(x=0; x<16; x++)  {BLM_LED(1, x, 0, 0);}     // +0Tics = No Delay = no Offset
                //Set Focus-LED on BLM
                BLM_LED(1, V, 0, 2);}

        
        //Set TIC-Offset for Each Track & Step -  16x16 Matrix
        if(ID == 0 && value == 0) { SeqTic[H][SeqFocusStep] = V * 2; } // TicOffset = 6*(384/64=6) = 36tics (when V =6)
        
        //Clear BLM
        int y;  for(y=0; y<16; y++)  {
        int x;  for(x=0; x<16; x++)  { BLM_LED(0, x, y, 0); } }
        
        //focus Track
        if( ID == 2)  { focusMatrixUse[0] = H; }
        if((ID == 2) || (ID == 5 && V == 0) || (ID == 7) ) {   // Dump Out Focus LED to BLM .... ID 5: external DumpOutCall
                int y; for(y=0; y<16; y++)   { BLM_LED(2, 0, y, 0); }   // clear all extry-y LEDs      //(blm, element, x, y, color);
                                               BLM_LED(2, 0, focusMatrixUse[0], 3); }  // set the Focused-Track-LED  


    
    // STEP-LIGHT // X...X...X...X...X...X...X...O...X... 
    if(ID == 6) {
        int step = V; //rename V to step...to easyer understanding
        
        //turn off All Buttons
        int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}
        
                // Turn on Focused Step
                BLM_LED(1,  (SeqFocusStep-(16*beat.PAGE_actual)), 0, 1);
                //Set Step-Seqeuncer Running LED
                if( step >= 0              &&  step < beat.PAGE_Steps   )  { BLM_LED(1, step, 0, 3); } //Set Step LED 
                if( step > beat.PAGE_Steps     &&  step < beat.PAGE_Steps*2 )  { BLM_LED(1, (step-beat.PAGE_Steps),0, 3); }  
                if( step > beat.PAGE_Steps*2   &&  step < beat.PAGE_Steps*3 )  { BLM_LED(1, (step-beat.PAGE_Steps*2),  0, 3); }  
                if( step > beat.PAGE_Steps*3   &&  step < beat.PAGE_Steps*4 )  { BLM_LED(1, (step-beat.PAGE_Steps*3),  0, 3); }   
                if( step > beat.PAGE_Steps*4   &&  step < beat.PAGE_Steps*5 )  { BLM_LED(1, (step-beat.PAGE_Steps*4),  0, 3); }  
                if( step > beat.PAGE_Steps*5   &&  step < beat.PAGE_Steps*6 )  { BLM_LED(1, (step-beat.PAGE_Steps*5),  0, 3); }  
                if( step > beat.PAGE_Steps*6   &&  step < beat.PAGE_Steps*7 )  { BLM_LED(1, (step-beat.PAGE_Steps*6),  0, 3); }   
                if( step > beat.PAGE_Steps*7   &&  step < beat.PAGE_Steps*8 )  { BLM_LED(1, (step-beat.PAGE_Steps*7),  0, 3); }  
                if( step > beat.PAGE_Steps*8   &&  step < beat.PAGE_Steps*9 )  { BLM_LED(1, (step-beat.PAGE_Steps*8),  0, 3); }   
                if( step > beat.PAGE_Steps*9   &&  step < beat.PAGE_Steps*10)  { BLM_LED(1, (step-beat.PAGE_Steps*9),  0, 3); }  
                if( step > beat.PAGE_Steps*10  &&  step < beat.PAGE_Steps*11)  { BLM_LED(1, (step-beat.PAGE_Steps*10), 0, 3); }  
                if( step > beat.PAGE_Steps*11  &&  step < beat.PAGE_Steps*12)  { BLM_LED(1, (step-beat.PAGE_Steps*11), 0, 3); }  
                if( step > beat.PAGE_Steps*12  &&  step < beat.PAGE_Steps*13)  { BLM_LED(1, (step-beat.PAGE_Steps*12), 0, 3); }  
                if( step > beat.PAGE_Steps*13  &&  step < beat.PAGE_Steps*14)  { BLM_LED(1, (step-beat.PAGE_Steps*13), 0, 3); }  
                if( step > beat.PAGE_Steps*14  &&  step < beat.PAGE_Steps*15)  { BLM_LED(1, (step-beat.PAGE_Steps*14), 0, 3); }  
                if( step > beat.PAGE_Steps*15  &&  step < beat.PAGE_Steps*16)  { BLM_LED(1, (step-beat.PAGE_Steps*15), 0, 3); }
                }


  // Update BLM (show Tic-Offset)                             
  if((ID == 0 && value == 0) || (ID == 5 && V == 0));{
 
        int colorO = 0; int y;  for(y=0; y<16; y++)  {
          if(Seq[y][SeqFocusStep] > 0) { colorO = 2;}
                                  else { colorO = 0;}
          if(SeqTic[y][SeqFocusStep] == 0)        {BLM_LED( 0, 0, y, colorO);}  //+0Tics = No Delay = no Offset
          if(SeqTic[y][SeqFocusStep] >= 2)        {BLM_LED( 0, 1, y, colorO );}  //+6Tics = Delay
          if(SeqTic[y][SeqFocusStep] >= 4)       {BLM_LED( 0, 1, y, colorO ); //6*2=12Tics Delay
                                                   BLM_LED( 0, 2, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= 6)       {BLM_LED( 0, 1, y, colorO ); //6*3=18Tics Delay
                                                   BLM_LED( 0, 2, y, colorO );
                                                   BLM_LED( 0, 3, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= 8)       {BLM_LED( 0, 1, y, colorO ); //6*4=24Tics Delay
                                                   BLM_LED( 0, 2, y, colorO );
                                                   BLM_LED( 0, 3, y, colorO );
                                                   BLM_LED( 0, 4, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= 10)       {BLM_LED( 0, 1, y, colorO ); //6*5=30Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= 12)       {BLM_LED( 0, 1, y, colorO); //6*6=36Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= 14)       {BLM_LED( 0, 1, y, colorO); //6*7=42Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= 16)       {BLM_LED( 0, 1, y, colorO); //6*8=48Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= 18)       {BLM_LED( 0, 1, y, colorO); //6*9=54Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 20)        {BLM_LED( 0, 1, y, colorO); //6*10=60Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 22)        {BLM_LED( 0, 1, y, colorO); //6*11=66Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);
                                                   BLM_LED( 0, 11, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 24)        {BLM_LED( 0, 1, y, colorO); //6*12=72Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);
                                                   BLM_LED( 0, 11, y, colorO);
                                                   BLM_LED( 0, 12, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 26)        {BLM_LED( 0, 1, y, colorO); //6*13=78Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);
                                                   BLM_LED( 0, 11, y, colorO);
                                                   BLM_LED( 0, 12, y, colorO);
                                                   BLM_LED( 0, 13, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 28) {       BLM_LED( 0, 1, y, colorO); //6*14=84Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);
                                                   BLM_LED( 0, 11, y, colorO);
                                                   BLM_LED( 0, 12, y, colorO);
                                                   BLM_LED( 0, 13, y, colorO);
                                                   BLM_LED( 0, 14, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= 30) {       BLM_LED( 0, 1, y, colorO); //6*15=84Tics Delay
                                                   BLM_LED( 0, 2, y, colorO);
                                                   BLM_LED( 0, 3, y, colorO);
                                                   BLM_LED( 0, 4, y, colorO);
                                                   BLM_LED( 0, 5, y, colorO);
                                                   BLM_LED( 0, 6, y, colorO);
                                                   BLM_LED( 0, 7, y, colorO);
                                                   BLM_LED( 0, 8, y, colorO);
                                                   BLM_LED( 0, 9, y, colorO);
                                                   BLM_LED( 0, 10, y, colorO);
                                                   BLM_LED( 0, 11, y, colorO);
                                                   BLM_LED( 0, 12, y, colorO);
                                                   BLM_LED( 0, 13, y, colorO);
                                                   BLM_LED( 0, 14, y, colorO);
                                                   BLM_LED( 0, 15, y, colorO);}
           }



}} // END SEQUENCER MODE


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SWING MODE ///////////////////////////////////////////////////////////////////////////////////////////////////////////
  if(MatrixUse == 2){
    static u8 SwingBLM[16][16] ={{}};     // use to avoid to much midi Traffic, 2 calculate the SWING-AMMOUNT-BARS for Swing Value....

    if(ID == 7) { // Menue-Encoder --- switch Pages
            beat.PAGE_actual = beat.PAGE_actual + value;
            if(beat.PAGE_actual <  0)  { beat.PAGE_actual = 15; }
            if(beat.PAGE_actual > 15)  { beat.PAGE_actual =  0; }
            
            int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}        // deactivate LED Horizontal Extra Buttons
            BLM_LED(1, beat.PAGE_loop[0],  0, 1);   // activate LED   Loop-Start    
            BLM_LED(1, beat.PAGE_loop[1],  0, 1);   // activate LED   Loop-END
            BLM_LED(1, beat.PAGE_actual,   0, 3);   // activate LED   Currently Editet Page
    }

            
    //focus Track
    if(ID == 2) {focusMatrixUse[1] = H; }


    if(ID == 0 && value == 0) {//Matrix touched?
      if(H == 0) { //ROW 0   //Swing OFF ON16th ON8th///////////////////////
        //y+16 = offset, because we can only show 16 ROWS on the BLM
        if(Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] >= 2)  {Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0;}  //switch   Swing OFF
   else if(Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] == 0)  {Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] = 1;}  //switch 2 16th Mode
   else if(Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] == 1)  {Seq[H+16][V+(beat.PAGE_actual*(beat.PAGE_Steps))] = 2;}} //switch 2  8th Mode

      if(H >= 1) { //ROW 1-15 //Swing ammount///////////////////////////////
        if(V == 0) { //STEP0
          Seq[17][0+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} //[y1]CELL  [X0]STEP
        if(V == 1) { //STEP1
          Seq[17][1+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} //[y1]CELL  [X1]STEP
        if(V == 2) { //STEP2
          Seq[17][2+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} //[y1]CELL  [X2]STEP
        if(V == 3) { //STEP3
          Seq[17][3+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} //[y1]CELL  [X3]STEP
        if(V == 4) { //STEP4
          Seq[17][4+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 5) { //STEP5
          Seq[17][5+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 6) { //STEP6
          Seq[17][6+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 7) { //STEP7
          Seq[17][7+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 8) { //STEP8
          Seq[17][8+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 9) { //STEP9
          Seq[17][9+(beat.PAGE_actual*(beat.PAGE_Steps))]  = H;} 
        if(V == 10) { //STEP10
          Seq[17][10+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;} 
        if(V == 11) { //STEP11
          Seq[17][11+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;} 
        if(V == 12) { //STEP12
          Seq[17][12+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;} 
        if(V == 13) { //STEP13
          Seq[17][13+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;} 
        if(V == 14) { //STEP14
          Seq[17][14+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;}
        if(V == 15) { //STEP15
          Seq[17][15+(beat.PAGE_actual*(beat.PAGE_Steps))] = H;}
}}
        //Clear Temporar Matrix


        int y;  for(y=1; y<16; y++)    {
        int x;  for(x=0; x<16; x++)    {    SwingBLM[y][x] = 0;}} //Clear temporar Matrix

        //Save [Y1] Button State in a Temporar Matrix... to visualize it later on the GRID
        int x;  for(x=0; x<16; x++)    {  //go thru all steps  
        int y;  for(y=0; y<Seq[17][x+(beat.PAGE_actual*(beat.PAGE_Steps))]; y++)    {  SwingBLM[y][x] = 3;}} //only activate number of Y-Lines cooresponding to [Y1]


     //DUMP OUT ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
     if((ID == 0 && value == 0) || (ID == 5 && V == 1));{ //button pressed? || Dumpout Call?

       //Dump Row[=y] 0 OUT to BLM  =  SWING OFF ON16th ON8th
          int x;  for(x=0; x<16; x++)  {BLM_LED( 0, x, 0, Seq[16][x+(beat.PAGE_actual*(beat.PAGE_Steps))]);} //(blm, element, x, y, color);

       //Dump SWING Value out
                     for(x=0; x<16; x++)  { //go thru all 16 Steps
              int y; for(y=0; y<15; y++)  { //go thru all 15 Rows
            BLM_LED( 0, x, y+1, SwingBLM[y][x]);}}} //(blm, id, x, y, color);


    //Set Loop Length
    if(ID == 1){//X-Buttons
      if(value ==0 && LoopSetCount ==1) {if(V < btn) {beat.PAGE_loop[0] = V; beat.PAGE_loop[1] = V;}
		                                            if(V > btn) {beat.PAGE_loop[0] = btn; beat.PAGE_loop[1] = V;}} //2.while holding 1. pressing 2. set Loop Point
      if(value ==0 && LoopSetCount ==0) {LoopSetCount = LoopSetCount+1;      //1. Show selected beat.PAGE_actual on BLM, set a memory Start beat.PAGE_actual "btn"
         beat.PAGE_actual = V; btn = V;}	//show selected beat.PAGE_actual on the BLM, memory V for 2.
      if(value == 1){LoopSetCount = 0; //Clear Counter - its all done
          flag.NeedSync = 1;}   //see "seq.c." Call beat.bpm counter that something has to be change
        //turn off All Buttons
        int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}
        BLM_LED(1, beat.PAGE_loop[0], 0, 1); //PAGE_actual Start
        BLM_LED(1, beat.PAGE_loop[1],  0, 1);} //PAGE_actual END
        
    //SET Loop Point: press and hold first btn, press 2nd BTN, release booth.
    //is 2nd BTN greater then 1st.BTN, then LoopEndPoint will be 2ndBTN,
    //is 2nd BTN smaller then 1st.BTN then you loop only the 1stbeat.PAGE_actual.


    //STEP-LIGHT///X...X...X...X...X...X...X...O...X...   
    if(ID == 6) {//6: StepLight, we show the StepIndicator+beat.PAGE_actual+LoopStartStop on the Extra X Buttons
		
      //turn off All Buttons
      int x; for(x=0; x<16; x++) { BLM_LED(1, x, 0, 0);}
      //Turn on beat.PAGE_actual-Start & beat.PAGE_loop[1] >> Loop Cycle
      BLM_LED(1, beat.PAGE_loop[0], 0, 1);
      BLM_LED(1, beat.PAGE_loop[1],  0, 1);         
	  if(V >= 0             && V <= beat.PAGE_Steps)    {BLM_LED(1, V, 0, 3); //Set Step LED
                                                                   BLM_LED(1, 0,    0, 2); //PAGE_actual Indicator
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);} //Viewed beat.PAGE_actual                                                                   
	  if(V > beat.PAGE_Steps    && V <= beat.PAGE_Steps*2)  {BLM_LED(1, (V-beat.PAGE_Steps),0, 3); 
                                                                   BLM_LED(1, 1,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*2  && V <= beat.PAGE_Steps*3)  {BLM_LED(1, (V-beat.PAGE_Steps*2),  0, 3); 
                                                                   BLM_LED(1, 2,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*3  && V <= beat.PAGE_Steps*4)  {BLM_LED(1, (V-beat.PAGE_Steps*3),  0, 3); 
                                                                   BLM_LED(1, 3,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}   
	  if(V > beat.PAGE_Steps*4  && V <= beat.PAGE_Steps*5)  {BLM_LED(1, (V-beat.PAGE_Steps*4),  0, 3); 
                                                                   BLM_LED(1, 4,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*5  && V <= beat.PAGE_Steps*6)  {BLM_LED(1, (V-beat.PAGE_Steps*5),  0, 3); 
                                                                   BLM_LED(1, 5,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*6  && V <= beat.PAGE_Steps*7)  {BLM_LED(1, (V-beat.PAGE_Steps*6),  0, 3); 
                                                                   BLM_LED(1, 6,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}   
	  if(V > beat.PAGE_Steps*7  && V <= beat.PAGE_Steps*8)  {BLM_LED(1, (V-beat.PAGE_Steps*7),  0, 3); 
                                                                   BLM_LED(1, 7,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*8  && V <= beat.PAGE_Steps*9)  {BLM_LED(1, (V-beat.PAGE_Steps*8),  0, 3); 
                                                                   BLM_LED(1, 8,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}   
	  if(V > beat.PAGE_Steps*9  && V <= beat.PAGE_Steps*10) {BLM_LED(1, (V-beat.PAGE_Steps*9),  0, 3); 
                                                                   BLM_LED(1, 9,    0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*10 && V <= beat.PAGE_Steps*11) {BLM_LED(1, (V-beat.PAGE_Steps*10), 0, 3); 
                                                                   BLM_LED(1, 10,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*11 && V <= beat.PAGE_Steps*12) {BLM_LED(1, (V-beat.PAGE_Steps*11), 0, 3); 
                                                                   BLM_LED(1, 11,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*12 && V <= beat.PAGE_Steps*13) {BLM_LED(1, (V-beat.PAGE_Steps*12), 0, 3); 
                                                                   BLM_LED(1, 12,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*13 && V <= beat.PAGE_Steps*14) {BLM_LED(1, (V-beat.PAGE_Steps*13), 0, 3); 
                                                                   BLM_LED(1, 13,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*14 && V <= beat.PAGE_Steps*15) {BLM_LED(1, (V-beat.PAGE_Steps*14), 0, 3); 
                                                                   BLM_LED(1, 14,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}  
	  if(V > beat.PAGE_Steps*15 && V <= beat.PAGE_Steps*16) {BLM_LED(1, (V-beat.PAGE_Steps*15), 0, 3); 
                                                                   BLM_LED(1, 15,   0, 2); 
                                                                   BLM_LED(1, beat.PAGE_actual, 0, 3);}
}                              

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// TRIGGERMATRIX Router or CC Mode //////////////////////////////////////////////////////////////////////////////////////
if((MatrixUse == 3) || (MatrixUse == 4)) {


    // 505 LOAD MATRIXES FROM CARD
  // if(value == 1 && ID == 1) {portflag = 1;} // 505 LOAD MATRIXES FROM CARD
   
    if(ID == 7) { // Menue-Encoder --- switch Pages
            MtxPartNr = MtxPartNr + value;
            if(MtxPartNr <  1)  { MtxPartNr =  0; }
            if(MtxPartNr > 14)  { MtxPartNr = 15; }
            H = MtxPartNr;
                    int e; for(e=0; e<16; e++) {EXTRA[e][0] = 0;} // Turn off all Songpart LEDs 
                    EXTRA[MtxPartNr][0] = 1; // activate one of the songparts-indicators
                    // Load Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
                    int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y]; } } }


    if(ID == 2) {   // EXTRA-VERTICALS
           
        // TRIGGER ROUTING PRESETS
        if(flag.shiftvalue == 1) {
            
             if(value == 0) { // avoid double triggering, we toggle...                                                     
                    MtxPartNr = H;
                    int e; for(e=0; e<16; e++) {EXTRA[e][0] = 0;} // Turn off all Songpart LEDs 
                    EXTRA[H][0] = 1; // activate one of the songparts-indicators
                    // Load Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
                    int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y]; } } }
               
             // Deactivate LOCKS of ROLLs
             if(value == 1) { int z; for(z=0; z<16; z++)  {BLM_LED(1, z, 16, 0); EXTRA[z][1] = 1;} }  }
            }


    if(ID == 1) { // Horizontal Button  R O L L    R O L L    R O L L
                            u8 color = 2;
                            if (value == 1) { color = 0; }
                            EXTRA[V][1] = value; BLM_LED(1, V, 0, color); // RollButtons as Momentarys
        
                            if(EXTRA[V][1] == 0) { int y; for( y=0; y<16; y++ ) { MtxLoad[y][V]=MATRIX[Roll_Load_MTX][y][V]; } }        // Overwrite temporar Roll
                            else                 { int y; for( y=0; y<16; y++ ) { MtxLoad[y][V]=MATRIX[MtxPartNr][y][V]; } } // Change to orginal Routing
            
                            }

// MATRIX-BUTTONS - in Router-Mode (MatrixUse 2) 
   if(MatrixUse==3 && ID==0 && value==0) { //lets toggle the Matrix Data 4 Songparts 
      MATRIX[MtxPartNr][H][V]   =!   MATRIX[MtxPartNr][H][V];
     //Load Saved Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
      int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];;}}} 

//MATRIX-BUTTONS - in CC-Mode Mode (MatrixUse 3)
if(MatrixUse==4 && ID==0 && value == 0) { 
   //Solo - Radio-Switch-Button
  if(H == 14) { //Solo Collum
    if(CCMtx[H][V] == 1) { //was solo active before?
         int x; for(x=0; x<16; x++) { CCMtx[H][x]=0;} AnySolo = 0;} //then deactivate all solos
    else{int x; for(x=0; x<16; x++) { CCMtx[H][x]=0; CCMtx[H][V]=1;} AnySolo = 1;}} //if deactive then deactivate all execpt pressed one
    // All Others
    else{CCMtx[H][V]   =!   CCMtx[H][V];}} //lets toggle the Matrix Data 4 Function-Perform-Mode  

//DUMP OUT MATRIX & EXTRA-X States to BLM 
if ( value == 0  ||  ID == 7 ) {       
  //MATRIX
  if( (ID ==0) || (ID == 10) || (ID==5)   || (ID == 2 )  ||  (ID == 7) ) {// pressed MATRIX/EXTRA-X Button?

      if(MatrixUse==3){//TriggerMatrixRouter
                int y;  for(y=0; y<16; y++)    {
                int x;  for(x=0; x<16; x++)    {
                  //Dump the whole ARRAY OUT!
                  BLM_LED( 0, x, y, MATRIX[MtxPartNr][y][x]);}}} //(blm, id-element, x, y, color);

      if(MatrixUse==4){//TriggerMatrixCC
	            u8 color0 = 0; u8 color1 = 1; u8 colorBLM = 0; 
        //Lets Load the BLM with [one of the][16][16] Matrices
        int y;  for(y=0; y<16; y++)    {
        int x;  for(x=0; x<16; x++)    {                                  //But before we have to change the Color Pattern...
                 //////COLOR-PATTERN//////////////////////
                if(COLOR[y][x] == 0){color0 = 0; color1 =1;} //     0         0 > OFF      1 > BLUE 
                if(COLOR[y][x] == 1){color0 = 0; color1 =2;} //     1         0 > OFF      2 > GREEN 
                if(COLOR[y][x] == 2){color0 = 0; color1 =3;} //     2         0 > OFF      3 > CYAN 
                if(COLOR[y][x] == 3){color0 = 1; color1 =1;} //     3         1 > BLUE     1 > BLUE 
                if(COLOR[y][x] == 4){color0 = 1; color1 =2;} //     4         1 > BLUE     2 > GREEN 
                if(COLOR[y][x] == 5){color0 = 1; color1 =3;} //     5         1 > BLUE     3 > CYAN
                if(COLOR[y][x] == 6){color0 = 0; color1 =0;} //     6         0 > OFF      0 > OFF
                
			    if(CCMtx[y][x] == 0) {colorBLM = color0;} //get the actual Matrix value/state 
			    if(CCMtx[y][x] == 1) {colorBLM = color1;} //get the actual Matrix value/state 			
                //Dump the whole ARRAY OUT!
                BLM_LED(0, x, y, colorBLM);}}}} //(ID, V, H, new_colour);

   //EXTRA Y  ||||  Verticals            
   if ((ID == 2) || (ID == 10) || (ID == 5) || (ID == 7) )  { // dumpout LEDs
     u8 color0ex = 0; u8 color1ex = 1; u8 colorBLMex = 0;  int y; for(y=0; y<16; y++) {//ID == 10comes from above when a BLM has been connected.
                 //////COLOR-PATTERN//////////////////////
                if(COLORex[y][1] == 0){color0ex = 0; color1ex =1;} //     0         0 > OFF      1 > BLUE 
                if(COLORex[y][1] == 1){color0ex = 0; color1ex =2;} //     1         0 > OFF      2 > GREEN 
                if(COLORex[y][1] == 2){color0ex = 0; color1ex =3;} //     2         0 > OFF      3 > CYAN 
                if(COLORex[y][1] == 3){color0ex = 1; color1ex =1;} //     3         1 > BLUE     1 > BLUE 
                if(COLORex[y][1] == 4){color0ex = 1; color1ex =2;} //     4         1 > BLUE     2 > GREEN 
                if(COLORex[y][1] == 5){color0ex = 1; color1ex =3;} //     5         1 > BLUE     3 > CYAN
                if(COLORex[y][1] == 6){color0ex = 0; color1ex =0;} //     6         0 > OFF      0 > OFF
                
			    if(EXTRA[y][0] == 0) {colorBLMex = color0ex;} //get the actual EXTRA value/state 
			    if(EXTRA[y][0] == 1) {colorBLMex = color1ex;} //get the actual EXTRA value/state 			
                //Now Dump the whole ARRAY OUT!
                BLM_LED(2, 0, y, colorBLMex);}} //(blm, ID, V, H, new_colour);
}
} //END TRIGGER MATRIX MODE

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// LAUNCH PAD//////////////////////////////////////////////////////////////////////////////////////////////////////////////
if(MatrixUse == 5){
           
    // LAUNCHPAD - Clip Launch Matrix - Load Presets
    static u8 LaunchMTX[16][16] = 
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 0  -  Clip 0
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 0  -  Clip 1
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 0  -  Clip 2
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 0  -  Clip 3
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 1  -  Clip 0
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 1  -  Clip 1
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 1  -  Clip 2
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 1  -  Clip 3 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 2  -  Clip 0
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 2  -  Clip 1 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 2  -  Clip 2 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // Song 2  -  Clip 3
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
        
    // Color Patterns for LaunchMTX
    static u8 LaunchMTX_color[16][16]=
    //0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5
	{{4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5},
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //when toggling button states, u get State 0/1, 0 is OFF, and 1 is LED-ON RED..
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //want different colors? u have to interprete them via a MASK - tada! "COLOR" Mask
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //Here are the interpretation for every Cell saved.
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //COLOR val:  MATRIX val=0,  MATRIX val=1
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     0         0 > OFF      1 > BLUE
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     1         0 > OFF      2 > GREEN 
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     2         0 > OFF      3 > CYAN 
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     3         1 > BLUE     1 > BLUE 
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     4         1 > BLUE     2 > GREEN 
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     5         1 > BLUE     3 > CYAN
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}, //     6         0 > OFF      0 > OFF
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5},  
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5},  
     {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5},
	 {4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,5}};
    // // // // // // // // // // // // // // // // // // // // // // //

    
    if(ID == 7) { // Menue-Encoder --- switch Pages
            launch_page = launch_page + value;
            if(launch_page <  1)  { launch_page =  0; }
            if(launch_page > 14)  { launch_page = 15; }
            H = launch_page;}
            

    if(ID == 2  &&  value == 0)  {  // Verticals
                                    // sense for Launch_page (16 songs a page)
                                    launch_page = H; }
    
    if(ID == 1  &&  value == 0)  { }  // Horizontals
    
    if(ID == 0  &&  value == 0)  {  // Matrix


        // clear MATRIX
        u8 y; for(y=0; y<16; y++)    {
        u8 x; for(x=0; x<16; x++)    { LaunchMTX[y][x] = 0; } }
        
        // Sense for new active song = TRIGGERMATRIX
        if ( V == 15)                   { main_song       = H + (launch_page*16);
                                          SD(4,H + (launch_page*16),1);  // Load from SD
                                          last_used_item = 5; } // notify that TM was last Launched 

        // Sense for new active drum-sequence
        if ( V >= 10  &&  V <= 13 )     {   tm.seq_variation   = V-10;
                                            seq_song        = H + (launch_page*16);
                                            SD(tm.seq_variation, H + (launch_page*16), 1);  // Load from SD
                                            last_used_item = 4; } // notify that DRUM was last Launched 
                                            
        // Sense for new active melody-sequence
        if ( V >= 0  &&  V <= 1 )       {   melo_variation[0]  = V;     melo_song[0]    = H + (launch_page*16); last_used_item = 0; }
        if ( V >= 2  &&  V <= 3 )       {   melo_variation[1]  = V-2;   melo_song[1]    = H + (launch_page*16); last_used_item = 1; }
        if ( V >= 4  &&  V <= 5 )       {   melo_variation[2]  = V-4;   melo_song[2]    = H + (launch_page*16); last_used_item = 2; }
        if ( V >= 6  &&  V <= 7 )       {   melo_variation[3]  = V-6;   melo_song[3]    = H + (launch_page*16); last_used_item = 3; }
        }
                                    
    // DUMP OUT
    if( (ID == 0 && value == 1)  ||  (ID == 1 && value == 1)  ||  (ID == 2 && value == 1)  ||    (ID == 5 && V == 0)  ||  (ID ==7)); {

        //Clear LaunchMatrix
                u8 r; for(r=0; r<16; r++)    {
                u8 t; for(t=0; t<16; t++)    { LaunchMTX[r][t] = 0; } }


                // calculate Launch_page, indicate Main_song & Seq_song
                u16 min = launch_page*16;
                u16 max = launch_page*16+16;
        
                if( main_song    >= min  &&  main_song    < max )    { LaunchMTX[ main_song   -min]    [15] = 1; }
                if( seq_song     >= min  &&  seq_song     < max )    { LaunchMTX[ seq_song    -min] [tm.seq_variation+10]  = 1; }
                if( melo_song[0] >= min  &&  melo_song[0] < max )    { LaunchMTX[ melo_song[0]-min] [melo_variation[0]] = 1; }
                if( melo_song[1] >= min  &&  melo_song[1] < max )    { LaunchMTX[ melo_song[1]-min] [melo_variation[1]+2] = 1; }
                if( melo_song[2] >= min  &&  melo_song[2] < max )    { LaunchMTX[ melo_song[2]-min] [melo_variation[2]+4] = 1; }
                if( melo_song[3] >= min  &&  melo_song[3] < max )    { LaunchMTX[ melo_song[3]-min] [melo_variation[3]+6] = 1; }
    
        //Dump out Mask  with  Color Code
        u8 color0 = 0; u8 color1 = 1; u8 colorBLM = 0;
        int y;  for(y=0; y<16; y++)    {
        int x;  for(x=0; x<16; x++)    {                             
                 //////COLOR-PATTERN//////////////////////
                if(LaunchMTX_color[y][x] == 0){color0 = 0; color1 =1;} //     0         0 > OFF      1 > BLUE 
                if(LaunchMTX_color[y][x] == 1){color0 = 0; color1 =2;} //     1         0 > OFF      2 > GREEN 
                if(LaunchMTX_color[y][x] == 2){color0 = 0; color1 =3;} //     2         0 > OFF      3 > CYAN 
                if(LaunchMTX_color[y][x] == 3){color0 = 1; color1 =1;} //     3         1 > BLUE     1 > BLUE 
                if(LaunchMTX_color[y][x] == 4){color0 = 1; color1 =2;} //     4         1 > BLUE     2 > GREEN 
                if(LaunchMTX_color[y][x] == 5){color0 = 1; color1 =3;} //     5         1 > BLUE     3 > CYAN
                if(LaunchMTX_color[y][x] == 6){color0 = 0; color1 =0;} //     6         0 > OFF      0 > OFF
                
			    if(LaunchMTX[y][x] == 0) {colorBLM = color0;} //get the actual Matrix value/state 
			    if(LaunchMTX[y][x] == 1) {colorBLM = color1;} //get the actual Matrix value/state 			
                //Dump the whole ARRAY OUT!
                BLM_LED(0, x, y, colorBLM);}} //(ID, V, H, new_colour);

        // clear VERTICALS
        u8 x; for(x=0; x<16; x++)    { BLM_LED(2, 0, x, 0);} // (blm, ID, V, H, new_colour);
        
        // Dump out VERTICALS --- Indicate Launch_Page
        BLM_LED(2, 0, launch_page, 3); //(blm, ID, V, H, new_colour);
    }
} // END LAUNCHPAD

    
} //End Hook

void shift( u16 ID, u16 H, u16 V, s16 value){
    static u8  Shift_Vertical_Btn = 0;
    static const u8 ShiftMTX[16][16][16] = {
     
    //// [0]: copy paste clear ////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,2,2,0,2,0,0,2,2,2,0,2,0,2,0}, // COPY:
	 {0,2,0,0,2,0,2,0,2,2,2,0,2,2,2,0}, // HIT a Button in this Space to copy actual-showed Matrix
	 {0,2,0,0,2,0,2,0,2,0,0,0,0,0,2,0}, // Dont Matter in which Menue you where
	 {0,0,2,2,0,2,0,0,2,0,0,0,0,0,2,0}, // After Operation you get back to your Menue   
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,2,2,2,0,0,2,0,0,2,2,0,2,2,2,0}, // PASTE:
     {0,2,2,2,0,2,0,2,0,2,0,0,0,2,0,0}, // paste copyéd Matrix
     {0,2,0,0,0,2,2,2,0,0,2,0,0,2,0,0}, //
     {0,2,0,0,0,2,0,2,0,2,2,0,0,2,0,0}, //
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,2,2,0,2,0,0,0,2,2,2,0,0,0,0}, // CLEAR:
     {0,2,0,0,0,2,0,0,0,2,0,2,0,0,0,0}, // clear actual Matrix
     {0,2,0,0,0,2,0,0,0,2,2,0,0,0,0,0}, // 
     {0,0,2,2,0,2,2,2,0,2,0,2,0,0,0,0}, //
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
     
    //// [1]: TACT System 3/4 4/4... ////
	{{1,1,1,0,0,0,1,0,1,1,1,0,1,1,1,1}, // SEQUENCER - TACT SYSTEM
	 {0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1}, // Beat Tact: 3 4 5 7
	 {0,1,1,0,1,1,1,0,1,1,1,0,0,0,1,0}, // Beat Tact: 11 1
	 {0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0}, // 
	 {1,1,1,0,0,0,1,0,1,1,1,0,1,0,0,0}, // 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1}, //
     {0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,1}, //
     {1,0,1,0,1,0,1,0,0,1,0,1,0,0,1,1}, // Beat Tact: 11 1
     {0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1}, //
     {0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1}, //
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1}, //
     {0,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0}, // 
     {0,1,0,1,1,1,1,1,0,1,0,0,0,0,1,0}, //
	 {0,1,0,1,0,0,0,1,0,1,1,1,0,0,1,0}}, //

    //// Store Load... ////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},   
	 {3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0}, //2
	 {3,0,0,0,0,3,0,0,3,0,3,0,3,0,3,0}, //3
	 {3,3,3,0,0,3,0,0,3,0,3,0,3,3,0,0}, //4  STORE 
	 {0,0,3,0,0,3,0,0,3,0,3,0,3,0,3,0}, //5
	 {3,3,3,0,0,3,0,0,3,3,3,0,3,0,3,0}, //6
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {3,0,0,0,3,3,3,0,0,3,0,0,3,3,0,0}, //9
     {3,0,0,0,3,0,3,0,3,0,3,0,3,0,3,0}, //10
     {3,0,0,0,3,0,3,0,3,3,3,0,3,0,3,0}, //11 LOAD
     {3,0,0,0,3,0,3,0,3,0,3,0,3,0,3,0}, //12
     {3,3,3,0,3,3,3,0,3,0,3,0,3,3,0,0}, //13
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}
              
     };


    if( MatrixUse == 0 ) { // Sequencer-Mode  -  SEQ + StepOffset

            // send LED-Masks
            if(ID == 2 && value == 1) { // Vertical Buttons
                                                                                     
                                    int y;  for(y=0; y<16; y++)    {
                                    int x;  for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, ShiftMTX[H][y][x]);}}  // (id-element, x, y, color);
                                            
                                    Shift_Vertical_Btn = H; // to know wich Operation Matrix we want to use...
                                    }
    
                                    
            if(ID == 0 && value == 1) { // 16x16 Matrix

                    if( Shift_Vertical_Btn == 0) { // copy paste clear    // Sequencer-Mode STEP+TIC+SWING
                        // COPY
                        if( H < 5)              { APP_DIN_NotifyToggle(99 ,0); } // reroute to DIN - do it elsewhere
                        // PASTE
                        if( H >= 6 && H <= 9)   { APP_DIN_NotifyToggle(100,0); } // reroute to DIN - do it elsewhere
         
                        // CLEAR
                        if( H >= 11 && H <= 14) { APP_DIN_NotifyToggle(101,0); }}// reroute to DIN - do it elsewhere



                    if( Shift_Vertical_Btn == 1) { // TACT SYSTEM 3/4, 4/4, 5/4, 7/4, 11/4, 13/4  beat.rythm
                        // 3 4 5 7
                        if( H < 5)   {  if( V < 3 )             { beat.rythm = 3; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 12; flag.NeedSync = 1;  }
                                        if( V >=4  &&  V <= 6 ) { beat.rythm = 4; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 16; flag.NeedSync = 1;  }
                                        if( V >=8  &&  V <= 10) { beat.rythm = 5; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 10; flag.NeedSync = 1;  }
                                        if( V >=12 &&  V <= 15) { beat.rythm = 7; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 14; flag.NeedSync = 1;  } }
                                        
                        // 11 13
                        if( H >= 6 && H <= 10)
                                    {   if( V < 6 )             { beat.rythm = 11; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 11; flag.NeedSync = 1;  }
                                        if( V >=9  &&  V <= 15 ){ beat.rythm = 11; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 11; flag.NeedSync = 1;  } }
                        // MIOS32_MIDI_SendDebugMessage("rythm:%d , flag:%d , V:%d , H:%d", beat.rythm, flag.NeedSync, V, H);
         

                        // Return to normal Operation
                        MatrixUse = 0; Router(5, 0, 0, 0); }  //  RECALL



                    if( Shift_Vertical_Btn == 2) { // STORE LOAD
                        // Store
                        if( H >= 2  &&  H <= 6 )    { SD(tm.seq_variation,seq_song,2);
                                                    MatrixUse = 0; Router(5, 0, 0, 0); } // Return to normal Operation
                        // Load
                        if( H >= 9  &&  H <= 13)    { SD(tm.seq_variation,seq_song,1);
                                                    flag.NeedSync = 1;
                        // MIOS32_MIDI_SendDebugMessage("rythm:%d , flag:%d , V:%d , H:%d", beat.rythm, flag.NeedSync, V, H);
                                                    MatrixUse = 0; Router(5, 0, 0, 0); } // Return to normal Operation
                        } } //  RECALL
}


    if( MatrixUse == 1 ) { // Sequencer-Mode  -  SEQ + StepOffset

            // send LED-Masks
            if(ID == 2 && value == 1) { // Vertical Buttons
                                                                                     
                                    int y;  for(y=0; y<16; y++)    {
                                    int x;  for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, ShiftMTX[H][y][x]);}}  // (id-element, x, y, color);
                                            
                                    Shift_Vertical_Btn = H; // to know wich Operation Matrix we want to use...
                                    }
    
                                    
            if(ID == 0 && value == 1) { // 16x16 Matrix

                    if( Shift_Vertical_Btn == 0) { // copy paste clear    // Sequencer-Mode TIC only
                        // COPY
                        if( H < 5)              { APP_DIN_NotifyToggle(99, 0); } // reroute to DIN - do it elsewhere
                        // PASTE
                        if( H >= 6 && H <= 9)   { APP_DIN_NotifyToggle(100,0); } // reroute to DIN - do it elsewhere
                        // CLEAR
                        if( H >= 11 && H <= 14) { APP_DIN_NotifyToggle(101,0); }}// reroute to DIN - do it elsewhere



                    if( Shift_Vertical_Btn == 1) { // TACT SYSTEM 3/4, 4/4, 5/4, 7/4, 11/4, 13/4  beat.rythm
                        // 3 4 5 7
                        if( H < 5)   {  if( V < 3 )             { beat.rythm = 3; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 12; flag.NeedSync = 1;  }
                                        if( V >=4  &&  V <= 6 ) { beat.rythm = 4; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 16; flag.NeedSync = 1;  }
                                        if( V >=8  &&  V <= 10) { beat.rythm = 5; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 10; flag.NeedSync = 1;  }
                                        if( V >=12 &&  V <= 15) { beat.rythm = 7; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 14; flag.NeedSync = 1;  } }
                                        
                        // 11 13
                        if( H >= 6 && H <= 10)
                                    {   if( V < 6 )             { beat.rythm = 11; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 11; flag.NeedSync = 1;  }
                                        if( V >=9  &&  V <= 15 ){ beat.rythm = 11; beat.MainLoop = beat.rythm* 4; beat.PAGE_Steps = 11; flag.NeedSync = 1;  } }
                        // MIOS32_MIDI_SendDebugMessage("rythm:%d , flag:%d , V:%d , H:%d", beat.rythm, flag.NeedSync, V, H);
         

                        // Return to normal Operation
                        MatrixUse = 0; Router(5, 0, 0, 0); }  //  RECALL



                    if( Shift_Vertical_Btn == 2) { // STORE LOAD
                        // Store
                        if( H >= 2  &&  H <= 6 )    { SD(tm.seq_variation,seq_song,2);
                                                    MatrixUse = 1; Router(5, 0, 0, 0); } // Return to normal Operation
                        // Load
                        if( H >= 9  &&  H <= 13)    { SD(tm.seq_variation,seq_song,1);
                                                    flag.NeedSync = 1;
                                                    MatrixUse = 1; Router(5, 0, 0, 0); } // Return to normal Operation
                        }} //  RECALL
}

        
    if( MatrixUse == 2 ) { // Sequencer-Mode  -  SWING

            // send LED-Masks
            if(ID == 2 && value == 1) { // Vertical Buttons
                                                                                     
                                    int y;  for(y=0; y<16; y++)    {
                                    int x;  for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, ShiftMTX[H][y][x]);}}  // (id-element, x, y, color);
                                            
                                    Shift_Vertical_Btn = H; // to know wich Operation Matrix we want to use...
                                    }
    
                                    
            if(ID == 0 && value == 1) { // 16x16 Matrix

                    if( Shift_Vertical_Btn == 0) { // copy paste clear
                        // COPY
                        if( H < 5)              { APP_DIN_NotifyToggle(99 ,0); }  // reroute to DIN - do it elsewhere
                        // PASTE
                        if( H >= 6 && H <= 9)   { APP_DIN_NotifyToggle(100,0); }  // reroute to DIN - do it elsewhere
         
                        // CLEAR
                        if( H >= 11 && H <= 14) { APP_DIN_NotifyToggle(101,0); }}}} // reroute to DIN - do it elsewhere 


    if( MatrixUse == 3 ) { // Router-Mode

            // send LED-Masks
            if(ID == 2 && value == 1) { // Vertical Buttons
                                                                                     
                                    int y;  for(y=0; y<16; y++)    {
                                    int x;  for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, ShiftMTX[H][y][x]);}}  // (id-element, x, y, color);
                                            
                                    Shift_Vertical_Btn = H; // to know wich Operation Matrix we want to use...
                                    }
    
                                    
            if(ID == 0 && value == 1) { // 16x16 Matrix

                    if( Shift_Vertical_Btn == 0) { // copy paste clear
                        
                        // COPY
                        if( H < 5)              { APP_DIN_NotifyToggle(99 ,0); }   // reroute to DIN - do it elsewhere
                        
                        // PASTE
                        if( H >= 6 && H <= 9)   { APP_DIN_NotifyToggle(100,0); }   // reroute to DIN - do it elsewhere
                        
                        // CLEAR
                        if( H >= 11 && H <= 14) { APP_DIN_NotifyToggle(101,0); }} // reroute to DIN - do it elsewhere


                    if( Shift_Vertical_Btn == 2) { // STORE LOAD
                        // Store
                        if( H >= 2  &&  H <= 6 )    { SD(4,main_song,2);
                                                    MatrixUse = 3; Router(5, 0, 0, 0); } // Return to normal Operation
                        // Load
                        if( H >= 9  &&  H <= 13)    { SD(4,main_song,1);
                                                    flag.NeedSync = 1;
                        // MIOS32_MIDI_SendDebugMessage("rythm:%d , flag:%d , V:%d , H:%d", beat.rythm, flag.NeedSync, V, H);
                                                    MatrixUse = 3; Router(5, 0, 0, 0); } // Return to normal Operation
                        } } 
                         
        
            // ROLL
            if(ID == 1  &&  value == 0) { // Horizontal Buttons
                
                            EXTRA[V][1] =! EXTRA[V][1]; // Toggle Roll-Status
                            if( EXTRA[V][1] > 0 )  { BLM_LED(1, V, 0, 2); } // GREEN Color RollButtons as Momentarys
                            else                   { BLM_LED(1, V, 0, 0); } // Deactivate LED
                
                                    if(EXTRA[V][1] == 0) { int y; for( y=0; y<16; y++ ) { MtxLoad[y][V]=MATRIX[Roll_Load_MTX][y][V]; } } // Overwrite temporar Roll
                                    else                 { int y; for( y=0; y<16; y++ ) { MtxLoad[y][V]=MATRIX[MtxPartNr][y][V]; } } // Change to orginal Routing
                    
                                }
    }


    if( MatrixUse == 5 ) { // Launch-Mode - STORE

    
                                    
    if(ID == 0  &&  value == 0)  {  // Matrix
        
        // Sense for new active song = TRIGGERMATRIX
        if ( V == 15)                   { main_song       = H + (launch_page*16);
                                          SD(4,H + (launch_page*16),2);  // Store 2 SD
                                          last_used_item = 5; } // notify that TM was last Launched 

        // Sense for new active drum-sequence
        if ( V >= 10  &&  V <= 13 )     {   tm.seq_variation   = V-10;
                                            seq_song        = H + (launch_page*16);
                                            SD(tm.seq_variation, H + (launch_page*16), 2);  // Store 2 SD
                                            last_used_item = 4; } // notify that DRUM was last Launched 
                                            
        // Sense for new active melody-sequence
        if ( V >= 0  &&  V <= 1 )       {   melo_variation[0]  = V;     melo_song[0]    = H + (launch_page*16); last_used_item = 0; }
        if ( V >= 2  &&  V <= 3 )       {   melo_variation[1]  = V-2;   melo_song[1]    = H + (launch_page*16); last_used_item = 1; }
        if ( V >= 4  &&  V <= 5 )       {   melo_variation[2]  = V-4;   melo_song[2]    = H + (launch_page*16); last_used_item = 2; }
        if ( V >= 6  &&  V <= 7 )       {   melo_variation[3]  = V-6;   melo_song[3]    = H + (launch_page*16); last_used_item = 3; }
        }
    if(value == 1) {MatrixUse = 5; Router(5, 0, 0, 0); } // Return to normal Operation
}
}

                                    
    
void APP_Tick(void){} // @ mS rate, from main task which also handles DIN, ENC and AIN events.  dont do more than 300uS!        


void APP_MIDI_NotifyPackage( mios32_midi_port_t port, mios32_midi_package_t midi_package ){
       
    switch ( port ) {
        
        case Port_IN_Clock: // Forward Clock, Transport & ProgramChange
        
                if(midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252) {
                        if(Port_THRU_Clock[0] == 1 )   { MIOS32_MIDI_SendPackage(32,  midi_package); } // 248CLK,250Strt,251Cont,252Stp
                        if(Port_THRU_Clock[1] == 1 )   { MIOS32_MIDI_SendPackage(33,  midi_package); }
                        if(Port_THRU_Clock[2] == 1 )   { MIOS32_MIDI_SendPackage(34,  midi_package); }
                        if(Port_THRU_Clock[3] == 1 )   { MIOS32_MIDI_SendPackage(35,  midi_package); }   }  
    
        
                // Set MidiChannel && Programchange-Channel     set Song Nr with Programchange Nr    setLoadProgram     LOAD command
                switch( CH_IN_PC ) {
                    case 0:  if( midi_package.evnt0 == 192 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 1:  if( midi_package.evnt0 == 193 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 2:  if( midi_package.evnt0 == 194 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 3:  if( midi_package.evnt0 == 195 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 4:  if( midi_package.evnt0 == 196 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 5:  if( midi_package.evnt0 == 197 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 6:  if( midi_package.evnt0 == 198 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 7:  if( midi_package.evnt0 == 199 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 8:  if( midi_package.evnt0 == 200 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 9:  if( midi_package.evnt0 == 201 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 10: if( midi_package.evnt0 == 202 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 11: if( midi_package.evnt0 == 203 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 12: if( midi_package.evnt0 == 204 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 13: if( midi_package.evnt0 == 205 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 14: if( midi_package.evnt0 == 206 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;
                    case 15: if( midi_package.evnt0 == 207 )  {SongNrLoad = midi_package.evnt1;  flag.PCLoad = 1;} break;}
                
    

        case Port_IN_Poly: // PB, NOTE, CC ///////////////////////////////////////////////////////////////////////////////////////////
            
            // Pitchbend s16bit Value Calculation ///////////////////////////////////////////////////////
            if(midi_package.type == PitchBend) {      u16 msb = midi_package.evnt2 << 7;
                                                      pitchbend[midi_package.chn] = midi_package.evnt1 + msb;}
    
            static u8 track = 0;
            static u8 chann = 0;
            for ( track=0; track < 16; track++ ) {
            for ( chann=0; chann <  6; chann++ ) {
                //    HOLD NOTES Button                            Melody Routing:  Channel-IN > Channel-OUT
                if( ( CCMtx[6][track] == 0 )  &&  ( midi_package.chn == CH_IN_Melo[chann]   &&  CCMtx[chann][track] == 1 )   ) {
                        // MIOS32_MIDI_SendDebugMessage("track:%d  chann:%d  midich:%d", track, chann, midi_package.chn);

                        //////////////////////////////////////////////////////////////////////////////////
                        // NOTEs /////////////////////////////////////////////////////////////////////////
                        ////////////////////////////////////////////////////////////////////////////////// 
                        if( (midi_package.type == NoteOn  &&  midi_package.velocity  < 1) || (midi_package.type == NoteOff)) { Note_Buffer(track, 0, midi_package.note);}
                        if(  midi_package.type == NoteOn  &&  midi_package.velocity >= 1)                                    { Note_Buffer(track, 1, midi_package.note);}
                                                      
                        ////////////////////////////////////////////////////////////////
                        // Control Change //////////////////////////////////////////////
                        ////////////////////////////////////////////////////////////////
                        if(  (Port_THRU_CC[track] ==  1 )   &&   (midi_package.type == CC )  ) { 
                                if(track <= 4) { MIOS32_MIDI_SendCC(Port_OUT_Poly, CH_OUT_Melo[track], midi_package.evnt1, midi_package.evnt2); }
                                if(track >  4) { MIOS32_MIDI_SendCC(Port_OUT_Mono, CH_OUT_Melo[track], midi_package.evnt1, midi_package.evnt2); }}

                                } } }
                    break;
    
      } // Switch Ports /////////////////////////////////////////////////////////////////////////////////////////////////////////////
} // End Hook


void APP_SRIO_ServicePrepare(void)  {
    
    BLM_SCALAR_PrepareCol();
    
    // SCAN J10 GPIO Inputs
    static u8 count = 0; 
    for(count = 0; count < 8; count++) { // reduce rate
    
        if(count == 0) {
            static u8 x = 0;    for(x=0; x<8; x++) {
                
            if(MIOS32_BOARD_J10_PinGet(x) != flag.j10PinState[x]) { // get GPIO-Pins

                //MIOS32_MIDI_SendDebugMessage("pin: %d value: %d", x, MIOS32_BOARD_J10_PinGet(x));
                
                // Toggle State
                flag.j10PinState[x] = MIOS32_BOARD_J10_PinGet(x);

                switch (x) { // Set Variables
                    case 2: VeloKill[0] = flag.j10PinState[x]; break;
                    case 5: VeloKill[1] = flag.j10PinState[x]; break;
                    case 4: VeloKill[2] = flag.j10PinState[x]; break;
                                  //VeloInvert  = flag.j10PinState[x]; break; 

                    case 1: PolyROLL    = flag.j10PinState[x]; break;
                    case 0: MonoROLL    = flag.j10PinState[x]; break;
                    case 3: TrigROLL    = flag.j10PinState[x]; break;
                    
                    case 7: APP_DIN_NotifyToggle(99, flag.j10PinState[x]); break;  // copy

                    case 6: APP_DIN_NotifyToggle(100, flag.j10PinState[x]);break;  // paste
              } } } } }


  // get current J5 value and update all encoder states
    int enc;
    u16 state = MIOS32_BOARD_J10B_Get();
    for(enc=0; enc<4; ++enc) {
    MIOS32_ENC_StateSet(enc, state & 3); // two pins
    state >>= 2; // shift to next two pins
    }

}

 
void APP_SRIO_ServiceFinish(void)   {  BLM_SCALAR_GetRow();  }     // call BLM_GetRow function after scan is finished to get DIN values
      
void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){
//MIOS32_MIDI_SendDebugMessage("pin:%d pin_value:%d", pin, pin_value);

if(pin_value == 0) { // only Pressed stastes
    if( MatrixUse == 0 ) { // Sequencer-Mode STEP+TIC+SWING
                        // COPY
                        if( pin == 99)   {          { int y; for(y=0; y<18; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)
                            
                                                        seqMATRIXcopy[y][x]  =  Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))]; 
                                                        SeqTicCopy[y][x]     =  SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))]; } } }
                        // PASTE
                        if( pin == 100)  {          { int y; for(y=0; y<18; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)
                                                                      
                                                        Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))]    = seqMATRIXcopy[y][x];
                                                        SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = SeqTicCopy[y][x];   } }
                                                        Router(5,0,0,0);} // Update Matrix
         
                        // CLEAR
                        if( pin == 101)   {         { int y; for(y=0; y<18; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)

                                                        Seq[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))]    = 0;         
                                                        SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0; } }
                                                        Router(5,0,0,0);} // Update Matrix
                        }

    if( MatrixUse == 1 ) { // Sequencer-Mode TIC only
                        // COPY
                        if( pin == 99)   {          { int y; for(y=0; y<16; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)

                                                        SeqTicCopy[y][x]     =  SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))]; } } }
                        // PASTE
                        if( pin == 100)  {          { int y; for(y=0; y<16; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)
                                                                      
                                                        SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = SeqTicCopy[y][x];   } }
                                                        Router(5,0,0,0);} // Update Matrix
         
                        // CLEAR
                        if( pin == 101)   {         { int y; for(y=0; y<16; y++)
                                                    { int x; for(x=0; x<(beat.PAGE_Steps); x++)
    
                                                        SeqTic[y][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0; } }
                                                        Router(5,0,0,0);} // Update Matrix
                        }

    if( MatrixUse == 2 ) { // Sequencer-Mode SWING only

                        // COPY
                        if( pin == 99)  {           int x; for(x=0; x<(beat.PAGE_Steps); x++) {
                                                        
                                                        seqMATRIXcopy[16][x]  =  Seq[16][x+(beat.PAGE_actual*(beat.PAGE_Steps))];
                                                        seqMATRIXcopy[17][x]  =  Seq[17][x+(beat.PAGE_actual*(beat.PAGE_Steps))]; } }
                                                        
                        // PASTE
                        if( pin == 100) {           int x; for(x=0; x<(beat.PAGE_Steps); x++) {
                                                        
                                                        Seq[16][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = seqMATRIXcopy[16][x];
                                                        Seq[17][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = seqMATRIXcopy[17][x]; }
                                                        Router(5,0,0,0); } // Update Matrix
         
                        // CLEAR
                        if( pin == 101) {           int x; for(x=0; x<(beat.PAGE_Steps); x++) {

                                                        Seq[16][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0;
                                                        Seq[16][x+(beat.PAGE_actual*(beat.PAGE_Steps))] = 0;}
                                                        Router(5,0,0,0);} // Update Matrix
                        }
             
    if( MatrixUse == 3 ) { // Router-Mode
                        
                        // COPY
                        if( pin == 99)          {   memcpy(MATRIXcpy,  MATRIX[MtxPartNr],  sizeof MATRIX[MtxPartNr]); }
                        
                        // PASTE
                        if( pin == 100)         {   memcpy(MATRIX[MtxPartNr],  MATRIXcpy,  sizeof MATRIXcpy);
                                                    memcpy(MtxLoad,            MATRIXcpy,  sizeof MATRIXcpy);}
                        
                        // CLEAR
                        if( pin == 101)         {   memset(MATRIX[MtxPartNr], 0, sizeof MATRIX[MtxPartNr]);
                                                    memset(MtxLoad,           0, sizeof MtxLoad); }
                        // Return to normal Operation
                        MatrixUse = 3; Router(5, 0, 0, 0); } //  RECALL

    if( MatrixUse == 5 ) { // Launch - Mode
        
                        // copy last selected Matrix-ITEM into his CPY-BUFFER - last selected: last_used_item 
                        if( pin == 99)  { 
                            
                                if( last_used_item == 4) {  memcpy(Seq_copy_all, Seq,    sizeof (Seq_copy_all) );     // copy beat 2 buffer
                                                            memcpy(&beat_cpy,    &beat,  sizeof (store_t) );      }   // beat info
                                                            
                                if( last_used_item == 5) {  memcpy(MATRIXcpyALL, MATRIX, sizeof (MATRIXcpyALL) ); } } // router matrix

                        
                        // Store/paste from Buffer into running Program/Preset
                        if( pin == 100)          {

                                if( last_used_item == 4) {  memcpy(Seq,     Seq_copy_all,   sizeof (Seq) );   // copy beat 2 buffer
                                                            memcpy(&beat,   &beat_cpy,      sizeof (store_t) );  // beat info
                                                            SD(tm.seq_variation,seq_song,2); }  // Store 2 CARD, Actual Sequencer Variation 0,1,2 or 3
                                                            
                                if( last_used_item == 5) {  memcpy(MATRIX,  MATRIXcpyALL,   sizeof (MATRIX) );// router matrix
                                                            SD(4,main_song,2); } } // Store 2 CARD, TriggerMatrix aka Main_Song
                        }
}
}
                                



void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){
        if(flag.shiftvalue == 1) {   // if Shift-Button is Un-Pressed
                if(encoder == 3 ) { Router(7, 0, 0, incrementer); }  // route -1 or +1 values to UI-Router
        }
        
        else {                      // if Shift-Button is Pressed
                if(encoder == 3 ) { MatrixUse = MatrixUse + incrementer;
                                    if(MatrixUse < 0) { MatrixUse = 5; }
                                    if(MatrixUse > 5) { MatrixUse = 0; }
                                    Router(5,0,0,0); } // Update BLM 
                    }  // route -1 or +1 values to UI-Router
        } 
 
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){ //AIN - - Potentiometer has mooved - - Analog InPut
    
    u8 value_7bit = pin_value >> 5;

    
    if(pin == 0) { Fullvelo   = value_7bit;
                   if(Fullvelo < 1) { Fullvelo = 1; } }

    
    if(pin == 1) { // Calculate DECAY-TIME

            // scale CC-Value 0-127 > 127-0
            s16 InvCalc = value_7bit - 127;    //30-127 = -97
            s16 inv     = InvCalc    *  -1;
            if(inv <= 4)  {inv = 4;}
      else if(inv > 127)  {inv = 127;}
            DECAY_Melo = inv;  //-97*-1 =  97
    
            u32 th32time = 0;  
            th32time = 60000/beat.bpm ;
            th32time = th32time * 100;  
    
            DECAY = (th32time / DECAY_Melo) / 10;}


    if(pin == 2) { // calculate Velocity dependend Trigger Gate

        s16 add = (value_7bit/2) - 32;
        
                    vel[0] = 48 + add;
                    vel[1] = 80 + add;
                    //MIOS32_MIDI_SendDebugMessage("cc:%d, add:%d, %d %d", value_7bit, add, vel[0], vel[1]);
                    }


    if(pin == 3) {  // caluclate Velocity Offset (Velo+/-)
                    VELO_Offset = (value_7bit - 48)/2;
//MIOS32_MIDI_SendDebugMessage("cc:%d, vel_mono:%d, 32:%d 48:%d 90:%d 127:%d", value_7bit, VELO_Offset, 32+VELO_Offset,64+VELO_Offset,90+VELO_Offset,127+VELO_Offset);
                }

    if(pin == 4) {  static s8 inv; // invert AIN-Value 0-127 to 127-0
                    inv = (value_7bit - 127) * -1;
        ROLL_Variation = inv/16;  // 0-127   128CC / 8 Routings = 16cc Values Range
        ROLL_Variation_change = inv%16;}

    if(pin == 5) { KILL_Trig = value_7bit; }
                            
    if(pin == 6) { KILL_Mono = value_7bit; }
    
    if(pin == 7) { KILL_Melo = value_7bit; }
}


static void TASK_SEQ(void *pvParameters){ //@ ms rate
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}


/////////////////////////////////////////////////////////////////////////////
// SEQ - Midi-CLOCK - IN  >>>  Installed via MIOS32_MIDI_DirectRxCallback_Init
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-beat.bpm
if(port == Port_IN_Clock) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}


u8 Trigger_Matrix(u8 port, u8 note, u8 velocity, u16 step, u16 tic){

  // SWING   &   TIC STUFF
  // write the SeqTicsMatrix according to the played step, into a smaller  Array... and in Benefit we can make a TIC-OFFSET!
  int y; for(y=0; y<16; ++y){
      if(Seq[16][step] == 0  || beat.SWING_Switch == 0) { SeqTicDelay[y] = SeqTic[y][step]; }            //A  NOT swinged Step
      if(Seq[16][step] == 1  && beat.SWING_Switch == 1) { SeqTicDelay[y] = SeqTic[y][step] + Seq[17][step] + beat.SWING_32th; }  //A 16th swinged Step
      if(Seq[16][step] == 2  && beat.SWING_Switch == 1) { SeqTicDelay[y] = SeqTic[y][step] + Seq[17][step] + beat.SWING_16th;  }  //A 16th swinged Step
   // if SwingIsActive = ON  && SwingActiveSwitch is ON {TIC-Delay = Programmed Tic  + SwingAmmount  + SwingRotaryAmmount
    }

// NOTE + VELOCTIY 
u8 track; for( track=0; track<16; track++ ) {        // Count-thru-Tracks [0] [1] [2] [3] [4]


// Pitchbend
    // reduce Midi-Traffic  // 505 timing critical  -- -maybe only every 2nd or 4th tic?
        if(  PitchbendPWR[track] == 1   &&  tic == 20) {
                    if(track <= 4) { MIOS32_MIDI_SendPitchBend(Port_OUT_Poly, CH_OUT_Melo[track], pitchbend[track]); }   // SEND Pitchbend(port,chn, u16 val)
                    if(track >  4) { MIOS32_MIDI_SendPitchBend(Port_OUT_Mono, CH_OUT_Melo[track], pitchbend[track]); }}  // SEND Pitchbend(port,chn, u16 val)

////////////////////////////////////////////////////////////////////                                   
//Retrigger
   if(
      ( ((CCMtx[15][track]==1) && (AnySolo==0)) || (CCMtx[14][track]==1)) // Track-Active-Switch=ON  &  any other Solo=OFF  OR  this-Track-SOLO=ON
    &&  (
            ((MtxLoad[0] [track] == 1)  &&  (Seq[0] [step] > 0)  &&  (SeqTicDelay[0]  == tic))  || //a router cell active?  &&  any Note in Sequencer Step? Right Tic?
            ((MtxLoad[1] [track] == 1)  &&  (Seq[1] [step] > 0)  &&  (SeqTicDelay[1]  == tic))  ||
            ((MtxLoad[2] [track] == 1)  &&  (Seq[2] [step] > 0)  &&  (SeqTicDelay[2]  == tic))  ||
            ((MtxLoad[3] [track] == 1)  &&  (Seq[3] [step] > 0)  &&  (SeqTicDelay[3]  == tic))  ||
            ((MtxLoad[4] [track] == 1)  &&  (Seq[4] [step] > 0)  &&  (SeqTicDelay[4]  == tic))  ||
            ((MtxLoad[5] [track] == 1)  &&  (Seq[5] [step] > 0)  &&  (SeqTicDelay[5]  == tic))  ||
            ((MtxLoad[6] [track] == 1)  &&  (Seq[6] [step] > 0)  &&  (SeqTicDelay[6]  == tic))  ||
            ((MtxLoad[7] [track] == 1)  &&  (Seq[7] [step] > 0)  &&  (SeqTicDelay[7]  == tic))  ||
            ((MtxLoad[8] [track] == 1)  &&  (Seq[8] [step] > 0)  &&  (SeqTicDelay[8]  == tic))  ||
            ((MtxLoad[9] [track] == 1)  &&  (Seq[9] [step] > 0)  &&  (SeqTicDelay[9]  == tic))  ||
            ((MtxLoad[10][track] == 1)  &&  (Seq[10][step] > 0)  &&  (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][track] == 1)  &&  (Seq[11][step] > 0)  &&  (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][track] == 1)  &&  (Seq[12][step] > 0)  &&  (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][track] == 1)  &&  (Seq[13][step] > 0)  &&  (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][track] == 1)  &&  (Seq[14][step] > 0)  &&  (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][track] == 1)  &&  (Seq[15][step] > 0)  &&  (SeqTicDelay[15] == tic)))
        )

     {  static s16 velo = 0;   // calculate Velocity for 16 output channels
         
        //want to hear highest velocity? get it! (since we use multiple triggers)
          if(CCMtx[12][track]==1) { // MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][track]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo = maximum;}

        // want to hear lowest velocity? get it! (since we use multiple triggers)
        if(CCMtx[12][track]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][track]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo = minimum;}


        // Kill Velocity-Ranges
        if( ( (velo <  vel[0])  &&                               (VeloKill[0] == 0)) ||
          ( ( (velo >= vel[0])  && (velo < vel[1])) &&    (VeloKill[1] == 0)) ||
          (   (velo >= vel[1])  &&                               (VeloKill[2] == 0))) { // Velocity Kill Switches                 

                // velocity + velocity offset
                velo = velo + VELO_Offset; 
                if(velo <=  2)  {velo = 2;}
                if(velo > 127)  {velo = 127;}      
        
                // velocity invert
                if(VeloInvert == 1) {    // VeloInvert = Velocity Invert Button
                        s16 VelInvCalc;  // to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
                        s16 inv;
                        VelInvCalc = velo-127;    //30-127 = -97
                        inv = VelInvCalc*-1;
                                 if(inv <= 0)  {inv =   1;}
                            else if(inv > 127) {inv = 127;}
                        velo   = inv; } //-97*-1 =  97
        
    
                //Send Trigger NoteOut
                if( (TrigRandGate==1 || CCMtx[13][track]==0) // CCMtx[13][x] = Does Random Kill have Effect?
                 && (DECAY_Timer_Trigger[track] < 1) )              // only if THIS NOTE isnt already Playing
                            { MIOS32_MIDI_SendNoteOn (Port_OUT_Trig, CH_OUT_Trig[track], TrigOutNote[track], velo); // Send Note-ON
                              DECAY_Timer_Trigger[track]=DECAY;     // set new Trigger and Indicator DECAY-Time

                              //send BLM LEDs >Trigger Indicator<
                              if( MatrixUse == 3 || MatrixUse == 4 ) {
                                    // Set  Trigger Indicate LED Color (velocity depending)
                                    int Color = 1;
                                    if(velo <= 44)                       {Color = 1;}
                                    if(velo >  44 && velo <= 89)  {Color = 2;}
                                    if(velo >  89)                       {Color = 3;}
                                    BLM_LED(1, track, 0,   Color);} //(blm, id, x, y, color)
                            }
                              
                if(track < 5) { // send Poly Melody NoteOut
                if(MeloRandGate==1 || CCMtx[13][track]==0) {   //CCMtx[13][x] = Does Random Kill have Effect?
                    
                      int note=0;	for(note=0; note<8; note++) {			
                            if(  ( tm.NoteBuff[track][note] < 127 )  // 127 = no note!
                            &&   ( DECAY_Timer_Melo[track][tm.NoteBuff[track][note]] == 0 ) )// only if THIS NOTE isnt already Playing
                              
                                         { MIOS32_MIDI_SendNoteOn(Port_OUT_Poly, CH_OUT_Melo[track], tm.NoteBuff[track][note], velo); 
                                           DECAY_Timer_Melo[track][tm.NoteBuff[track][note]] = DECAY;
//if(track == 0) {  MIOS32_MIDI_SendDebugMessage("DECAY: %d: TIMER %d:", DECAY, DECAY_Timer_Trigger[0]);}


                                           } } } }
                
                if(track > 4) { // send Mono Melody NoteOut
                    static  u8  MeloOutNote[16] ={};            // to calc Lowest/Highest Note
                    
                    // highest Melody Note:
                    if(CCMtx[11][track] != 0) { //MATRIX = SWITCH "HIGHEST NOTE"
                            MeloOutNote[track]=0;
                            int note; 
                            for (note=0; note<8; note++) { 
                                  if ( ( tm.NoteBuff[track][note] > MeloOutNote[track]) // only if note is higher
                                  && (   tm.NoteBuff[track][note] < 127 )) // 127 = no note (empty Note-Chord-Buffer)
                                  { 
                                         MeloOutNote[track] = tm.NoteBuff[track][note];}}} // = HIGHEST NOTE

                    // lowest Melody Note:
                    if(CCMtx[11][track] == 0) { // MATRIX = SWITCH "LOWEST NOTE"
                            MeloOutNote[track]=127; int note; 
                            for (note=0; note<8; note++) { 
                                  if ( ( tm.NoteBuff[track][note] < MeloOutNote[track] )   // only if note is lower
                                  && (   tm.NoteBuff[track][note] < 126 )                  // 127 = no note (empty Note-Chord-Buffer)
                                  && (   tm.NoteBuff[track][note] > 0   )  )               // 0 = no note (empty Note-Chord-Buffer)
                                  { 
                                         MeloOutNote[track] = tm.NoteBuff[track][note];}}} // = LOWEST NOTE
                      //MIOS32_MIDI_SendDebugMessage("DECAY: %d:  TIMER %d:   NOTE: %d   TRACK: %d cctmx: %d", DECAY, DECAY_Timer_Melo[track][MeloOutNote[track]], MeloOutNote[track], track, CCMtx[11][track]);
                    // send NoteOut		
                    if(( MeloOutNote[track] < 126  &&  MeloOutNote[track] > 0 )                           // 127 is no note, so only NOTE-ONs!
                    && ( MonoRandGate == 1 || CCMtx[13][track] == 0 )      // CCMtx[13][x] = Does Random Kill have Effect? 
                    && ( DECAY_Timer_Melo[track] [MeloOutNote[track]] == 0 ) ) // only if THIS NOTE isnt already Playing
                    {  
                         MIOS32_MIDI_SendNoteOn(Port_OUT_Mono, CH_OUT_Melo[track], MeloOutNote[track], velo); 
                         DECAY_Timer_Melo[track][MeloOutNote[track]] = DECAY; }
                    } 
 } }}


    // Indicate "Trigger-Input-LEDS" (via Vertical Xtra Buttons aka "Router-Preset-Btns"
    if( MatrixUse == 3 ) {    // are we in TriggerMatrix-mode?
        if(port == 0 && tic == 10) {             // StepSequencer Input && 6th tic of step>avoid double trigger and make place for NoteCalculation @Tic=0
          int x; for(x=0; x<16; x++) {
            if(Seq[x][step]  > 0) {
              //Get Color
              int Color = 1;
              if(Seq[x][step] <=44) {Color = 1;}
              if(Seq[x][step] >=44 && Seq[x][step] <= 89) {Color = 2;}
              if(Seq[x][step] >=90) {Color = 3;}
              BLM_LED(2, 0, x, Color);}}}   // Activate ActiveSteps - Trigger LEDs 

    //De-Activate "Trigger-LEDS" 
        if(port == 0 && tic == 30) {        // StepSequencer Input && 12th tic of step>avoid double trigger and make place for NoteCalculation @Tic=0
            int x; for(x=0; x<16; x++) {    // TRIG_LED - DE-ACTIVATE
                                         BLM_LED(2, 0, x, 0);   } 
            // Activate MtxPartNr Again
            BLM_LED(2, 0, MtxPartNr,   2); } }


            

// Trigger - LED - Deactivate after a few Tics
if( tic == 20) {
if( MatrixUse == 3  || MatrixUse == 4) {
int v = 0; for ( v = 0; v < 16; v++ )  { // SEQ__LED - DE-ACTIVATE
    if(EXTRA[v][1] == 0) { BLM_LED(1, v, 0, 2); }     // Make Green instead "OFF"   (id, v, y, colour) 
    else                 { BLM_LED(1, v, 0, 0); }}}   // Make "OFF"     TOff BLM-Trigger-Indicaters                                        
}

  return 0; // no error,
}



// S T O R A G E - SD - C A R D      ///        // read write clips/programchanges
void SD(u8 track, u16 clip, u16 job){           // Job1=load, Job2=store, Job3=initalize card
    int x = 0; // put out matrix data FOR loop...
    int y = 0; // put out matrix data FOR loop...

    const static char file_type[4] = "tm03";    // definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header
    static char file_path[16] =  {};            // STORE-path - Number of Pathsymbols tm/512.tm    
    static s8 statusSD;			                // Status of the SDCard--connected? fat?
    static s8 statusDir;			            // Status "is" your direction "sdcard/t" there?
    static file_t midifile_fi;                  // used to read files from SD-Card
    static     // SD Operation Display (store, load, init, status...)
    const u8 SDMTX[7][16][16] = {
     
    //// SDMTX[0]: SD . . . . Init  ////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
	 {2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //  
	 {0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,2,0,0,2,0,2,0,2,0,2,0}, //
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {2,0,2,0,0,0,2,0,2,0,2,2,2,0,0,0}, //
     {2,0,2,2,0,0,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,2,0,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,0,2,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,0,0,2,0,2,0,0,2,0,0,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[1]:  SD OK////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
	 {2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //  
	 {0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,2,2,2,0,2,0,0,2,0}, //
     {0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,0}, //
     {0,0,0,0,0,0,0,2,0,2,0,2,2,0,0,0}, //
     {0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,0}, //
     {0,0,0,0,0,0,0,2,2,2,0,2,0,0,2,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[2]:  SD NO!////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
	 {2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //  
	 {0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,3,0,0,0,3,0,3,3,3,0,3,0,0}, //
     {0,0,0,3,3,0,0,3,0,3,0,3,0,3,0,0}, //
     {0,0,0,3,0,3,0,3,0,3,0,3,0,3,0,0}, //
     {0,0,0,3,0,0,3,3,0,3,0,3,0,0,0,0}, //
     {0,0,0,3,0,0,0,3,0,3,3,3,0,3,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[3]:  SD FAT?////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
	 {2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //  
	 {0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0}, //
	 {2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0}, //
     {0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0}, 
     {3,3,3,0,3,0,3,3,3,0,3,3,3,0,0,0}, //
     {3,0,0,3,0,3,0,3,0,0,3,0,0,0,0,0}, //
     {3,3,0,3,3,3,0,3,0,0,3,3,3,0,0,0}, //
     {3,0,0,3,0,3,0,3,0,0,0,0,0,0,0,0}, //
     {3,0,0,3,0,3,0,3,0,0,0,3,0,0,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[4]:  INit Finished////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {2,0,2,0,0,0,2,0,2,0,2,2,2,0,0,0}, //
     {2,0,2,2,0,0,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,2,0,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,0,2,2,0,2,0,0,2,0,0,0,0}, //
     {2,0,2,0,0,0,2,0,2,0,0,2,0,0,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {3,3,3,0,3,0,3,0,0,0,3,0,3,3,3,0}, //
     {3,0,0,0,3,0,3,3,0,0,3,0,3,0,0,0}, //
     {3,3,0,0,3,0,3,0,3,0,3,0,3,3,0,0}, //
     {3,0,0,0,3,0,3,0,0,3,3,0,3,0,0,0}, //
     {3,0,0,0,3,0,3,0,0,0,3,0,3,3,3,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[5]:  ////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {3,0,0,0,3,3,3,0,0,3,0,0,3,3,0,0}, //9
     {3,0,0,0,3,0,3,0,3,0,3,0,3,0,3,0}, //10
     {3,0,0,0,3,0,3,0,3,3,3,0,3,0,3,0}, //11 LOAD
     {3,0,0,0,3,0,3,0,3,0,3,0,3,0,3,0}, //12
     {3,3,3,0,3,3,3,0,3,0,3,0,3,3,0,0}, //13
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,3,0,3,3,3,0,3,3,3,0,0,0,0,0,0}, //
     {0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,3,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,3,3,0,0,3,0,0,0,0,0,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    //// SDMTX[6]:  ////
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0}, //2
	 {3,0,0,0,0,3,0,0,3,0,3,0,3,0,3,0}, //3
	 {3,3,3,0,0,3,0,0,3,0,3,0,3,3,0,0}, //4  STORE 
	 {0,0,3,0,0,3,0,0,3,0,3,0,3,0,3,0}, //5
	 {3,3,3,0,0,3,0,0,3,3,3,0,3,0,3,0}, //6
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
     {0,3,0,3,3,3,0,3,3,3,0,0,0,0,0,0}, //
     {0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,3,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0}, //
     {0,0,0,3,3,3,0,0,3,0,0,0,0,0,0,0}, // 
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}
    };


                             
    switch(job) {   
 
// R E A D /////////////////////////////////////////////////////////////////////////////////////////////////////// 
          
            case 1:
                    if(track < 4) { // L O A D Clip
                
                        MUTEX_SDCARD_TAKE;  
                            sprintf         ( file_path, "tm/%d-%d.tm", track, clip );
                            FILE_ReadOpen   ( &midifile_fi, file_path );
                            FILE_ReadBuffer ( (u8 *)&file_type, 4 ); 
                            FILE_ReadBuffer ( (u8 *)&beat,      sizeof(store_t) );
                            FILE_ReadBuffer ( (u8 *)&Seq,       sizeof(Seq) );
                            FILE_ReadBuffer ( (u8 *)&SeqTic,    sizeof(SeqTic) );                                                       
                            FILE_ReadClose  ( &midifile_fi );
                        MUTEX_SDCARD_GIVE;      
                        
                        //Calculate new Loop Lengths
                        //Loop[track]         = loop[track].length * MainLoop;
    
                        //SEQ_BPM_Set(loop[c].bpm);
                        flag.NeedSync = 1; //update ClockCounter when ready...
               
                        flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                    break;}


                    if(track == 4)  {   // L O A D Trigger Matrix
                        MUTEX_SDCARD_TAKE;  
                            sprintf         ( file_path, "tm/tm-%d.tm", clip );
                            FILE_ReadOpen   ( &midifile_fi, file_path );
                            FILE_ReadBuffer ( (u8 *)&file_type, 4 ); 
                            FILE_ReadBuffer ( (u8 *)&MATRIX,    sizeof(MATRIX) );
                            FILE_ReadBuffer ( (u8 *)&CCMtx,     sizeof(CCMtx) );
                            FILE_ReadBuffer ( (u8 *)&tm,        sizeof(triggermatrix_t) );                                                  
                            FILE_ReadClose  ( &midifile_fi );
                        MUTEX_SDCARD_GIVE;      

                        flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds



      //Send Program Change 4 Melody Parts 0-16							
	  int l; for(l=0; l<16; ++l) {
			MIOS32_MIDI_SendCC           (Port_OUT_Poly, CH_OUT_Melo[l], 32, PCBank[l]);	  //PC-Bank   //Send-out-Program-Change CC32        
		    MIOS32_MIDI_SendProgramChange(Port_OUT_Poly, CH_OUT_Melo[l], main_song);}    //PC

	  //Send Program Change 4 Trigger-Part
	  int i; for(i=6; i<15; ++i) {
			MIOS32_MIDI_SendCC           (Port_OUT_Trig, CH_OUT_Trig[i], 32, PCBank[16]);	  //PC-Bank   //Send-out-Program-Change CC32        
		    MIOS32_MIDI_SendProgramChange(Port_OUT_Trig, CH_OUT_Trig[i], main_song);}    //PC     	

	  //Send Program Change Mono-Part
			MIOS32_MIDI_SendCC           (Port_OUT_Mono, CH_OUT_Melo[6], 32, PCBank[6]);	  //PC-Bank   //Send-out-Program-Change CC32        
		    MIOS32_MIDI_SendProgramChange(Port_OUT_Mono, CH_OUT_Melo[6], main_song);  //PC
            
                    break;}
                	
                    
// S T O R E /////////////////////////////////////////////////////////////////////////////////////////////////////               
  
            case 2:
                    if(track < 4) { // S T O R E Clip
                        
                        MUTEX_SDCARD_TAKE;
                                //Write to File
                                sprintf(file_path, "tm/%d-%d.tm", track, clip);             
                                FILE_WriteOpen	( file_path,          16 );   
                                FILE_WriteBuffer( (u8  *)&file_type,   4 ); //"SIGL" = 4 Positons                                                     
                                FILE_WriteBuffer( (u8  *)&beat,     sizeof(store_t) );
                                FILE_WriteBuffer( (u8  *)&Seq,      sizeof(Seq) );
                                FILE_WriteBuffer( (u8  *)&SeqTic,   sizeof(SeqTic) );                                                               
                                FILE_WriteClose	(); 
                        MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                        
                        SongNrLoad = SongNrStor; //transfair load nr 2 store nr.

                        flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                    break;}


                    if(track == 4)  {   // S T O R E Trigger Matrix
                        
                        MUTEX_SDCARD_TAKE;
                                //Write to File
                                sprintf(file_path, "tm/tm-%d.tm", clip);             
                                FILE_WriteOpen	( file_path,          16 );   
                                FILE_WriteBuffer( (u8  *)&file_type,   4 ); //"SIGL" = 4 Positons                                                     
                                FILE_WriteBuffer( (u8  *)&MATRIX,   sizeof(MATRIX) );
                                FILE_WriteBuffer( (u8  *)&CCMtx,    sizeof(CCMtx) );
                                FILE_WriteBuffer( (u8  *)&tm,       sizeof(triggermatrix_t) );                                                                 
                                FILE_WriteClose	(); 
                        MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                        
                        SongNrLoad = SongNrStor; //transfair load nr 2 store nr.

                        flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                    break;}
                    

//  I N I T - S D - CARD //////////////////////////////////////////////////////////////////////////////////7//////   
  // THIS WILL TAKE 10minutes//
            case 3: //SD-Card Initalize
                    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
                      statusSD = FILE_CheckSDCard();
                      switch(statusSD) {
                          case 2:
                                    // send LED-Masks                                            
                                    for(y=0; y<16; y++)    {
                                    for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, SDMTX[2][y][x]);}}  // (id-element, x, y, color); // 2: NO CARD
                                            flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                            break;
                            
                          case 3:
                                    // send LED-Masks                                            
                                    for(y=0; y<16; y++)    {
                                    for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, SDMTX[3][y][x]);}}  // (id-element, x, y, color); // 3: FAT?
                                            flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                            break;
                            
                          case 1: // YES CARD!  >>> next: check Card-content
                             statusDir = FILE_DirExists("tm");	 // ask file.c: exist a folder "t/" on the CARD? // 
                             if (statusDir == 1){
                                    // send LED-Masks                                            
                                    int y;  for(y=0; y<16; y++)    {
                                    int x;  for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, SDMTX[1][y][x]);}}  // (id-element, x, y, color); // 1: SD OK
                                            flag.Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                                  break;} 
                             
                             if (statusDir == 0){
                                 
                                    // send LED-Masks                                            
                                    for(y=0; y<16; y++)    {
                                    for(x=0; x<16; x++)    {
                                            //Dump the whole ARRAY OUT!
                                            BLM_LED( 0, x, y, SDMTX[0][y][x]);}}  // (id-element, x, y, color); // 0: INIT
                                                      
                                
                                        FILE_MakeDir("tm");                           

                                        //C L I P > Write to File
                                        sprintf(file_path, "tm/%d-%d.tm", track, clip);             
                                        FILE_WriteOpen	(file_path,                   16 );               
                                                FILE_WriteBuffer( (u8  *)file_type,    4 ); //"tm04" = 4 Positons   
                                                FILE_WriteBuffer( (u8  *)&beat,     sizeof(store_t) );
                                                FILE_WriteBuffer( (u8  *)&Seq,      sizeof(Seq) );
                                                FILE_WriteBuffer( (u8  *)&SeqTic,   sizeof(SeqTic) ); 
                                        FILE_WriteClose	(); 
                                                            
                                            //copy-prototype file to 512x clip files on SD-Card
                                                u16 clipco;  // declare clip Counter 
                                                for(clipco = 0; clipco<256; clipco++){  //countes 2 511 and do following commandos 511 times in a loop:
                                                u8 trackco;
                                                for(trackco = 0; trackco<4; trackco++){ 
                                                    char copyfilepath[16];
                                                    sprintf   (copyfilepath, "tm/%d-%d.tm", trackco, clipco);  // make a new filename depending on the counter value 1.tm, 2.tm, 3.tm...511.tm
                                                    FILE_Copy ( (char *)"tm/0-0.tm", (char *)copyfilepath );}} // copy the File 0.tm to all other 511 files...

                                        //T R I G G E R M A T R I X > Write to File
                                        sprintf(file_path, "tm/tm-%d.tm", track, clip);             
                                        FILE_WriteOpen	(file_path,                   16 );               
                                                FILE_WriteBuffer( (u8  *)file_type,    4 ); //"tm04" = 4 Positons   
                                                FILE_WriteBuffer( (u8  *)&MATRIX,   sizeof(MATRIX) );
                                                FILE_WriteBuffer( (u8  *)&CCMtx,    sizeof(CCMtx) );
                                                FILE_WriteBuffer( (u8  *)&tm,       sizeof(triggermatrix_t) );
                                        FILE_WriteClose	(); 
                                                            
                                            //copy-prototype file to 512x triggermatrix files on SD-Card
                                                for(clipco = 1; clipco<256; clipco++){  //countes 1-511 and do following commandos 511 times in a loop:
                                                    char copyfilepath[16];
                                                    sprintf   (copyfilepath, "tm/tm-%d.tm", clipco);  // make a new filename depending on the counter value 1.tm, 2.tm, 3.tm...511.tm
                                                    FILE_Copy ( (char *)"tm/tm-0.tm", (char *)copyfilepath );} // copy the File 0.tm to all other 511 files...

                                        // send LED-Masks                                            
                                        for(y=0; y<16; y++)    {
                                        for(x=0; x<16; x++)    {
                                                //Dump the whole ARRAY OUT!
                                                BLM_LED( 0, x, y, SDMTX[4][y][x]);}}  // (id-element, x, y, color); // 4: init SD-Card

                                                flag.Update_LCD_s = 1; // normal menue after 3 seconds
                                
                                    break;} 
                        }
                        MUTEX_SDCARD_GIVE;	
                        }
}









// S T O R A G E - SD - C A R D - PORT OLD FILESYSTEM
void SD_PORTER(u8 track, u16 clip, u16 job){           // Job1=load, Job2=store, Job3=initalize card

    // all with 505 can be deletet after running

    static char file_path[16] =  {};            // STORE-path - Number of Pathsymbols tm/512.tm    

    static s8 statusDir;			            // Status "is" your direction "sdcard/t" there?
    static file_t midifile_fi;                  // used to read files from SD-Card

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// O L D   F I L E S Y S T E M   V A R I A B L E S
char oldfile_type[4] = "TM02";
char filepathL[8];
static char SongNameLoad[8]  = {32};
static u8 PCBank[17]={0,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0}; 
static s8 CCBank4[16][4] = {{}};
static u8 MtxFunction[16][16][16] = {{{}}};
static u8 oldMATRIX[17][16][16]={{{}}};
static u8 oldSeq[18][256] = {{}};
static u8 oldSeqTic[18][256] = {{}};
static u8 NoteBuff[16][10]= {{}};
static u8 CC_SD[128] = {};
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char file_type[4] = "TM03";

    // Check SD-Card Filystem
    MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("ol"); MUTEX_SDCARD_GIVE;
      
      if(statusDir != 1) {	MIOS32_MIDI_SendDebugMessage("cant see old Path ol/0.tm..."); }
      if(statusDir == 1) {  MIOS32_MIDI_SendDebugMessage("ol exist"); 
                            MIOS32_MIDI_SendDebugMessage("start preset transfair");

u16 preset; // count thru all Presets
for(preset = 0; preset < 128; preset++) {
    
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
// L O A D   O L D   F I L E S Y S T E M

		   sprintf(filepathL, "ol/%d.tm", preset);  // generate Filename
       MUTEX_SDCARD_TAKE;               
           FILE_ReadOpen	(&midifile_fi, filepathL);
           FILE_ReadBuffer	((u8  *)oldfile_type,   4); 	
           FILE_ReadBuffer	((u8  *)SongNameLoad,   8); 
           FILE_ReadBuffer	((u8  *)PCBank,        16);
           FILE_ReadBuffer	((u8  *)CCBank4,       64);  //16x4=64 Virtuel Encoders
           FILE_ReadBuffer	((u8  *)EXTRA,         32);  //2x16=32 BLM-X-Y-Extra-Buttons
           FILE_ReadBuffer	((u8  *)MtxFunction, 4096);  //16x16x16=4096 - Placeholder for Future updates
           FILE_ReadBuffer	((u8  *)oldMATRIX,   4352);  //16x16x17=4352  - Routing - Matrices
           FILE_ReadBuffer  ((u8  *)oldSeq,      4608);  //18x256  =4608 - Step-Sequencer-Matrix
           FILE_ReadBuffer  ((u8  *)oldSeqTic,   4608);  //18x256  =4608 - Step-Sequencer-TicOffset-Matrix 4 Seq[x][y]
           FILE_ReadBuffer  ((u8  *)NoteBuff,     160);  //16x10    =160   - MelodyRetriggerNoteBuffer (last played notes)
           FILE_ReadBuffer  ((u8  *)CC_SD,        128);  // ALL OTHER VARIABLES are saved in this ARRAY (CC_SD[128])
           FILE_ReadClose	(&midifile_fi);
        MUTEX_SDCARD_GIVE

           //Paste  Variables from Array
           beat.PAGE_loop[0]        =  CC_SD[4] * 2; // 32th spread
           beat.PAGE_loop[1]        = (CC_SD[5] * 2) + 1; // 32th spread
           beat.PAGE_actual         = (CC_SD[6] * 2);
           beat.PAGE_Steps          = CC_SD[7];
           beat.MainLoop            = CC_SD[12];
           beat.bpm                 = CC_SD[31];
           beat.rythm               = CC_SD[32];

    MIOS32_MIDI_SendDebugMessage("preset:%d %c%c%c%c%c%c%c%c",preset, SongNameLoad[0],SongNameLoad[1],SongNameLoad[2],SongNameLoad[3],
    SongNameLoad[4],SongNameLoad[5],SongNameLoad[6],SongNameLoad[7]);
               
    MIOS32_MIDI_SendDebugMessage("loop0:%d  loop1:%d  steps:%d  main:%d  bpm:%d  rythm:%d",
    beat.PAGE_loop[0], beat.PAGE_loop[1], beat.PAGE_Steps, beat.MainLoop,  beat.bpm, beat.rythm  );       

// old Matrix with 17 arrays to 16 arrays
u8 a; u8 b; u8 c;
for(a=0; a<16; a++) {
for(b=0; b<16; b++) {
for(c=0; c<16; c++) {    MATRIX[a][b][c]  = oldMATRIX[a][b][c];}}}

// translate old 16 th to new 32th --- spread by 2
u8 treck; u16 stepp;
for(treck =0; treck < 18;  treck++) {
for(stepp =0; stepp <128;  stepp++) {     if(stepp == 0) {    Seq[treck][stepp]    = oldSeq   [treck][stepp];
                                                           SeqTic[treck][stepp]    = oldSeqTic[treck][stepp]; }
                                                            
                                            else       {       Seq[treck][stepp * 2] =    oldSeq[treck][stepp];
                                                            SeqTic[treck][stepp * 2] = oldSeqTic[treck][stepp];}}}



// S T O R E   N E W  F I L E  S Y S T E M ////////////////////////////////////////////////////////////////////////               
            
    // S T O R E Drum-Sequencer-Clip
    
        sprintf(file_path, "tm/0-%d.tm", preset);        // generate filename
                        
        MUTEX_SDCARD_TAKE;  // Write to File             
                FILE_WriteOpen	( file_path,          16 );   
                FILE_WriteBuffer( (u8  *)&file_type,   4 ); //"SIGL" = 4 Positons                                                     
                FILE_WriteBuffer( (u8  *)&beat,     sizeof(store_t) );
                FILE_WriteBuffer( (u8  *)&Seq,      sizeof(Seq) );
                FILE_WriteBuffer( (u8  *)&SeqTic,   sizeof(SeqTic) );                                                               
                FILE_WriteClose	(); 
        MUTEX_SDCARD_GIVE;  // SD-Card is now free 4 access
        

    // S T O R E Trigger Matrix

        sprintf(file_path, "tm/tm-%d.tm", preset);        // generate filename
                
        MUTEX_SDCARD_TAKE;  // Write to File          
                FILE_WriteOpen	( file_path,          16 );   
                FILE_WriteBuffer( (u8  *)&file_type,   4 ); //"SIGL" = 4 Positons                                                     
                FILE_WriteBuffer( (u8  *)&MATRIX,   sizeof(MATRIX) );
                FILE_WriteBuffer( (u8  *)&CCMtx,    sizeof(CCMtx) );
                FILE_WriteBuffer( (u8  *)&tm,       sizeof(triggermatrix_t) );                                                                 
                FILE_WriteClose	(); 
        MUTEX_SDCARD_GIVE;  // SD-Card is now free 4 access

                        }
MIOS32_MIDI_SendDebugMessage("Preset Transfair Done"); }
}

void Note_Buffer(u8 track, u8 velocity, u8 note){   // Input buffer
    static u8  NoteCount[16]={};
    static s8  MelOctShiftFactor[16]={};
    static u8  NoteCalc[16]={};                     // incoming note + MelOctShiftFactor[0]
        
	 //Ocatave Shift
     MelOctShiftFactor[track] = 0;
     if(CCMtx[10][track] == 1) {MelOctShiftFactor[track] = MelOctShiftFactor[track] - 12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[9] [track] == 1) {MelOctShiftFactor[track] = MelOctShiftFactor[track] - 12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[8] [track] == 1) {MelOctShiftFactor[track] = MelOctShiftFactor[track] + 12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[7] [track] == 1) {MelOctShiftFactor[track] = MelOctShiftFactor[track] + 12;} //if(octaveshift button 3 = 1) {.....+Oct

	 NoteCalc[track] = note + MelOctShiftFactor[track];
	 if(NoteCalc[track] > 0 && NoteCalc[track] < 127){ // Only Note Numbers in Midi-Range 0-127
         
            if(velocity >= 1){ // Only Note On Messages
                                
                    // CLEAR NOTE BUFFER
                    if(NoteCount[track] == 0){ int notes; for(notes = 0; notes < 8; notes++) tm.NoteBuff[track][notes] = 127;}//set to Note Nr 127, which we filter later out
                    
                    //FILL  NOTE BUFFER
                    if(NoteCount[track] == 0) {tm.NoteBuff[track][0]  = NoteCalc[track];}
                    if(NoteCount[track] == 1) {tm.NoteBuff[track][1]  = NoteCalc[track];}          
                    if(NoteCount[track] == 2) {tm.NoteBuff[track][2]  = NoteCalc[track];}
                    if(NoteCount[track] == 3) {tm.NoteBuff[track][3]  = NoteCalc[track];}
                    if(NoteCount[track] == 4) {tm.NoteBuff[track][4]  = NoteCalc[track];}
                    if(NoteCount[track] == 5) {tm.NoteBuff[track][5]  = NoteCalc[track];}
                    if(NoteCount[track] == 6) {tm.NoteBuff[track][6]  = NoteCalc[track];}
                    if(NoteCount[track] == 7) {tm.NoteBuff[track][7]  = NoteCalc[track];}                                                                                       
                                       
                    // NOTE COUNTER 
                    NoteCount[track]++;} //(cheap Polyphony) counts from 0-7
                    //this numbers route the notes in their tracks, when it reaches 8 it begins from 0 again - note overflow
                    
            // Count Reset
            if(velocity == 0)                         { NoteCount[track] = 0; } 
            if(velocity >= 1 && NoteCount[track] >= 8){ NoteCount[track] = 0; } } //begin again from 0 when reaching max Count of 8 ingers on Keyboard = max Poly  
}//END HOOK


void BLM_LED(u32 element_id, u32 v, u32 h, u32 val) {
    static u8 led_mod_ix = 1;
    static u8 led_row_ix = 9;
    static u8 led_column_ix = 1;
    static u8 modify_led = 0;
    
    ////////////////////////////
    // calculate H - V - PINs //
    
         if( element_id == 0 ) {    // BLM16x16 LEDs
                                    led_mod_ix = h >> 2;
                                    led_row_ix = ((h&3) << 1) + ((v >> 3) & 1);
                                    led_column_ix = v & 0x7; //7
                                    modify_led = 1;}
      
    else if( element_id == 2 ) {   // VERTICAL = Y = 2   extra column LEDs
                                    led_mod_ix = 4;
                                    led_row_ix = (h&3) << 1;
                                    led_column_ix = h >> 2;
                                    modify_led = 1; }
      
      
    else if( element_id == 1 ) {    // HORIZONTAL = X = 1 extra row LEDs // Chn0, v >= 96, v <= 0111   // h == 0 && v >= 0x60 && v <= 0x6f
                                    v = v + 96; // ?
                                    led_mod_ix = 4;
                                    led_row_ix = 1 + ((v >> 1) & 6);
                                    led_column_ix = v & 3;
                                    modify_led = 1; }
      
    else if( element_id == 3 ) {    // SHIFT-BUTTON   // Chn15, v>=96, v>0111
                                    v = v + 96; // ?
                                    led_mod_ix = 4;
                                    led_row_ix = 1 + ((v >> 1) & 6);
                                    led_column_ix = 4 + (v & 3);
                                    modify_led = 1; }


    if( modify_led ) {  // set LEDs
            u8 led_mask = 1 << led_column_ix;
            
            if( val == 0 ) {        // Note Off or val == 0x00: clear both LEDs
            blm_scalar_led[led_mod_ix][led_row_ix][0] &= ~led_mask;
            #if BLM_SCALAR_NUM_COLOURS >= 2
            blm_scalar_led[led_mod_ix][led_row_ix][1] &= ~led_mask;
            #endif
          }
            else if( val == 1 ) {   // Velocity < 0x40: set green LED, clear red LED
            blm_scalar_led[led_mod_ix][led_row_ix][0] |= led_mask;
            #if BLM_SCALAR_NUM_COLOURS >= 2
            blm_scalar_led[led_mod_ix][led_row_ix][1] &= ~led_mask;
            #endif
          } 
            else if( val == 2 ) {   // Velocity < 0x60: clear green LED, set red LED
            blm_scalar_led[led_mod_ix][led_row_ix][0] &= ~led_mask;
            #if BLM_SCALAR_NUM_COLOURS >= 2
            blm_scalar_led[led_mod_ix][led_row_ix][1] |= led_mask;
            #endif
          } 
            else {                  // Velocity >= 0x60: set both LEDs
            blm_scalar_led[led_mod_ix][led_row_ix][0] |= led_mask;
            #if BLM_SCALAR_NUM_COLOURS >= 2
            blm_scalar_led[led_mod_ix][led_row_ix][1] |= led_mask;
            #endif
            }
            }
}
