#ifndef _APP_H
#define _APP_H

extern s32 SEQ_Init(u32 mode);
extern s32 SEQ_Reset(void);
extern s32 SEQ_Handler(void);
extern u8 Trigger_Matrix(u8 port, u8 note, u8 velocity, u16 step, u16 tic);
    #define PRIORITY_Trigger_Matrix	      ( tskIDLE_PRIORITY + 3 ) // 4: high //303 is not a task!!! no effect?
extern void APP_Init(void);
extern void APP_Background(void);
extern void APP_Tick(void);
extern void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package);
extern void APP_SRIO_ServicePrepare(void);
extern void APP_SRIO_ServiceFinish(void);
extern void APP_DIN_NotifyToggle(u32 pin, u32 pin_value);
extern void APP_ENC_NotifyChange(u32 encoder, s32 incrementer);
extern void APP_AIN_NotifyChange(u32 pin, u32 pin_value);

extern void Router(u16 ID, u16 H, u16 V, s16 value);

extern void BLM_LED(u32 element_id, u32 v, u32 h, u32 val);

s8 MatrixUse;   // SQ-Steps, SQ-Swing, TM-Router, TM-CC,


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCard
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 typedef struct storage {   // to optimize SD-Load-Time, each clips data is stored in this struct
     
        char    leader:1;       // Programchange able? - only 1 of 4 Song-Clips can send Programchanges via BLMatrix
        char    virgin:1;       // is there any data in the clip? need to display on a ButtonLed Matrix-Launcher   

        u16     bpm; 
        u8      rythm;          // 4x4=16, 5x3=15 usw... to calculate maximal duration per UI-matrix page
        u8      PAGE_Steps;     // calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat      
        u8      PAGE_loop[2];   // >Loop Length - END
        s8      PAGE_actual;    // Step PAGE, in 4/4 Mode one PAGE has 16 Step 
       
        u8      MainLoop;       // max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)
        u8      direction;      // > 303 PLACE-HOLDER - <      0: <, 1>, 2<>   SEQUENCER STEP-COUNTER-DIRECTION   
        u8      direct_start;   // > 303 PLACE-HOLDER - <      0: in beat.direction-mode:2 > start on start, 1: -//- > start on end
        
        u8      SWING_16th;
        u8      SWING_32th;
        u8      SWING_Switch;
                         
} store_t;

 store_t beat;     // Data for  beat.clips
 store_t beat_cpy;


 // Struct for different flags
 typedef struct flags {     // to optimize Memory usage and data, i fill all 1bit flags into a struct
   unsigned SRIO_Update : 1;// init 0   // flag.SRIO_Update // flag.flagname   for call a flag
   unsigned MenueUpdate: 1; // init 0   // flag.MenueUpdate // Menue will be updatet after a while
   unsigned Store : 1;      // init 0   // flag.Store       // Store Program after a while
   unsigned Load : 1;       // init 0   // flag.Load        // Load Program after a while
   unsigned Boot : 1;       // init 1   // flag.Boot        // only used once for a single operation
   unsigned PCLoad : 1;     // init 0   // flag.PCLoad      // ProgramChange via Midi received!
   unsigned Beat : 1;       // init 0   // flag.Beat        // Beat-Led-Status - Blink via SRIO
   unsigned NeedSync : 1;   // init 0   // flag.NeedSync    // Update Loop-Length and other Sequencer Variables
   unsigned FirstTic : 1;   // init 1   // flag.FirstTic    // Initalize Sequencer Sync and Init-Operations....
   unsigned LoadSYS: 1;     // init 1   // flag.LoadSYS     // Load SYS-Settings from SD after Startup
   unsigned LoadSong: 1;    // init 1   // flag.LoadSong    // Load first song after startup
   unsigned shift: 1;       // init 0   // flag.shift       // calculate time between press and release, on order to do different things
   unsigned shiftvalue: 1;  // init 0   // flag.shiftvalue  // pressed or not pressed = value
   unsigned ShiftPressed: 1;
   unsigned Update_LCD_s: 1;// init 0                       // normal LCD-Labeling back again in 2seconds
   u8 j10PinState[16];

}flag_t;

 flag_t flag;

#endif /* _APP_H */
