#include "cmios.h"
#include "pic18f452.h"

#include "../common/include/display.h"
#include "../common/include/tunnel.h"
#include "../common/include/core.h"
#include "../common/include/version.h"
#include "../common/include/curentdisplay.h"
#include "../common/include/mode.h"
#include "../common/include/address.h"


#include "include/types.h"

//source import

#include "src/debug.c"
#include "src/globals.c"
#include "src/wrapper.c"
#include "src/memory.c"
#include "src/general.c"
#include "src/timer.c"
#include "src/display.c"
#include "src/func.c"
#include "src/message.c"
#include "src/midi.c"
#include "src/notify.c"

/*! \mainpage Midibrett

\section sec_ps Program Sketch

\subsection tpc The program consists of the following files:

- debug.c
- display.c
- func.c
- globals.c
- general.c
- memory.c
- message.c
- midi.c
- notify.c
- timer.c
- wrapper.c

Every source file contains specific parts of the program, listed here:

debug.c:
Due to the missing debugging capabilities of the hardware
we had to write our own debugging functions that output the variable 
over MIDI. For every data type there is a different debug function. 

display.c:
Contains MIOS DISPLAY_Tick function of c skeleton, as well as all functions
that realize printing anything on the display. Those functions are only
called upon during DISPLAY_Tick. Display updates are handled through global
variables, that determine which parts of the display have to be updated (global variable "update").

func.c:
Contains a collection of functions that is meant to be expanded by the
commited user of the "MIDIbox GLCD". Here you find a collection of standard
functions that are implemented differently in every synthesizer and thus have
to be custom made for every device. These functions include tasks like
converting the formats between edit buffers and the parameter values of the
"MIDI Plank", readying Sysex Strings to be sent by putting in single values at
the right position in the right format, and calculating checksums for the edit
buffers.

globals.c:
Creates all global variables, which are declared in globals.h.

general.c:
Realizes complete initialization of the "MIDIbox GLCD" through the MIOS
Init-Function, including global variables. Other Functions from the C-Skeleton
are the MIOS Tick, which only contains routines for initializing the Bankstick
(for debugging/developing purposes only), and all unused
functions from the C-Skeleton.
Contains Init functions for the different Menu Layers (also called modes:
device, modul, parameter).
Handles reading and writing all data relevant to the menus from and to
bankstick.
Handles edit buffer dumps.

memory.c:
Contains wrapper functions for continuous adressation of bankstick (needed because the bankstick is connected via I2C and the chips have to be switched) and the edit buffer array.

message.c:
Contains functions for sending the edit buffer and for creating MIDI
Messages for all possible parameter configurations.

midi.c:
Handles receiving MIDI Transmissions and answering.

notify.c:
Contains MIOS C-Skeleton functions DIN_NotifyToggle and ENC_NotifyChange.
Handles Button presses and encoder movements, including calculation of MIDI
values.

timer.c:
Handles time dependent events like querying external devices and waiting for an answer.
This function is periodically called by MIOS. The frequency has to be initialized with MIOS_Timer_Set

wrapper.c:
These functions are used to only utilize one general display function per task
for all displays. For this, a function parameter "display" was added through
which the receiving display is chosen.



Following include files need special explanation:

types.h:
Global type definitions for special data structures.




\section sec_general General concepts


\subsection nav Navigating through the menu structures:

The navigation through the menus is realized in several functions, which are
distributed through seperate source files. If the user presses a button to
change menus, it is registered in the DIN_NotifyToggle function of notify.c,
the corresponding Init-Function (to be found in main.c) is called. Here the
global variable for the display update is set to "refresh complete display",
and the global variable for operating mode (mode) is set to the corresponding
menu layer. The status for the global display update variable is checked in
DISPLAY_Tick, and if set to "refresh complete display", the corresponding
display function (to be found in display.c) is called, and so the new menu is
printed on the display.


\subsection ma Memory Access:

The MIOS Bankstick normally consists of 8 chips which have to be adressed
seperately over the I2C Bus. In the "MIDBox GLCD" there are two wrapper functions (readBank and
writeBank, to be found in memory.c) to handle the Eprom like one big chip. Those
Functions need a "long" variable as an adress, in which the bankchip is stored
in the 5th nibble (counting from lsb upward). The advantage is that adressing
the Eprom now works continuosly, the disadvantage is that "long" variables are
needed for the adress, and also for every variable (counters, for-loops)
that is added to the adress.
In the "MIDIbox GLCD" the memory is even expanded further through another bankstick module consisting of 4 more banksticks, which is addressed by switching DOUT Pin 7. This is also included in the memory.c functions, so that the highest memory address allowed now is 0xBFFFF.


\subsection mm Memory Map:

The memory is organized like this (definitions for adresses to be found in
\common\include\adress.h):
It starts at BASE adress. The first Block consists of the Device structure,
(for 16 devices) which consists of the name for the menu plus an adress that
points to the dynamic part of the Eprom, where different sysex strings for that
device are stored. The second block consists of the Modul structure (64 Modules
for each Device), which is organized in the same way as the Device structure.
The third block consists of the Parameter structures, and is the biggest part
of the Eprom. Altogether there are 16384 Parameters (16 Devices with each
4 Banks of 16 Modules, with each 16 Parameters. 16x4x16x16=16384).
Each Parameter structure consists of 30 bytes, 10 bytes for it's name
plus 20 bytes for several settings and values, as found in \include\types.h.
The fourth and last block of the memory is the dynamic memory for all the
devices, modules and parameters. This part of the memory is for all the sysex
strings associated with each device/module/parameter. It is to be found in the 
second bankstick module in the address range 0x80000-0xBFFFF (16k for each device).


\subsection hm Handling MIDI Values for sendMessage and writeBar functions:

When entering a parameter page, the starting MIDI Value for every parameter is
read from the bankstick (or the edit buffer, if it exists) into the array
potis[0-15] for all of the 16 encoders. potis[16] consists of 16 status bits,
one for each encoder, that determines, which encoder has been handled. This
field is interpreted in the writeBar function to only update handled encoders.
potis[17] consists of 16 status bits for the knob function of each encoder, and
is interpreted in the MIOS DIN_NotifyToggle. This is to prevent sending
messages while releasing the knob after entering the parameter page.

Once the values for each parameter are stored in the potis[] array, they are
only manipulated during turning an encoder or pushing a knob in the
corresponding functions DIN_NotifyToggle and ENC_NotifyChange in notify.c.
This manipulation of the values depends on several fields of the parameter
structure (like negative minimum, min, max or scale). Then the values are
transported to the functions sendMessage and writeBar, to be sent or displayed.
It has to be noted, that the potis[] array always contains the MIDI values for
each encoder, which are directly sent over the MIDI interface. For displaying
those values correctly (7/14Bit, negative or scaled), those MIDI values have to
be interpreted again in the writeBar function, by looking up the corresponding
fields in the parameter structure during the Display_Tick function, in which
the writeBar function is called.

 */
