/*
 * MIDI.h
 *
 *  Created on: 17.10.2012
 *      Author: ingodebus1
 */

#ifndef MIDI_H_
#define MIDI_H_

// MIDI Bytes
#define NOTEON  0x90		// Note On Channel 1
#define NOTEOFF 0x80		// Note Off Channel 1
#define POLYPR	0xA0
#define CONTRL	0xB0
#define PROGCH	0xC0
#define CHANPR	0xD0
#define PITCHB	0xE0
#define SYSEX   0xF0
#define EOX	    0xF7
#define REALT	0xF8

// MIDI CCs
#define MODWHL	0x01
#define BREATH	0x02
#define VOLUME	0x07
#define EXPR	0x0B
// Pseudo-CCs
#define CC_AT	121		//Aftertouch
#define CC_PBUP	122		//Pitch Bend Up
#define CC_PBDN	123		//Pitch Bend Down
#define CC_OFF	127		//Off



#define FALSE	0
#define TRUE	1
#define RESET	0
#define SET		1

#define MAX(x,y)	( ((x)>(y)) ? (x) : (y) )

#endif /* MIDI_H_ */
