/*
 * MIOS32 Wavedrum MIDI
 * Version 1.0
 * ==========================================================================
 *
 *  Copyright (C) 2013 Ingo Debus (<your email address>)
 *  Licensed for personal non-commercial use only.
 *  All other rights reserved.
 * 
 * ==========================================================================
 */

/*
 TODO:
ADC_IRQHandler(), case TRIGD:
 unschoen: wenn die "Smart Glitch Suppression anschlaegt, wird bi erst auf 0, am Ende des case dann per bi++ auf 1 gesetzt.
 besser bi++ direkt nach Beschreiben des Buffers und ggfls auch einmal wenn der Buffer fertig beschrieben wurde (wegen Debounce)
ADC_Init()
 Zeile 	LPC_PINCON->PINSEL0 |= 0x0F000000;	 P0.12~13, A0.6~7, function 11  entfernen, ist kompletter Blödsinn

*/

#include "LPC17xx.h"
#include <mios32.h>
#include "adc.h"
#include "patch.h"
#include "sysex.h"
#include "params.h"
#include "MIDI.h"


vu8 trig_state[ADC_NUM];
vu16 bi[ADC_NUM];
vu32 buffer[ADC_NUM][BUF_SIZE];
vs32 adc_min[ADC_NUM];
vs32 adc_max[ADC_NUM];
#ifdef DUMB_GLITCH_SUPPRESSION
vu8 abv_thr_cnt[ADC_NUM];	//count the values that are above threshold, to filter out glitches
#endif
#ifdef SMART_GLITCH_SUPPRESSION
vu8 blw_thr_cnt[ADC_NUM];	//count the values that are below threshold, to filter out glitches
//vu8 glitch_flag;
#endif
u8 DebounceFlag[ADC_NUM];
#ifdef SENSE_PRESSURE		//output pressure data
vu8 prs_state;
vu16 pressure;
#endif

extern s32 zero_lvl[ADC_NUM];
extern u16 l_thresh[ADC_NUM];
extern u16 h_thresh[ADC_NUM];

/******************************************************************************
** Function name:		ADC_IRQHandler
**
** Descriptions:		ADC interrupt handler
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void ADC_IRQHandler (void)  
{
	u32 regVal;
	u32 ADC0Value = 0;
	u8 adc_chnl = 0;
	u8 iir_factor;
  
	regVal = LPC_ADC->ADSTAT;		/* Read ADC will clear the interrupt */
	if ( regVal & 0x0000FF00 )	/* check OVERRUN error first */
	{
		regVal = (regVal & 0x0000FF00) >> 0x08;
		/* if overrun, just read ADDR to clear */
		/* regVal variable has been reused. */
		switch ( regVal )
		{
			case 0x01:
				regVal = LPC_ADC->ADDR0;
			break;
			case 0x02:
				regVal = LPC_ADC->ADDR1;
			break;
			case 0x04:
				regVal = LPC_ADC->ADDR2;
			break;
			case 0x08:
				regVal = LPC_ADC->ADDR3;
			break;
			case 0x10:
				regVal = LPC_ADC->ADDR4;
			break;
			case 0x20:
				regVal = LPC_ADC->ADDR5;
			break;
			case 0x40:
				regVal = LPC_ADC->ADDR6;
			break;
			case 0x80:
				regVal = LPC_ADC->ADDR7;
			break;
			default:
			break;
		}
		LPC_ADC->ADCR &= 0xF8FFFFFF;	/* stop ADC now */
		return;
	}
	
	MIOS32_BOARD_J10_PinSet(0, 1);	//set J10:D0 aka P2.2 (LPCXPresso Board Pin 44) to 1

	if ( regVal & ADC_ADINT )
	{
		switch ( regVal & 0xFF )	/* check DONE bit */
		{
			case 0x01:
				ADC0Value = ( LPC_ADC->ADDR0 >> 4 ) & 0xFFF;
				adc_chnl = 0;
				LPC_ADC->ADCR &= 0xFFFFFF00;
				LPC_ADC->ADCR |= (1 << 1);		/* switch to channel 1 */
			break;
			case 0x02:
				ADC0Value = ( LPC_ADC->ADDR1 >> 4 ) & 0xFFF;
				adc_chnl = 1;
				LPC_ADC->ADCR &= 0xFFFFFF00;
#ifdef SENSE_PRESSURE												//meanwhile output pressure data
				if(trig_state[0] == TRIGD || trig_state[1] == TRIGD || prs_state == WAIT)
					LPC_ADC->ADCR |= (1 << 0);	/* no pres sensor if one piezo channel is triggered or pres data isn't processed yet, switch to channel 0 */
				else
					LPC_ADC->ADCR |= (1 << 2);	/* switch to channel 2 */
#else
				LPC_ADC->ADCR |= (1 << 0);		/* switch to channel 0 */
#endif
				break;
#ifdef SENSE_PRESSURE												//meanwhile output pressure data
			case 0x04:
				pressure = ( LPC_ADC->ADDR2 >> 4 ) & 0xFFF;
				adc_chnl = 2;
				prs_state = WAIT;
				LPC_ADC->ADCR &= 0xFFFFFF00;
				LPC_ADC->ADCR |= (1 << 0);		/* switch to channel 0 */
			break;
#endif
			default:
			break;
		}

		LPC_ADC->ADCR &= ~( 4 << 24 );
		LPC_ADC->ADCR |=  ( 4 << 24 );		/* Start conversion when the edge selected by bit 27 occurs on MAT0.1 */

#ifdef SENSE_PRESSURE												//meanwhile output pressure data
		if(adc_chnl == 2)	//if pressure data were collected, we're done now
		{
			MIOS32_BOARD_J10_PinSet(0, 0);	//set J10:D0 aka P2.2 (LPCXPresso Board Pin 44) to 0
			return;
		}
#endif

//		if(ADC0Value > h_thresh || ADC0Value < l_thresh)
//			LPC_GPIO2->FIOSET  = 0x00000001;		/* turn on the LED */
//		else
//			LPC_GPIO2->FIOCLR  = 0x00000001;		/* turn off the LED */

		switch(trig_state[adc_chnl])
		{
			case READY:		//waiting for trigger
				if(DebounceFlag[adc_chnl])						//still waiting for end of debounce
				{
					bi[adc_chnl]++;
					if(bi[adc_chnl] >= PATCH_ReadWord(DEBOUNCE_TIME))
					{
						DebounceFlag[adc_chnl] = RESET;
						bi[adc_chnl] = 0;
					}
				}
				else if(ADC0Value > h_thresh[adc_chnl] || ADC0Value < l_thresh[adc_chnl])	//got past threshold, start recording
				{
					trig_state[adc_chnl] = TRIGD;
					
					MIOS32_BOARD_J10_PinSet(1, 1);	//set J10:D1 aka P2.3 (LPCXPresso Board Pin 45) to 1

					//record/process first value
					buffer[adc_chnl][bi[adc_chnl]] = ADC0Value;	//hier kann statt bi[adc_chnl] auch einfach 0 hin!
					bi[adc_chnl]++;
					if(ADC0Value < adc_min[adc_chnl])	//kann man hier nicht einfach adc_min und adc_max initialisieren?
						adc_min[adc_chnl] = ADC0Value;
					if(ADC0Value > adc_max[adc_chnl])
						adc_max[adc_chnl] = ADC0Value;
#ifdef DUMB_GLITCH_SUPPRESSION
					abv_thr_cnt[adc_chnl]++;	//count values that are above threshold (this is the first one)
#endif
				}
				else //adjust offset
				{
					iir_factor = PATCH_ReadByte(OFFSET_FILTER);		//0..255
					zero_lvl[adc_chnl] = (iir_factor * ADC0Value + (256 - iir_factor) * zero_lvl[adc_chnl] + 128) / 256;
				}

			break;
			case TRIGD:		//recording signal into buffer
				if(bi[adc_chnl] < BUF_SIZE)	//buffer not completely filled, continue recording
				{
					buffer[adc_chnl][bi[adc_chnl]] = ADC0Value;
#ifdef DUMB_GLITCH_SUPPRESSION
					if(ADC0Value > h_thresh[adc_chnl] || ADC0Value < l_thresh[adc_chnl])
						abv_thr_cnt[adc_chnl]++;	//count values that are above threshold
#endif
#ifdef SMART_GLITCH_SUPPRESSION
					if(ADC0Value <= h_thresh[adc_chnl] && ADC0Value >= l_thresh[adc_chnl])
						blw_thr_cnt[adc_chnl]++;	//count values that are below threshold

					if((bi[adc_chnl] < START_ZONE) && (blw_thr_cnt[adc_chnl] > PATCH_ReadByte(BLW_THR_CNT_MAX)))
					{
						trig_state[adc_chnl] = READY;	//too many samples below threshold in start zone, it's a glitch, stop recording
						adc_min[adc_chnl] = adc_max[adc_chnl] = zero_lvl[adc_chnl];	//init min/max detector
#ifdef DUMB_GLITCH_SUPPRESSION
						abv_thr_cnt[adc_chnl] = 0;		//init above-threshold counter
#endif
						blw_thr_cnt[adc_chnl] = 0;		//init below-threshold counter
						bi[adc_chnl] = 0;				//FEHLTE!!
						MIOS32_BOARD_J10_PinSet(1, 0);	//set J10:D1 aka P2.3 (LPCXPresso Board Pin 45) to 0
//						glitch_flag = adc_chnl;
					}
					else 
#endif
					{
						if(ADC0Value < adc_min[adc_chnl])
							adc_min[adc_chnl] = ADC0Value;
						if(ADC0Value > adc_max[adc_chnl])
							adc_max[adc_chnl] = ADC0Value;
					}
				}
				else				//buffer filled, stop recording
				{
					trig_state[adc_chnl] = WAIT;
					DebounceFlag[adc_chnl] = SET;
					
					MIOS32_BOARD_J10_PinSet(1, 0);	//set J10:D1 aka P2.3 (LPCXPresso Board Pin 45) to 0
				}
				bi[adc_chnl]++;
			break;
			case WAIT:		//waiting until event is processed in main routine
				if(DebounceFlag[adc_chnl])
				{
					bi[adc_chnl]++;
					if(bi[adc_chnl] >= PATCH_ReadWord(DEBOUNCE_TIME))
					{
						DebounceFlag[adc_chnl] = RESET;
						bi[adc_chnl] = 0;
					}
				}
			break;
		}
	}
	// toggle the state of LED (allows to measure the execution speed with a scope)
//	MIOS32_BOARD_LED_Set(1, ~MIOS32_BOARD_LED_Get());
	MIOS32_BOARD_J10_PinSet(0, 0);	//set J10:D0 aka P2.2 (LPCXPresso Board Pin 44) to 0
	return;
}


/*****************************************************************************
** Function name:		ADCInit
**
** Descriptions:		initialize ADC channel
**
** parameters:			ADC clock rate
** Returned value:		true or false
** 
*****************************************************************************/
void ADCInit( u32 ADC_Clk )
{
	u32 pclkdiv, pclk;

	trig_state[0]   = trig_state[1]   = ADCOFF;
	bi[0]           = bi[1]           = 0;
	DebounceFlag[0] = DebounceFlag[1] = RESET;
	prs_state = READY;

	/* Enable CLOCK into ADC controller */
	LPC_SC->PCONP |= (1 << 12);

	/* all the related pins are set to ADC inputs, AD0.0~7 */
//	LPC_PINCON->PINSEL0 |= 0x0F000000;	/* P0.12~13, A0.6~7, function 11 */
	LPC_PINCON->PINSEL1 &= ~0x003FC000;	/* P0.23~26, A0.0~3, function 01 */
	LPC_PINCON->PINSEL1 |= 0x00154000;
	LPC_PINCON->PINSEL3 |= 0xF0000000;	/* P1.30~31, A0.4~5, function 11 */

	/* By default, the PCLKSELx value is zero, thus, the PCLK for
	all the peripherals is 1/4 of the SystemFrequency. */
	/* Bit 6~7 is for UART0 */
	pclkdiv = (LPC_SC->PCLKSEL0 >> 6) & 0x03;
	switch ( pclkdiv )
	{
		case 0x00:
		default:
//			pclk = SystemCoreClock/4;
			pclk = MIOS32_SYS_CPU_FREQUENCY/4;
		break;
		case 0x01:
//			pclk = SystemCoreClock;
			pclk = MIOS32_SYS_CPU_FREQUENCY;
		break;
		case 0x02:
//			pclk = SystemCoreClock/2;
			pclk = MIOS32_SYS_CPU_FREQUENCY/2;
		break;
		case 0x03:
//			pclk = SystemCoreClock/8;
			pclk = MIOS32_SYS_CPU_FREQUENCY/8;
		break;
	}

	LPC_ADC->ADCR = ( 0x01 << 0 ) | 	/* SEL=1,select channel 0 on ADC0 */
		( ( pclk  / ADC_Clk - 1 ) << 8 ) |  /* CLKDIV = Fpclk / ADC_Clk - 1 */ 
		( 0 << 16 ) | 		/* BURST = 0, no BURST, software controlled */
		( 0 << 17 ) |  		/* CLKS = 0, 11 clocks/10 bits LAUT DATENBLATT IST BIT 17 RESERVED!!!*/
		( 1 << 21 ) |  		/* PDN = 1, normal operation */
		( 4 << 24 ) |  		/* Start conversion when the edge selected by bit 27 occurs on MAT0.1 GEÄNDERT, WAR: START = 0 A/D conversion stops */
		( 0 << 27 );		/* EDGE = 0 (CAP/MAT signal falling,trigger A/D conversion) */

//	LPC_ADC->ADINTEN = 0x1FF;		/* Enable all interrupts */
//	NVIC_EnableIRQ(ADC_IRQn);
//	MIOS32_IRQ_Install(ADC_IRQn, MIOS32_IRQ_PRIO_MID);
	MIOS32_IRQ_Install(ADC_IRQn, MIOS32_IRQ_PRIO_HIGH);
}


/*********************************************************************************
**                            End Of File
*********************************************************************************/
