/*
 *  params.h
 *  
 *
 *  Created by Ingo on 06.02.13.
 *  Copyright 2013 __MyCompanyName__. All rights reserved.
 *
 */

// Byte addresses of parameters

#define NAME			0		//16 chars
#define RIM_MIDICH		16		//MIDI channel for Rim
#define HEAD_MIDICH		17		//MIDI channel for Head
#define PRES_MIDICH		18		//MIDI channel for Pressure Sensor
#define RIM_NOTE		19		//MIDI note number for Rim
#define HEAD_NOTE		20		//MIDI note number for Head
#define PRES_CC			21		//MIDI cc for Pressure Sensor
#define THRESH			22		//adc value has to go beyond this threshold (in ADC units) to trigger a note
#define ABV_THR_CNT_MAX	23		//at least so many ADC values need to be above threshold, otherwise it's considered a glitch
#define RIM_VEL_SCALE	24
#define HEAD_VEL_SCALE	25
#define BLW_THR_CNT_MAX	26		//max number of ADC values that are allowed to be below threshold in start zone, otherwise it's considered a glitch
#define SENDWAVE		27		//if !=0, wave buffer is sent as Sysex
#define DEBOUNCE_TIME	28		//debounce time, in multiples of SAMPLE_INTERVAL*ADC_NUM (2 bytes)
#define OFFSET_FILTER	30

// "Read-only" parameters

#define ZEROPRS			181		//zero pressure (2 bytes)
#define DETMIN			183		//detected min (2 bytes)
#define DETMAX			185		//detected max (2 bytes)
#define ZERO0			187		//zero adc0 (2 bytes)
#define ZERO1			189		//zero adc1 (2 bytes)
#define ACTIVE_CHNL		191		//adc from which the waveform was recorded 0=Rim, 1=Head
#define WAVE0			192		//read-only area for waveform buffer (64 bytes)
#define WAVE63			255		//read-only area for waveform buffer (64 bytes)


// Compiler options

#define SENSE_PRESSURE			//output pressure data
