#ifndef _APP_H
#define _APP_H
extern void APP_Init(void);
extern void APP_Background(void);
extern void APP_Tick(void);
extern void APP_MIDI_Tick(void);
extern void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package);
extern void APP_SRIO_ServicePrepare(void);
extern void APP_SRIO_ServiceFinish(void);
extern void APP_DIN_NotifyToggle(u32 pin, u32 pin_value);
extern void APP_ENC_NotifyChange(u32 encoder, s32 incrementer);
extern void APP_AIN_NotifyChange(u32 pin, u32 pin_value);

extern u8  PageFirst;
extern u8  MSQ_Loop_Length_Set[8]; //>Loop Length - END
extern u8  Page;       // Step Page, in 4/4 Mode one Page has 16 Step     
extern u16 StepPerPage; //calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat  
extern u8  direction;  //0: <, 1>, 2<>   SEQUENCER STEP-COUNTER-DIRECTION   
extern u8  LoopLengthBtn; //Loop-Set 0 or 1 ---to call 2 different Loop Length, i would say, 0: short, 1: long  
extern u8  SyncType;   //0 Bar Sync,   1;Main Sync   
extern s16 SyncRate;   //0-15 when SyncType is 0 - then this is the value off BARs which it Syncs when Direction or Loop Switching...   
extern u16 MainLoop;   //max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)
extern u8 SyncFlag;
extern u8 StepOffset;
extern u8 intro;  //when pressing Play, then it starts directly @ saved loop posi, or run from 0 until it reaches loop posi and then it loops - intro!

extern u8  Seq[18][256];
extern u8  SeqTic[18][256];
extern u8  SwingAmmountFactor8;
extern u8  SwingAmmountFactor16;
extern u16 song_step_pos_counter;

extern s16 MainDelay; //the main TIC-Delay

extern s16 BaseTic;  // 128th    12    Dotted 128th     18   128th Triplet     8
extern s16 Tic;  //32x12=384 tics between 2 Notes
extern s8  PpqnDivider;
extern u8  BPM;
extern s16 TicSend;
extern s16 StepSend;
extern u16 Last[8]; //calculated Last Step
extern s8 SongStep;

extern u8 MtxPartNr;

#endif /* _APP_H */
